/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "TaskLocalStorage.h"


HMMERTaskLocalData::HMMERTaskLocalData()
{
    sre_randseed = 42;
    rnd = 0;
    rnd1 = 0;
    rnd2 = 0;
}

struct HMMERTaskLocalData *getHMMERTaskLocalData() {
    return GB2::TaskLocalData::current();
}


namespace GB2 {

QHash<qint64, struct HMMERTaskLocalData*> TaskLocalData::data;
QThreadStorage<ContextIdContainer*> TaskLocalData::tls;
QMutex TaskLocalData::mutex;


HMMERTaskLocalData* TaskLocalData::current(){
    static HMMERTaskLocalData def;

    ContextIdContainer* idc = tls.localData();
    if (idc!=NULL){
        mutex.lock();
        HMMERTaskLocalData* res = data.value(idc->contextId);
        mutex.unlock(); 
        assert(res!=NULL);
        return res;
    } else {
        return &def;
    }
}

void TaskLocalData::initializeHMMContext(qint64 contextId){
    assert(!tls.hasLocalData());
    
    ContextIdContainer* idc = new ContextIdContainer(contextId);
    tls.setLocalData(idc);
    
    mutex.lock();    
    data[contextId] = new HMMERTaskLocalData();
    mutex.unlock();
}

void TaskLocalData::bindToHMMContext(qint64 contextId){
    assert(!tls.hasLocalData());

    ContextIdContainer* idc = new ContextIdContainer(contextId);
    tls.setLocalData(idc);
}


qint64 TaskLocalData::detachFromHMMContext() {
    ContextIdContainer *idc = tls.localData();
    assert(idc!=NULL);
    qint64 contextId = idc->contextId;
    tls.setLocalData(NULL); //automatically deletes prev data
    return contextId;
}

void TaskLocalData::freeHMMContext() {
    qint64 contextId = detachFromHMMContext();

    mutex.lock();
    
    HMMERTaskLocalData* v = data.value(contextId);
    assert(v!=NULL);
    int n = data.remove(contextId);
    Q_UNUSED(n);
    assert(n == 1);
    delete v;
    
    mutex.unlock();
}

}//namespace

