/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SITECON_SEARCH_TASK_H_
#define _GB2_SITECON_SEARCH_TASK_H_

#include "SiteconAlgorithm.h"

#include <core_api/LRegion.h>
#include <datatype/AnnotationData.h>
#include <util_tasks/SequenceWalkerTask.h>

#include <QtCore/QMutex>

namespace GB2 {

class SiteconSearchResult {
public:
    SiteconSearchResult() : complement(false), psum(-1), err1(0), err2(1){}

    SharedAnnotationData toAnnotation(const QString& name) const {
        SharedAnnotationData data;
        data = new AnnotationData;
        data->name = name;
        data->location.append(region);
        data->aminoStrand = TriState_No;
        data->complement = complement;
        if (!modelInfo.isEmpty()) {
            data->qualifiers.append(Qualifier("Sitecon-model", modelInfo));
        }
        data->qualifiers.append(Qualifier("psum", QString::number(psum)));
        data->qualifiers.append(Qualifier("error_1", QString::number(err1, 'g', 4)));
        data->qualifiers.append(Qualifier("error_2", QString::number(err2, 'g', 4)));
        return data;
    }

    static QList<SharedAnnotationData> toTable(const QList<SiteconSearchResult>& res, const QString& name)
    {
        QList<SharedAnnotationData> list;
        foreach (const SiteconSearchResult& f, res) {
            list.append(f.toAnnotation(name));
        }
        return list;
    }


    LRegion region;
    bool    complement;
    float   psum;
    float   err1;
    float   err2;
    QString modelInfo;
};

class SiteconSearchTask : public Task, public SequenceWalkerCallback {
    Q_OBJECT
public:
    SiteconSearchTask(const SiteconModel& model, const char* seq, int len, DNATranslation* complTT, bool complOnly, int minScore);
    
    virtual void onRegion(SequenceWalkerSubtask* t, TaskStateInfo& ti);
    QList<SiteconSearchResult> takeResults();

private:
    void addResult(const SiteconSearchResult& r);

    QMutex                      lock;
    SiteconModel                model;
    int                         minScore;
    bool                        complOnly;
    QList<SiteconSearchResult>  results;
};

}//namespace

#endif
