/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DI_PROPERTIES_H_
#define _GB2_DI_PROPERTIES_H_

#include <QtCore/QMap>
#include <QtCore/QList>
#include <QtCore/QString>

#include <assert.h>

namespace GB2 {

class DiProperty;
class DinucleotitePropertyRegistry {
public:
    DinucleotitePropertyRegistry();
    ~DinucleotitePropertyRegistry();

    QList<DiProperty*> getProperties() const {return props;}

private:
    void registerProperty(const QString& str);
    QList<DiProperty*> props;
};

class DiProperty {

public:
    //todo: default val;

    QMap<QString,QString>   keys;
    float                   original[16];
    float                   normalized[16];
    float                   average;
    float                   sdeviation;

    float getOriginal(char c1, char c2) const {return original[index(c1, c2)];}
    float getNormalized(char c1, char c2) const {return normalized[index(c1, c2)];}

    static int inline index(char c1, char c2);
    static int inline index(char c);
};

int DiProperty::index(char n1, char n2) {
    int idx = (index(n1) << 2) + index(n2);
    assert(idx >= 0 && idx < 16);
    return idx;
}

int DiProperty::index(char c) {
    if (c == 'A') { return 0; }
    if (c == 'C') { return 1; }
    if (c == 'G') { return 2; }
    if (c == 'T' || c == 'U') {return 3;}
    return 0; //default is 'A'
}
}//namespace

#endif
