/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_PALETTE_H_
#define _GB2_WORKFLOW_PALETTE_H_

#include <workflow/WorkflowModel.h>
#include <workflow/WorkflowRegistry.h>

#include <QtGui/QAction>
#include <QtGui/QTreeWidget>

namespace GB2 {
using namespace Workflow;
class WorkflowDesignerService;
class WorkflowView;
class WorkflowScene;


class WorkflowPalette : public QTreeWidget
{
    Q_OBJECT

public:
    static const QString MIME_TYPE;

    WorkflowPalette(WProtoRegistry* reg, QWidget *parent = 0);
    QMenu* createMenu(const QString& name);

    QVariant saveState() const;
    void restoreState(const QVariant&);

public slots:
    void resetSelection();

signals:
    void processSelected(Workflow::ActorPrototype*);
    
protected:
    void contextMenuEvent(QContextMenuEvent *e);
    void mouseMoveEvent ( QMouseEvent * event );
    void mousePressEvent ( QMouseEvent * event );
    void leaveEvent ( QEvent * event );

private slots:
    void handleItemAction();
    void sl_selectProcess(bool checked = false);
    void rebuild();

private:
    QTreeWidgetItem* createItemWidget(QAction* a);
    QAction* createItemAction(Workflow::ActorPrototype* item);
    void setContent(WProtoRegistry*);
private:
    QMap<QString,QList<QAction*> > categoryMap;
    QMap<QAction*, QTreeWidgetItem*> actionMap;
    QTreeWidgetItem *overItem;
    QAction* currentAction;
    QPoint dragStartPosition;
    friend class PaletteDelegate;
};


}//namespace

Q_DECLARE_METATYPE(QAction *)
Q_DECLARE_METATYPE(GB2::Workflow::ActorPrototype *)

#endif
