/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_EDITOR_H_
#define _GB2_WORKFLOW_EDITOR_H_

#include <workflow/WorkflowModel.h>
#include <workflow/Schema.h>
#include <ui/ui_WorkflowEditorWidget.h>

namespace GB2 {
using namespace Workflow;
class WorkflowView;
class IterationListWidget;
class ActorCfgModel;

class WorkflowEditor : public QWidget, Ui_WorkflowEditorWidget
{
    Q_OBJECT
public:

    WorkflowEditor(WorkflowView *parent);

    QVariant saveState() const;
    void restoreState(const QVariant&);

    Iteration getCurrentIteration() const;

signals:
    void iterationSelected();

public slots:
    void editActor(Actor*);
    void editPort(Port*);
    void setDescriptor(Descriptor* d, const QString& hint = QString());
    void edit(Configuration* subject);
    void selectIteration(int id);
    void reset();
    void commit();
    void resetIterations();
    void commitIterations();
    
protected:

    //void commitData(const QString& name, const QVariant& val);
    

private slots:
    void finishPropertyEditing();
    void updateIterationData();
    void handleDataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight);
    void editingLabelFinished();
    void sl_showPropDoc();

private:
    IterationListWidget* iterationList;
    WorkflowView* owner;
    ConfigurationEditor* custom;
    QWidget* customWidget;
    Configuration* subject;
    Actor* actor;
    friend class SuperDelegate;
    ActorCfgModel* actorModel;
};


}//namespace

#endif
