/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_ITEM_STYLE_H_
#define _GB2_WORKFLOW_ITEM_STYLE_H_

#include <QtGui/QGraphicsScene>
#include <QtGui/QGraphicsItem>
#include <QtGui/QTextDocument>

namespace GB2 {

    class WorkflowProcessItem;

    const qreal PI = 3.141596;
    const qreal R = 30;
    const qreal A = 8;


    class ItemViewStyle : public QGraphicsItem {
    public:
        virtual void refresh() {}
    protected:
        WorkflowProcessItem* owner;
    };

    class SimpleProcStyle : public ItemViewStyle {
    public:
        SimpleProcStyle(WorkflowProcessItem* pit);
        QRectF boundingRect(void) const;
        QPainterPath shape () const;
        void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 );
    };

    class ExtendedProcStyle : public ItemViewStyle {
    public:
        ExtendedProcStyle(WorkflowProcessItem* pit);
        QRectF boundingRect(void) const {return bounds;}
        QPainterPath shape () const;
        void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 );
        virtual void refresh();
    private:
        QTextDocument* doc;
        QRectF bounds;
    };

}//namespace

#endif
