/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TEST_VIEW_REPORTER_H_
#define _GB2_TEST_VIEW_REPORTER_H_

#include "TestViewController.h"

#include <core_api/MainWindow.h>
#include <ui/ui_Reporter.h>

#include <QtGui/QTreeWidgetItem>


namespace GB2 {

    class TVTSItem;
    class TVTestItem;
    

    class TestViewReporter : public  MWMDIWindow, Ui::Reporter {
     Q_OBJECT

 protected:
    virtual bool onCloseEvent();

 public:

    TestViewReporter(TestViewController* parent,QTreeWidget* tree=NULL,int runTime=NULL);

    virtual void setupMDIToolbar(QToolBar* tb);
    virtual void setupViewMenu(QMenu* n);
 
 private:
    const QString prepareHTMLText(QTreeWidget* tree=NULL,int runTime=NULL);
     
    const QString getHTMLNoTests();
    const QString getHTMLHead();
    const QString getHTMLStyle();
    const QString getHTMLFirstPart(const char *info1=NULL, const char *info2=NULL);
    const QString getHTMLStaticInfo(int data);
    const QString getHTMLStaticInfo(QString* data);
    const QString getHTMLStaticInfo(char *info1=NULL);
    const QString getHTMLRuntime(int data);
    const QString getHTMLStatusBar(int data, bool norun=false);
    const QString getHTMLEndOfStaticBar();
    const QString getHTMLLastPart(QTreeWidget* tree);
    const QString getHTMLErrorTables(QTreeWidget* tree);
    const QString getHTMLSuiteName(TVTSItem* Suite);
    const QString getHTMLErrorList(QList<TVTestItem*> failedTests,int* index=NULL);
    const QString getHTMLTestsTexts(QList<TVTestItem*> failedTests,int* index);

    bool setColorInTestText(QString* inputData=NULL);

    QList<TVTestItem*> getFailedTests(TVTSItem* Root);
    bool saveAs(const QString url,const QString data);
   
    QString curReportText;
    TestViewController* curParent;
    
    QAction* save;
    private slots:
        void sl_save();
};

}
#endif
