/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TEST_RUNNER_TASK_H_
#define _GB2_TEST_RUNNER_TASK_H_

#include <core_api/Task.h>

#include <QtCore/QList>
#include <QtCore/QMap>

namespace GB2 {

class GTestEnvironment;
class GTestState;
class GTest;

class TestRunnerTask : public Task {
    Q_OBJECT
public:
    TestRunnerTask(const QList<GTestState*>& tests, const GTestEnvironment* env, int testSizeToRun=5);

    QList<GTestState*> tests;

protected:
    virtual QList<Task*> onSubTaskFinished(Task* subTask);
    const GTestEnvironment* env;
    QMap<GTest*, GTestState*> stateByTest;

    int sizeToRun;
    QList<GTestState*> awaitingTests;

};

class LoadTestTask : public Task {
    Q_OBJECT
public:
    LoadTestTask(GTestState* test);
    
    void run();
    
    GTestState* testState;

    QByteArray testData;
};

} //namespace

#endif 
