/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TEST_RUNNER_PLUGIN_H_
#define _GB2_TEST_RUNNER_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/AppContext.h>
#include <core_api/ServiceModel.h>

#include <QtGui/QAction>

namespace GB2 {

class GTestSuite;
class GTestFormat;
class TestViewController;
class GTestEnvironment;

#define NUM_THREADS_VAR "NUM_THREADS"

class TestRunnerPlugin : public Plugin {
	Q_OBJECT
public:
    TestRunnerPlugin();
};

class TestRunnerService : public Service {
    Q_OBJECT
public:
    TestRunnerService(Plugin* p);
    ~TestRunnerService();

    const QList<GTestSuite*> getTestSuites() const {return suites;}
    void addTestSuite(GTestSuite*);
    void removeTestSuite(GTestSuite*);
    GTestSuite* findTestSuiteByURL(const QString& url);

    GTestEnvironment* getEnv() { return env;}

signals:
    void si_testSuiteAdded(GTestSuite* ts);
    void si_testSuiteRemoved(GTestSuite* ts);

protected:
    virtual void serviceStateChangedCallback(ServiceState oldState, bool enabledStateChanged);
    virtual bool eventFilter(QObject *obj, QEvent *event);

private slots:
    void sl_showWindow();

private:
    void readSavedSuites();
    void saveSuites();
    void readBuiltInVars();
    void deallocateSuites();
    
    void readEnvForKeys(QStringList keys);
    void saveEnv();
    void updateDefaultEnvValues(GTestSuite* ts);

    
    TestViewController*         view;
    QAction*                    windowAction;
    QList<GTestSuite*>          suites;
    GTestEnvironment*           env;
};

} //namespace

#endif
