/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REPEAT_DIAGONAL_H_
#define _GB2_REPEAT_DIAGONAL_H_

#include "RepeatFinder.h"

#include <QThread>
#include <QLinkedList>

namespace GB2 {

//// base class for a family of WK algorithms ////
class RepeatFinderDiagonalBase : public RepeatFinder {
public:
	RepeatResult* getResult(quint32);
	quint32 getNumResults();
	
	void startCalculation();
	void terminateCalculation();
    bool isRunning() const {return active;}
	
protected:
	bool active;
	RepeatFinderDiagonalBase(const char* seqX, quint32 sizeX, const char* seqY, quint32 sizeY, DNAAlphabet* al,  quint32 w, quint32 k, quint32 threads = 1);
	virtual ~RepeatFinderDiagonalBase();
	
	virtual QThread* newCalcThread(quint32 threadNum) = 0;
	void threadFinished();
	
	QLinkedList<QThread*> calcThreads;
	int nThreads;
	int activeThreads;
	
	int* resultX;
	int* resultY;
	int* resultL;
	quint32 nResults;
	quint32 resultsCapacity;
	RepeatResult edge;
	
	long elapsed_time;
	
	QMutex stateMutex;
	
	quint32 SIZE_X_1; //SIZE_X-1
	quint32 SIZE_Y_1;
	quint32 WINDOW_SIZE_1;
	qint32 START_DIAG, END_DIAG;
	
	//int DEBUG_N_MATCHES;
	
	quint64 plot_s;
	quint64 report_s;
	quint64 s_done;
	
	void logSizeDone(quint64  d_s );
	// adds single result to global results 
	void addToResults(int x, int y, int len);
	// adds multiple results to global results 
	void addToResults(int* x, int* y, int* len, int nResults);
	// ensures that we can add N records to results without GPF
	void ensureResultsCapacity(int n);
private:
	void waitThreadsStop();
	
};

//////////////////////////////////////
///////  RepeatFinder for W > K  //////
//////////////////////////////////////
class RepeatFinderDiagonalWK : public RepeatFinderDiagonalBase {
public:
	RepeatFinderDiagonalWK(const char* seqX, quint32 sizeX, const char* seqY, quint32 sizeY, DNAAlphabet* al,  quint32 w, quint32 k, quint32 threads=1);
	//void startCalculation2();

protected:
	QThread* newCalcThread(quint32 threadNum);
	
	int SAFE_SIZE_X; //size_x-window_size
	int SAFE_SIZE_Y;

	//// calc thread for RepeatFinderDiagonalWK
	class RepeatFinderWKThread : QThread {
		friend class RepeatFinderDiagonalWK;
	private:        
		int* matchesX;
		int* matchesY;
		int* matchesC;
		
		int nMatches;
		
		int* d_resultX;
		int* d_resultY;
		int* d_resultL;
		int d_nResults;
		
		RepeatFinderDiagonalWK* owner;
		quint32 num;
		const char* dataX;
		const char* dataY;
		char unknownChar;
		
		RepeatFinderWKThread(RepeatFinderDiagonalWK* owner, quint32 threadNum);
		
		void run();
		// process single diagonal
		inline void processDiagonal(int x, int y);
		inline void processDiagonal2(int x, int y);
		inline void processDiagonal3(int x, int y);
		// process marked places after all diagonal matches done
		inline void processMatches();
		// local results for currently processed diagonal (not ready results -> possible zakrashivanie)
		inline void addToLocalResults(int x, int y, int len);
		// adds diagonal results to global results (after diagonal processing is complete);
		inline void addLocalResultsToGlobal();
		
	public:
		~RepeatFinderWKThread();
	};
	friend class RepeatFinderWKThread;
	
};

}//namespace
#endif
