/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ExportDialogController.h"

#include <core_api/AppContext.h>
#include <core_api/Settings.h>
#include <util_gui/DialogUtils.h>
#include <util_gui/GUIUtils.h>

#include <QtGui/QMessageBox>
#include <QtGui/QFileDialog>

#define SETTINGS_ROOT QString("dna_export/")

namespace GB2 {

ExportDialogController::ExportDialogController(bool m, bool allowComplement, bool allowTranslation, const DocumentFormatId& id) {
    setupUi(this);    

    multiMode = m;
    strand = TriState_Yes;
    translate = false;
    translateAllFrames = false;
    
    if (!allowComplement) {
        directStrandButton->setEnabled(false);
        complementStrandButton->setEnabled(false);
        bothStrandsButton->setEnabled(false);
        
        directStrandButton->setHidden(true);
        complementStrandButton->setHidden(true);
        bothStrandsButton->setHidden(true);

    }
    if (!allowTranslation) {
        translateButton->setEnabled(false);
        translateButton->setHidden(true);
        allTFramesButton->setHidden(true);
    }

    if (!allowTranslation && !allowComplement) {
         translationBox->setHidden(true);
    }

    if (!multiMode) {
        saveModeBox->setEnabled(false);
        saveModeBox->setHidden(true);
    }
    formatId = id;
    connect(exportButton, SIGNAL(clicked()), SLOT(sl_exportClicked()));
    connect(fileButton, SIGNAL(clicked()), SLOT(sl_fileClicked()));

    int height = layout()->minimumSize().height();
    setMaximumHeight(height);
}


void ExportDialogController::updateModel() {
    strand = directStrandButton->isChecked() ? TriState_Yes : complementStrandButton->isChecked() ? TriState_No : TriState_Unknown;
    translate = translateButton->isChecked();
    translateAllFrames = allTFramesButton->isChecked();

    merge = mergeButton->isChecked();
    mergeGap = merge ? mergeSpinBox->value() : 0;
    file = fileNameEdit->text();
}


void ExportDialogController::sl_exportClicked() {
    if (fileNameEdit->text().isEmpty()) {
        QMessageBox::warning(this, tr("warning"), tr("file_is_empty"));
        fileNameEdit->setFocus();
        return;
    }
    updateModel();
    accept();
}

void ExportDialogController::sl_fileClicked() {
    QString filter = DialogUtils::prepareDocumentsFileFilter(formatId, false);
    LastOpenDirHelper lod;
    lod.url = QFileDialog::getSaveFileName(this, tr("select_file_title"), lod, filter);
    if (lod.url.isEmpty()) {
        return;
    }
    fileNameEdit->setText(lod.url);
}

}//namespace
