/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EXPORT_IMAGE_DIALOG_H_
#define _GB2_EXPORT_IMAGE_DIALOG_H_

#include <QtCore/QList>
#include <QtCore/QString>

#include "ui_ExportImageDialog.h"

namespace GB2 {

class BioStruct3DGLWidget;

class ExportImageDialog : public QDialog, private Ui::ImageExportForm
{
    Q_OBJECT

public:
    ExportImageDialog(BioStruct3DGLWidget* widget);

public slots:
    virtual void accept();

private slots:
    void sl_onBrowseButtonClick();
    void sl_onFormatsBoxItemChanged(const QString& text);

private:
    QList<QString> supportedFormats;
    BioStruct3DGLWidget* glWidget;

    void setupComponents();
    void setupFormats();



};



} // namespace

#endif