/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_ITERATION_H_
#define _GB2_WORKFLOW_ITERATION_H_

#include <workflow/Attribute.h>

#include <QtCore/QPair>

typedef QPair<GB2::ActorId,QString> IterationCfgKey;
typedef QMap<IterationCfgKey, QVariant> IterationCfg;

Q_DECLARE_METATYPE(IterationCfg)

namespace GB2 {
namespace Workflow {

class Actor;
class Link;

class WCOREAPI_EXPORT Iteration {
public:
    Iteration() : id(nextId()) {}
    Iteration(const QString& name) : name(name), id(nextId()) {}
    QString name;
    int id;
    QMap< QPair<ActorId, QString>, QVariant> cfg;
    QVariantMap getParameters(ActorId) const;
    void remap(QMap<ActorId, ActorId>);
private:
    static int nextId();
};

class WCOREAPI_EXPORT Schema /*: public Peer + TODO Actor */ {
public:
    Schema() : /*Actor(NULL),*/ deepCopy(false) {}
    virtual ~Schema();
    QList<Actor*> procs;
    QList<Link*> flows;
    QString domain;
    bool deepCopy;
    void applyConfiguration(const Iteration&, QMap<ActorId, ActorId>);
};


class WCOREAPI_EXPORT Metadata {
public:
    QString name;
    QString url;
    QString comment;

    void reset() {
        name = QString();
        comment = QString();
        url = QString();
    }
};


}//Workflow namespace
}//GB2 namespace

#endif
