/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "IntegralBusType.h"
#include "IntegralBusModel.h"

#include <core_api/Log.h>

namespace GB2 {
namespace Workflow {

static LogCategory log(ULOG_CAT_WD);

Descriptor IntegralBusType::assignSlotDesc(const Descriptor& d, const Port* p) {
    QString id = QString("%1:%2").arg(p->owner()->getId()).arg(d.getId());
    QString name = GB2::Workflow::BusPort::tr("%1 (by %2)").arg(d.getDisplayName()).arg(p->owner()->getLabel());
    QString doc = d.getDocumentation();
    return Descriptor(id, name, doc);
}

ActorId IntegralBusType::parseSlotDesc(const QString& id) {
    QStringList lst = id.split(":");
    QString sid = lst.first();
    ActorId aid = str2aid(sid);
    return aid;
}

void IntegralBusType::remap(QStrStrMap& busMap, const QMap<ActorId, ActorId>& m) {
    foreach(QString key, busMap.uniqueKeys()) {
        QStringList newValList;
        foreach(QString val, busMap.value(key).split(";")) {
            QStringList lst = val.split(":");
            QString sid = lst.first();
            ActorId id = str2aid(sid);
            log.trace("trying remap key="+key+" sid="+sid);
            if (m.contains(id)) {
                QString newSid = QString("%1").arg(m.value(id));
                lst.replace(0, newSid);
                QString newVal = lst.join(":");
                log.trace("remapping old="+val+" to new="+newVal);        
                val = newVal;
            }
            newValList.append(val);
        }
        busMap.insert(key, newValList.join(";"));
    }
}

void IntegralBusType::addInputs(const Port* p) {
    if (p->isInput()) {
        foreach(Port* peer, p->getLinks().uniqueKeys()) {
            DataTypePtr pt = peer->getType();
            if (qobject_cast<BusPort*>(peer)) {
                assert(pt->isMap());
                map.unite(pt->getElementsMap());
            } else {
                addOutput(pt, peer);
            }
        }
    }
}

void IntegralBusType::addOutput(DataTypePtr t, const Port* producer) {

    if (t->isMap()) {
        foreach(Descriptor d, t->getElements()) {
            map[assignSlotDesc(d, producer)] = t->getElement(d);
        }
    } else {
        map[assignSlotDesc(*producer, producer)] = t;
    }

}

}//Workflow namespace
}//GB2namespace
