/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SIMPLE_TEXT_OBJECT_VIEW_TASKS_H_
#define _GB2_SIMPLE_TEXT_OBJECT_VIEW_TASKS_H_

#include <util_tasks/ObjectViewTasks.h>

namespace GB2 {

class OpenSimpleTextObjectViewTask : public ObjectViewTask {
    Q_OBJECT
public:
	OpenSimpleTextObjectViewTask(Document* doc);
	virtual void open();

private:
	QPointer<Document> doc;
};

class OpenSavedTextObjectViewTask : public ObjectViewTask {
    Q_OBJECT
public:
    OpenSavedTextObjectViewTask(const QString& viewName, const QVariantMap& stateData);
    virtual void open();

private:
    QPointer<Document> doc;
};

class UpdateSimpleTextObjectViewTask : public ObjectViewTask {
public:
	UpdateSimpleTextObjectViewTask(GObjectView* v, const QString& stateName, const QVariantMap& stateData);

	virtual void update();
};


} // namespace

#endif

