/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_EDITOR_SEQUENCE_AREA_H_
#define _GB2_MSA_EDITOR_SEQUENCE_AREA_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <QtGui/QWidget>
#include <QtGui/QMenu>
#include <QtGui/QToolBar>

namespace GB2 {

class MSAEditor;
class MSAEditorUI;
class GObjectView;
class MSAEditorColorScheme;

class GB2_COREAPI_EXPORT MSAEditorSequenceArea : public QWidget {
    Q_OBJECT
public:
    MSAEditorSequenceArea(MSAEditorUI* ui);

    int countSpaceForBases(bool countClipped) const;

    int getFirstVisibleBase() const {return startPos;}

    int getLastVisibleBase(bool countClipped) const;

    int getNumVisibleBases(bool countClipped) const; 

    LRegion getBaseXRange(int pos, bool useVirsualCoords) const;

    const QFont& getSeqFont() {return seqFont;}

    void setFirstVisibleBase(int pos);

    QPoint coordToPos(const QPoint& coord) const;

    bool isPosVisible(const QPoint& p, bool countClipped) const;
    
    bool isPosVisible(int pos, bool countClipped) const;

    const QPoint& getCursorPos() const {return cursorPos;}

    void setCursorPos(const QPoint& p);

    void setCursorPos(int pos) { setCursorPos(QPoint(pos, cursorPos.y())); }

    void centerPos(const QPoint& pos);
    
    void centerPos(int pos);

signals:
    void si_startPosChanged(int startPos);
    void si_cursorPosChanged(const QPoint& p, const QPoint& prev);

protected:
    void resizeEvent(QResizeEvent *);
    void paintEvent(QPaintEvent *);
    void mousePressEvent(QMouseEvent *);
    void keyPressEvent(QKeyEvent *);

private slots:
    void sl_onHScrollMoved(int pos);
    void sl_onVScrollMoved(int pos);
    void sl_nameListItemSelectionChanged();
    void sl_vScrollRangeChanged(int, int);
    void sl_alignmentModified();
    void sl_sequenceListModified();

    void sl_buildStaticMenu(GObjectView* v, QMenu* m);
    void sl_buildStaticToolbar(GObjectView* v, QToolBar* t);
    void sl_buildContextMenu(GObjectView* v, QMenu* m);
    void sl_lockedStateChanged();

    void sl_delSym();
    void sl_delCol();
    void sl_insSym();
    void sl_insCol();
    void sl_goto();
    void sl_removeColumnsWithGaps();
    void sl_removeAllGaps();

    void sl_onPosChangeRequest(int pos);

protected:
    virtual void wheelEvent (QWheelEvent * event);

private:
    void buildMenu(QMenu* m);

    void moveCursorRelative(int dx, int dy);
    bool isPosInRange(const QPoint& p) const;
    bool isPosInRange(int p) const;
    void updateActions();
    
    void updateHScrollBar();
    LRegion getSequenceYRange(int n, bool useVirsualCoords) const;
    
    void drawSequences(QPainter& p);
    void drawCursor(QPainter& p);

    void ins(const QPoint& p, bool columnMode);
    void del(const QPoint& p, bool columnMode);

    MSAEditor*      editor;
    MSAEditorUI*    ui;

    int             seqCharWidth;
    int             startPos;

    QFont           seqFont;
    QPoint          cursorPos;

    QAction*        delSymAction;
    QAction*        delColAction;
    QAction*        insSymAction;
    QAction*        insColAction;
    QAction*        removeGapColumnsAction;
    QAction*        removeAllGapsAction;
    QAction*        gotoAction;

    MSAEditorColorScheme* colorScheme;
};


//todo: make it pluggable and tunable
class MSAEditorColorScheme : public QObject {
public:
    MSAEditorColorScheme(QObject* p, bool amino);

    QColor getColor(char c) const {return colorsPerChar[(quint8)c];}

private:
    QVector<QColor> colorsPerChar;
};



}//namespace
#endif
