/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GSEQUENCE_LINE_VIEW_ANNOTATED_H_
#define _GB2_GSEQUENCE_LINE_VIEW_ANNOTATED_H_

#include "GSequenceLineView.h"

#include <selection/AnnotationSelection.h>

namespace GB2 {

class AnnotationTableObject;
class AnnotationSettings;

class GB2_COREAPI_EXPORT GSequenceLineViewAnnotated : public GSequenceLineView {
	Q_OBJECT
public:
	class DrawSettings {
	public:
		DrawSettings() : drawAnnotationNames(false), drawAnnotationArrows(false){}
		bool drawAnnotationNames;
		bool drawAnnotationArrows;
	};

	GSequenceLineViewAnnotated(QWidget* p, ADVSequenceObjectContext* ctx);

	bool isAnnotationVisible(Annotation* a) const;
	const DrawSettings& getDrawSettings() const {return drawSettings;}

	QList<AnnotationSelectionData> selectAnnotationByCoord(const QPoint& coord) const;

protected:
	void mousePressEvent(QMouseEvent * e);
	virtual bool event(QEvent* e);
	virtual QString createToolTip(QHelpEvent* e);

	virtual void registerAnnotations(const QList<Annotation*>& l){ Q_UNUSED(l); }
	virtual void unregisterAnnotations(const QList<Annotation*>& l){ Q_UNUSED(l); }
	virtual void ensureVisible(Annotation* a, int locationIdx);

protected slots:
    virtual void sl_onAnnotationSettingsChanged(const QStringList& changedSettings);

	void sl_onAnnotationObjectAdded(AnnotationTableObject*);
	void sl_onAnnotationObjectRemoved(AnnotationTableObject*);
	void sl_onAnnotationsAdded(const QList<Annotation*>&);
	void sl_onAnnotationsRemoved(const QList<Annotation*>&);
	void sl_onAnnotationSelectionChanged(AnnotationSelection*, const QList<Annotation*>& added, const QList<Annotation*>& removed);
    
private:
	void connectAnnotationObject(AnnotationTableObject* ao);

protected:
	DrawSettings    drawSettings;
};


class GB2_COREAPI_EXPORT GSequenceLineViewAnnotatedRenderArea : public GSequenceLineViewRenderArea {
public:
	GSequenceLineViewAnnotatedRenderArea(GSequenceLineViewAnnotated* d, bool annotationsCanOverlap);
	~GSequenceLineViewAnnotatedRenderArea();

	virtual LRegion getAnnotationYRange(Annotation* a, const LRegion& r, const AnnotationSettings* as) const = 0;
	GSequenceLineViewAnnotated* getGSequenceLineViewAnnotated() const {return (GSequenceLineViewAnnotated*)view;}

protected:
	virtual void drawAnnotations(QPainter& p);
    virtual void drawAnnotationArrow(QPainter& p, const QRect& r, bool leftArrow);
	virtual void drawBoundedText(QPainter& p, const QRect& r, const QString& text) const;
	virtual void drawAnnotationConnections(QPainter& p, Annotation* a, const AnnotationSettings* as);
    virtual void drawAnnotationsSelection(QPainter& p);

    bool isAnnotationSelectionInVisibleRange() const;

private:
    enum DrawAnnotationPass {
        DrawAnnotationPass_DrawFill,
        DrawAnnotationPass_DrawBorder
    };

    void drawAnnotations(QPainter& p, DrawAnnotationPass pass);
    void drawAnnotation(QPainter& p, DrawAnnotationPass pass, Annotation* a, const QPen& borderPen, bool selected = false);

protected:
    bool annotationsCanOverlap;

	//af* == annotation font
	QFont* afNormal;
	QFont* afSmall;
	
	QFontMetrics* afmNormal;
	QFontMetrics* afmSmall;

	int afNormalCharHeight;
	int afNormalCharWidth;

	int afSmallCharHeight;
	int afSmallCharWidth;
	
};

} // namespace


#endif
