/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ANNOTATED_DNA_VIEW_STATE_H_
#define _GB2_ANNOTATED_DNA_VIEW_STATE_H_

#include <core_api/LRegion.h>
#include <core_api/GObject.h>
#include <QtCore/QVariant>

namespace GB2 {

class AnnotatedDNAView;	

class GB2_COREAPI_EXPORT AnnotatedDNAViewState {
public:
	AnnotatedDNAViewState();
	AnnotatedDNAViewState(const QVariantMap& _stateData) : stateData(_stateData){}

	static QVariantMap saveState(AnnotatedDNAView* v);

	bool isValid() const;
	
	void setSequenceObjects(const QList<GObjectReference>& objs, const QList<LRegion>& selections);

    QList<GObjectReference> getSequenceObjects() const;

    QList<LRegion> getSequenceSelections() const;

    QList<GObjectReference> getAnnotationObjects() const;

    void setAnnotationObjects(const QList<GObjectReference>& objs);

    QVariantMap stateData;
};




} // namespace

#endif
