/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADV_SINGLE_SEQ_WIDGET_H_
#define _GB2_ADV_SINGLE_SEQ_WIDGET_H_

#include "ADVSequenceWidget.h"
#include <core_api/LRegion.h>

#include <QtGui/QWidget>
#include <QtGui/QVBoxLayout>
#include <QtGui/QMenu>
#include <QtGui/QToolBar>
#include <QtGui/QLabel>
#include <QtGui/QToolButton>


namespace GB2 {

class AnnotatedDNAView;
class DNASequenceObject;
class GSequenceLineView;
class DetView;
class PanView;
class GSingleSeqBlockState;
class DNATranslation;
class ADVSequenceObjectContext;
class ADVSingleSequenceHeaderWidget;


class GB2_COREAPI_EXPORT ADVSingleSequenceWidget : public ADVSequenceWidget {
    Q_OBJECT
public:
    ADVSingleSequenceWidget(ADVSequenceObjectContext* seqCtx, AnnotatedDNAView* ctx);
    ~ADVSingleSequenceWidget();

    const QList<GSequenceLineView*>& getLineViews() const {return lineViews;}

    GSequenceLineView* getPanGSLView() const;

    GSequenceLineView* getDetGSLView() const;

    PanView* getPanView() const {return panView;}

    DetView* getDetView() const {return detView;}

    virtual void centerPosition(int pos, QWidget* skipView = NULL);
    
    ADVSequenceObjectContext*   getActiveSequenceContext() const {return (seqContexts.isEmpty()) ? NULL : seqContexts.first();}
    ADVSequenceObjectContext*   getSequenceContext() const {return getActiveSequenceContext();}
    
    DNATranslation* getComplementTT() const;

    DNATranslation* getAminoTT() const;

    DNASequenceSelection*   getSequenceSelection() const;
    
    int getSequenceLen() const;

    virtual void addSequenceView(GSequenceLineView* v);

    virtual void removeSequenceView(GSequenceLineView* v, bool deleteView = true);

    DNASequenceObject* getSequenceObject() const;

    virtual void buildPopupMenu(QMenu& m);

    virtual bool isWidgetOnlyObject(GObject* o) const;

    virtual void addADVSequenceWidgetAction(ADVSequenceWidgetAction* action);

    void setViewCollapsed(bool v);
    bool isViewCollapsed() const {return !toggleViewAction->isChecked();}
    QAction* getToggleViewAction() const {return toggleViewAction;}

    void setPanViewCollapsed(bool v);
    bool isPanViewCollapsed() const {return !togglePanViewAction->isChecked();}
    QAction* getTogglePanViewAction() const {return togglePanViewAction;}

    void setDetViewCollapsed(bool v);
    bool isDetViewCollapsed() const {return !toggleDetViewAction->isChecked();}
    QAction* getToggleDetViewAction() const {return toggleDetViewAction;}

    virtual void updateState(const QVariantMap& m);

    virtual void saveState(QVariantMap& m);

    void closeView();

protected slots:
    void sl_onViewDestroyed(QObject*);

    void sl_toggleView(bool v) {setViewCollapsed(!v);}
    void sl_togglePanView(bool v) {setPanViewCollapsed(!v);}
    void sl_toggleDetView(bool v) {setDetViewCollapsed(!v);}
    void sl_onSelectRange();
    void sl_zoomToRange();
    void sl_onLocalCenteringRequest(int pos);

protected:
    void init();
    bool eventFilter(QObject* o, QEvent* e);

private:
    virtual void updateMinMaxHeight();

    virtual GSequenceLineView* findSequenceViewByPos(const QPoint& globalPos) const;

    virtual void addZoomMenu(const QPoint& globalPos, QMenu* m);
    
    DetView*                        detView;
    PanView*                        panView;
    QList<GSequenceLineView*>       lineViews;
    QVBoxLayout*                    linesLayout;
    ADVSingleSequenceHeaderWidget   *headerWidget;
    
    QAction*        toggleViewAction;
    QAction*        togglePanViewAction;
    QAction*        toggleDetViewAction;
    QAction*        selectRangeAction;
    QAction*        zoomToRangeAction;

    QList<QMenu*>   tbMenues;
};

class GB2_COREAPI_EXPORT ADVSingleSequenceHeaderWidget : public QWidget {
    Q_OBJECT
public:
    ADVSingleSequenceHeaderWidget(ADVSingleSequenceWidget* p);
    
    QToolBar* getToolBar() const { return toolBar;}

protected:
    virtual void mouseDoubleClickEvent(QMouseEvent *e);
    virtual void paintEvent(QPaintEvent *e);
    
    virtual bool eventFilter (QObject *o, QEvent *e);

protected slots:
    void sl_advFocusChanged(ADVSequenceWidget* prevFocus, ADVSequenceWidget* newFocus);
    void sl_actionTriggered(QAction* a);
    void sl_showStateMenu();
    void sl_closeView();

private:
    void populateToolBars();
    void updateActiveState();

    ADVSingleSequenceWidget*        ctx;
    QToolBar*                       toolBar;
    QToolBar*                       closeBar;
    QLabel*                         pixLabel;
    QLabel*                         nameLabel;

    QAction*        closeViewAction;
    QToolButton*    widgetStateMenuButton;
};

}//namespace

#endif

