/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADVANNOTATION_CREATION_H_
#define _GB2_ADVANNOTATION_CREATION_H_

#include <core_api/Task.h>
#include <gobjects/AnnotationTableObject.h>

#include <QtGui/QAction>
#include <QtCore/QPointer>

namespace GB2 {

class CreateAnnotationsTask;
class AnnotatedDNAView;
class DNASequenceObject;

class GB2_COREAPI_EXPORT ADVAnnotationCreation : public QObject {
	Q_OBJECT
public:
	ADVAnnotationCreation(AnnotatedDNAView* v);
	
	QAction* getCreateAnnotationAction() const {return createAction;}

private slots:
	void sl_createAnnotation();

private:
	AnnotatedDNAView* ctx;
	QAction* createAction;
};


class GB2_COREAPI_EXPORT  ADVCreateAnnotationsTask : public Task {
    Q_OBJECT
public:
    ADVCreateAnnotationsTask(AnnotatedDNAView* _ctx, AnnotationTableObject* o, const QString& group, const QList<SharedAnnotationData>& data);
        
    ReportResult report();

private:
    QPointer<AnnotatedDNAView> ctx;
    CreateAnnotationsTask* t;
};


} // namespace



#endif
