/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PROJECT_TREE_ITEM_SELECTOR_DIALOG_H_
#define _GB2_PROJECT_TREE_ITEM_SELECTOR_DIALOG_H_

#include <ui/ui_ProjectTreeItemSelectorDialogBase.h>

#include <core_api/core_api.h>
#include <core_api/AppContext.h>

#include <QtGui/QDialog>

namespace GB2 {

class ProjectTreeController;
class ProjectTreeControllerModeSettings;
class Document;
class GObject;

class GB2_COREAPI_EXPORT ProjectTreeItemSelectorDialog: public QDialog, public Ui::ProjectTreeItemSelectorDialogBase {
    Q_OBJECT
public:
    static QList<Document*> selectDocuments(const ProjectTreeControllerModeSettings& s);
    static QList<GObject*> selectObjects(const ProjectTreeControllerModeSettings& s);

private:
    ProjectTreeItemSelectorDialog(const ProjectTreeControllerModeSettings& s);
    ~ProjectTreeItemSelectorDialog();
    ProjectTreeController* controller;
    
};



}//namespace
#endif
