/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DocumentFormatComboboxController.h"

#include <core_api/AppContext.h>

namespace GB2 {

DocumentFormatComboboxController::DocumentFormatComboboxController(QObject* p, QComboBox* cb, 
																   const DocumentFormatConstraints& _c, 
																   DocumentFormatId active)
: QObject(p), combo(cb), c(_c)
{
	assert(combo->count()==0);
	
	DocumentFormatRegistry* fr = AppContext::getDocumentFormatRegistry();
	connect(fr, SIGNAL(si_documentFormatRegistered(DocumentFormat*)), SLOT(sl_onDocumentFormatRegistered(DocumentFormat*)));
	connect(fr, SIGNAL(si_documentFormatUnregistered(DocumentFormat*)), SLOT(sl_onDocumentFormatUnregistered(DocumentFormat*)));

	updateCombo(active);
}

void DocumentFormatComboboxController::sl_onDocumentFormatRegistered(DocumentFormat* f) {
	if (!f->checkConstraints(c)) {
		return;
	}
	combo->addItem(QIcon(), f->getFormatName(), f->getFormatId());
}

void DocumentFormatComboboxController::sl_onDocumentFormatUnregistered(DocumentFormat* f) {
	for (int i=0;i<combo->count();i++) {
		DocumentFormatId id = combo->itemData(i).toString();
		if (id == f->getFormatId()) {
			combo->removeItem(i);
			return;
		}
	}
}

DocumentFormatId DocumentFormatComboboxController::getActiveFormatId() const {
	int i = combo->currentIndex();
	if (i==-1) {
		return DocumentFormatId::null;
	}
	DocumentFormatId id = combo->itemData(i).toString();
	return id;
}

void DocumentFormatComboboxController::setActiveFormatId(DocumentFormatId id) {
	for (int i=0, n=combo->count(); i<n; i++) {
		DocumentFormatId tmpId = combo->itemData(i).toString();
		if (id == tmpId) {
			combo->setCurrentIndex(i);
			return;
		}
	}
	assert(0);
}

QList<DocumentFormatId> DocumentFormatComboboxController::getFormatsInCombo() {
	QList<DocumentFormatId> res;
	for (int i = 0, n = combo->count(); i < n; i++) {
		DocumentFormatId id = combo->itemData(i).toString();
		res.append(id);
	}
	return res;
}

void DocumentFormatComboboxController::updateConstraints(const DocumentFormatConstraints& _c) {
	c = _c;
	updateCombo(getActiveFormatId());
}

void DocumentFormatComboboxController::updateCombo(DocumentFormatId active) {
	combo->clear();
	DocumentFormatRegistry* fr = AppContext::getDocumentFormatRegistry();
	QList<DocumentFormatId> formatIds = fr->selectFormats(c);
	combo->setInsertPolicy(QComboBox::InsertAlphabetically);
	foreach(DocumentFormatId id, formatIds) {
		DocumentFormat* f = fr->getFormatById(id);
		assert(f);
        if (!f->checkConstraints(c)) {
            continue;
        }
        combo->addItem(QIcon(), f->getFormatName(), f->getFormatId());
		if (f->getFormatId () == active) {
    	    combo->setCurrentIndex(combo->count()-1);
	    }
	}
}

}//namespace

