/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "XMLTestUtils.h"

namespace GB2 {

QList<XMLTestFactory*>  XMLTestUtils::createTestFactories() {
    QList<XMLTestFactory*> res;
    
    res.append(XMLMultiTest::createFactory());

    return res;
}

void XMLMultiTest::init(XMLTestFormat *tf, const QDomElement& el) {
    QDomNodeList subtaskNodes = el.childNodes();
    QList<Task*> subs;
    for(int i=0;i<subtaskNodes.size(); i++) {
        QDomNode n = subtaskNodes.item(i);
        if (!n.isElement()) {
            continue;
        }
        QDomElement subEl= n.toElement();
        QString name = subEl.tagName();
        GTest* subTest = tf->createTest(name, this, env, subEl, stateInfo.error);
        if (hasErrors()) {
            break;
        }
        assert(subTest);

        subs.append(subTest);
    }
    if (!hasErrors()) {
        foreach(Task* t, subs) {
            addSubTask(t);
        }
    }
}


Task::ReportResult XMLMultiTest::report() {
    if (!hasErrors()) {
        Task* t = getSubtaskWithErrors();
        if (t!=NULL) {
            stateInfo.error = t->getError();
        }
    }
    return ReportResult_Finished;
}


}//namespace

