/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DOCUMENT_MODEL_TESTS_H_
#define _GB2_DOCUMENT_MODEL_TESTS_H_

#include "XMLTestUtils.h"

#include <core_api/IOAdapter.h>

#include <QtXml/QDomElement>

namespace GB2 {

class Document;
class GObject;
class LoadDocumentTask;
class SaveDocumentTask;

class GTest_LoadDocument : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_LoadDocument, "load-document");

    ReportResult report();

    virtual void cleanup();

private:
    QString             docContextName;
    LoadDocumentTask*   loadTask;
    bool                contextAdded;
    bool                tempFile;
    QString             url;
};

class GTest_SaveDocument : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_SaveDocument, "save-document");
    void prepare();
    ReportResult report();

private:
     QString             url;
     IOAdapterFactory*   iof;


    QString             docContextName;
    SaveDocumentTask*   saveTask;
};

class GTest_LoadBrokenDocument : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_LoadBrokenDocument, "load-broken-document");

    Document* getDocument() const;
    ReportResult report();

private:
    LoadDocumentTask*   loadTask;
};

class GTest_DocumentNumObjects : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_DocumentNumObjects, "check-num-objects");

    ReportResult report();
    QString docContextName;
    int numObjs;
};

class GTest_DocumentObjectNames : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_DocumentObjectNames, "check-document-object-names");

    ReportResult report();
    
    QString docContextName;
    QStringList names;
};

class GTest_DocumentObjectTypes : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_DocumentObjectTypes, "check-document-object-types");

    ReportResult report();
    
    QString docContextName;
    QList<GObjectType> types;
};

class DocumentModelTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};


class GTest_FindGObjectByName : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_FindGObjectByName, "find-object-by-name");

    ReportResult report();

    void cleanup();

private:
    QString     docContextName;
    QString     objContextName;
    QString     objName;
    GObjectType type;
    GObject*    result;


};

}//namespace
#endif
