/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "GTestFrameworkComponents.h"

#include "xmltest/XMLTestFormat.h"
#include "find_algo/FindAlgorithmTestFormat.h"

namespace GB2 {

GTestFormatRegistry::GTestFormatRegistry() {
    formats.append(new XMLTestFormat());    
    formats.append(new FindAlgorithmTestFormat());
}

GTestFormatRegistry::~GTestFormatRegistry() {
    foreach(GTestFormat* f, formats) {
        delete f;
    }
}

bool GTestFormatRegistry::registerTestFormat(GTestFormat* f) {
    if (formats.contains(f)) {
        return false;
    }
    formats.append(f);
    return true;
}

bool GTestFormatRegistry::unregisterTestFormat(GTestFormat* f) {
    if (!formats.contains(f)) {
        return false;
    }
    formats.removeOne(f);
    return true;
}

GTestFormat* GTestFormatRegistry::findFormat(const GTestFormatId& id) {
    foreach(GTestFormat* f, formats) {
        if (f->getFormatId() == id) {
            return f;
        }
    }
    return NULL;
}

}//namespace
