/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_LREGION_SELECTION_H_
#define _GB2_LREGION_SELECTION_H_

#include <core_api/LRegion.h>
#include <core_api/SelectionModel.h>

namespace GB2 {

class GB2_COREAPI_EXPORT LRegionsSelection : public GSelection {
	Q_OBJECT
public:
	LRegionsSelection(GSelectionType type, QObject* p = NULL) : GSelection(type, p) {}

	const QList<LRegion>& getSelectedRegions() const {return regions;}

	void addRegion(const LRegion& r);

	void removeRegion(const LRegion& r);

	virtual bool isEmpty() const {return regions.isEmpty();}

	virtual void clear();

signals:
	void si_selectionChanged(LRegionsSelection* thiz, const QList<LRegion>& added, const QList<LRegion>& removed);

public:
	QList<LRegion> regions;
};

}//namespace

#endif
