/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ZLIB_ADAPTER_H_
#define _GB2_ZLIB_ADAPTER_H_

#include <core_api/IOAdapter.h>
#include <util_algorithm/RingBuffer.h>

namespace GB2 {

class GzipUtil;
class ZlibAdapter: public IOAdapter {
    Q_OBJECT
public:
	ZlibAdapter(IOAdapter* io);
	~ZlibAdapter();
	
	virtual bool open(const QString& url, IOAdapterMode m);

	virtual bool isOpen() const {return io->isOpen();}

	virtual void close();

	virtual qint64 readBlock(char* data, qint64 maxSize);

	virtual qint64 writeBlock(const char* data, qint64 size);

	virtual bool skip(qint64 nBytes);
    
	virtual qint64 left() const {return -1;}
	virtual int getProgress() const {return io->getProgress();}

private:
	static const int BUFLEN = 32768;
	IOAdapter* io;
	GzipUtil* z;
	RingBuffer* buf; // seek buffer
	int rewinded; // how much should read from seek buffer
};


}//namespace

#endif
