/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EMBL_PLAIN_TEXT_FORMAT_H_
#define _GB2_EMBL_PLAIN_TEXT_FORMAT_H_

#include "EMBLGenbankAbstractDocument.h"

namespace GB2 {

class GB2_COREAPI_EXPORT EMBLPlainTextFormat : public EMBLGenbankAbstractDocument {
    Q_OBJECT
public:
    EMBLPlainTextFormat(QObject* p);

    virtual void storeDocument(Document* d, TaskStateInfo& ts, IOAdapterFactory* io = NULL, const QString& newDocURL = QString::null);
    virtual bool isDataFormatSupported(const char* data, int size) const;
    virtual bool checkConstraints(const DocumentFormatConstraints& c) const;

protected:

    virtual EMBLGenbankAbstractIDLine*   readIdLine(const QString& line, TaskStateInfo& si);
    virtual EMBLGenbankAbstractHeader*	 readHeader(IOAdapter* io, TaskStateInfo& si);
    virtual QList<SharedAnnotationData>	 readAnnotations(IOAdapter* io, TaskStateInfo& si, int offset);
};


}//namespace

#endif
