/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CLUSTAL_W_ALN_FORMAT_H_
#define _GB2_CLUSTAL_W_ALN_FORMAT_H_

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>

namespace GB2 {

class IOAdapter;

class GB2_COREAPI_EXPORT ClustalWAlnFormat : public DocumentFormat {
    Q_OBJECT
public:
	ClustalWAlnFormat(QObject* p);

	virtual DocumentFormatId getFormatId() const {return BaseDocumentFormats::CLUSTAL_ALN;}

	virtual const QString& getFormatName() const {return formatName;}

	virtual QStringList getSupportedDocumentFileExtensions();

    virtual Document* loadExistingDocument(IOAdapterFactory* io, const QString& url, TaskStateInfo& ti, const QVariantMap& fs);

	virtual void storeDocument(Document* d, TaskStateInfo& ti, IOAdapterFactory* io = NULL, const QString& newDocURL = QString::null);

	virtual bool isDataFormatSupported(const char* data, int size) const;

	virtual bool isObjectOpSupported(const Document* d , DocumentFormat::DocObjectOp op, GObjectType t) const;

	virtual bool checkConstraints(const DocumentFormatConstraints& c) const;

private:
    void save(IOAdapter* io, Document* doc, TaskStateInfo& ti);
    void load(IOAdapter* io, QList<GObject*>& objects, TaskStateInfo& ti);

	QString formatName;
};

}//namespace

#endif
