/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ANNOTATION_DATA_H_
#define _GB2_ANNOTATION_DATA_H_

#include <core_api/GObject.h>
#include <core_api/LRegion.h>

#include <QtCore/QSharedData>

namespace GB2 {


class GB2_COREAPI_EXPORT Qualifier {
public:
    Qualifier(){}
    Qualifier(const QString& _name, const QString& _val) : name(_name), val(_val) {}

    bool operator== ( const Qualifier & q ) const { return q.name == name && q.val == val; }
    bool operator!= ( const Qualifier & q ) const { return q.name != name ||  q.val != val; }

    const QString& getQualifierName() const {return name;}

    const QString& getQualifierValue() const {return val;}

private:
    QString name;
    QString val;
};

class GB2_COREAPI_EXPORT AnnotationData : public QSharedData {
public:
    bool                complement;
    TriState            aminoStrand;
    QString             name;
    QList<LRegion>      location;
    QList<Qualifier>    qualifiers;

    AnnotationData() : complement(false), aminoStrand(TriState_Unknown){}

    AnnotationData& operator= ( const AnnotationData & a ) { 
        name = a.name; 
        complement = a.complement;
        aminoStrand = a.aminoStrand;
        location = a.location; 
        qualifiers = a.qualifiers;
        return *this;
    }

    void findQualifiers(const QString& name, QList<Qualifier>& res) const {
        foreach (const Qualifier& q, qualifiers) {
            if (q.getQualifierName() == name) {
                res.append(q);
            }
        }
    }

    QString findFirstQualifierValue(const QString& name) const {
        foreach (const Qualifier& q, qualifiers) {
            if (q.getQualifierName() == name) {
                return q.getQualifierValue();
            }
        }
        return QString::null;
    }
};

typedef QSharedDataPointer<AnnotationData> SharedAnnotationData;


}//namespace

Q_DECLARE_METATYPE(GB2::AnnotationData);
Q_DECLARE_METATYPE(GB2::SharedAnnotationData);
Q_DECLARE_METATYPE(QList<GB2::SharedAnnotationData>);

#endif
