/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_APPCONTEXT_H_
#define _GB2_APPCONTEXT_H_

#include "core_api.h"

namespace GB2 {

class PluginSupport;
class ProjectLoader;
class MainWindow;
class ProjectView;
class Project;
class ProjectService;
class PluginViewer;
class Settings;
class AppSettings;
class AppSettingsGUI;
class DocumentFormatRegistry;
class IOAdapterRegistry;
class DNATranslationRegistry;
class DNAAlphabetRegistry;
class GObjectViewFactoryRegistry;
class ResourceTracker;
class TaskScheduler;
class DocumentFormatConfigurators;
class AnnotationSettingsRegistry;
class TestFramework;
class DBXRefRegistry;

class GB2_COREAPI_EXPORT AppContext  {
public:
    virtual ~AppContext(){}

    static PluginSupport*  getPluginSupport()  {return getInstance()->_getPluginSupport();}

    static  ProjectLoader*  getProjectLoader() {return getInstance()->_getProjectLoader();}

    static  Project*        getProject() {return getInstance()->_getProject();}

    static  ProjectService* getProjectService() {return getInstance()->_getProjectService();}

    static  PluginViewer*   getPluginViewer() {return getInstance()->_getPluginViewer();}

    /** admin level, readonly settings*/
    static  const Settings* getGlobalSettings() {return getInstance()->_getGlobalSettings();}

    /** per-user settings*/
    static  Settings*       getSettings() {return getInstance()->_getSettings();}

    /** structured and preloaded settings */
    static AppSettings * getAppSettings() { return getInstance()->_getAppSettings();}

    /** GUI for structured and preloaded settings */
    static AppSettingsGUI* getAppSettingsGUI() {return getInstance()->_getAppSettingsGUI();}


    static  MainWindow*     getMainWindow() {return getInstance()->_getMainWindow();}

    static  ProjectView*    getProjectView() {return getInstance()->_getProjectView();}

    static  DocumentFormatRegistry* getDocumentFormatRegistry() {return getInstance()->_getDocumentFormatRegistry();}

    static  IOAdapterRegistry* getIOAdapterRegistry() {return getInstance()->_getIOAdapterRegistry();}

    static  DNATranslationRegistry* getDNATranslationRegistry() {return getInstance()->_getDNATranslationRegistry();}

    static  DNAAlphabetRegistry* getDNAAlphabetRegistry() {return getInstance()->_getDNAAlphabetRegistry();}

    static  GObjectViewFactoryRegistry* getObjectViewFactoryRegistry() {return getInstance()->_getObjectViewFactoryRegistry();}

    static  TaskScheduler* getTaskScheduler() {return getInstance()->_getTaskScheduler();}

    static  ResourceTracker* getResourceTracker() {return getInstance()->_getResourceTracker();}

    static DocumentFormatConfigurators* getDocumentFormatConfigurators() {return getInstance()->_getDocumentFormatConfigurators();}

    static AnnotationSettingsRegistry* getAnnotationsSettingsRegistry() {return getInstance()->_getAnnotationsSettingsRegistry();}

    static TestFramework* getTestFramework() {return getInstance()->_getTestFramework();}

	static DBXRefRegistry* getDBXRefRegistry() {return getInstance()->_getDBXRefRegistry();}

protected:
    static AppContext* getInstance() {assert(instance); return instance;}

    virtual PluginSupport*  _getPluginSupport() const = 0;
    virtual ProjectLoader*  _getProjectLoader() const = 0;
    virtual Project*        _getProject() const = 0;
    virtual ProjectService* _getProjectService() const = 0;
    virtual PluginViewer*   _getPluginViewer() const = 0;
    virtual Settings*       _getSettings() const = 0;
    virtual Settings*       _getGlobalSettings() const = 0;
    virtual MainWindow*     _getMainWindow() const = 0;
    virtual ProjectView*    _getProjectView() const = 0;
    virtual DocumentFormatRegistry*     _getDocumentFormatRegistry() const = 0;
    virtual IOAdapterRegistry*          _getIOAdapterRegistry() const = 0;
    virtual DNATranslationRegistry*     _getDNATranslationRegistry() const = 0;
    virtual DNAAlphabetRegistry*        _getDNAAlphabetRegistry() const = 0;
    virtual GObjectViewFactoryRegistry* _getObjectViewFactoryRegistry() const = 0;
    virtual TaskScheduler*              _getTaskScheduler() const = 0;
    virtual ResourceTracker*            _getResourceTracker() const = 0;
    virtual DocumentFormatConfigurators* _getDocumentFormatConfigurators() const = 0;
    virtual AnnotationSettingsRegistry* _getAnnotationsSettingsRegistry() const = 0;
    virtual AppSettings *               _getAppSettings() const = 0;
    virtual AppSettingsGUI*             _getAppSettingsGUI() const = 0;
    virtual TestFramework*              _getTestFramework() const = 0;
	virtual DBXRefRegistry*             _getDBXRefRegistry() const = 0;
    

    static AppContext* instance;

};


}//namespace
#endif
