##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

include (core.pri)

# Input
HEADERS += src/core_api/AppContext.h \
           src/core_api/AppSettings.h \
           src/core_api/AppSettingsGUI.h \
           src/core_api/core_api.h \
           src/core_api/DBXRefRegistry.h \
           src/core_api/DNAAlphabet.h \
           src/core_api/DNATranslation.h \
           src/core_api/DocumentFormatConfigurators.h \
           src/core_api/DocumentFormats.h \
           src/core_api/DocumentModel.h \
           src/core_api/GHints.h \
           src/core_api/GObject.h \
           src/core_api/GObjectReference.h \
           src/core_api/IOAdapter.h \
           src/core_api/Log.h \
           src/core_api/LRegion.h \
           src/core_api/MainWindow.h \
           src/core_api/NetworkConfiguration.h \
           src/core_api/ObjectViewModel.h \
           src/core_api/PluginModel.h \
           src/core_api/PluginViewer.h \
           src/core_api/ProjectModel.h \
           src/core_api/ProjectView.h \
           src/core_api/ResourceTracker.h \
           src/core_api/ScriptRegistry.h \
           src/core_api/SelectionModel.h \
           src/core_api/ServiceModel.h \
           src/core_api/ServiceTypes.h \
           src/core_api/Settings.h \
           src/core_api/StateLockableDataModel.h \
           src/core_api/Task.h \
           src/core_api/UserApplicationsSettings.h \
           src/core_api/Vector3D.h \
           src/datatype/AnnotationData.h \
           src/datatype/BioStruct3D.h \
           src/datatype/DNAChromatogram.h \
           src/datatype/DNASequence.h \
           src/datatype/MAlignment.h \
           src/datatype/PhyTree.h \
           src/document_format/ABIFormat.h \
           src/document_format/ClustalWAlnFormat.h \
           src/document_format/DNAAlphabetRegistryImpl.h \
           src/document_format/DNATranslationImpl.h \
           src/document_format/DocumentFormatUtils.h \
           src/document_format/EMBLGenbankAbstractDocument.h \
           src/document_format/EMBLPlainTextFormat.h \
           src/document_format/FastaFormat.h \
           src/document_format/GenbankLocationParser.h \
           src/document_format/GenbankPlainTextFormat.h \
           src/document_format/IOLibUtils.h \
           src/document_format/NewickFormat.h \
           src/document_format/PDBFormat.h \
           src/document_format/PlainTextFormat.h \
           src/document_format/RawDNASequenceFormat.h \
           src/document_format/SCFFormat.h \
           src/document_format/StockholmFormat.h \
           src/gobjects/AnnotationSettings.h \
           src/gobjects/AnnotationTableObject.h \
           src/gobjects/BioStruct3DObject.h \
           src/gobjects/DNAChromatogramObject.h \
           src/gobjects/DNASequenceObject.h \
           src/gobjects/GObjectRelationRoles.h \
           src/gobjects/GObjectTypes.h \
           src/gobjects/GObjectUtils.h \
           src/gobjects/MAlignmentObject.h \
           src/gobjects/PhyTreeObject.h \
           src/gobjects/TextObject.h \
           src/ioadapter/HttpFileAdapter.h \
           src/ioadapter/LocalFileAdapter.h \
           src/ioadapter/ZlibAdapter.h \
           src/selection/AnnotationSelection.h \
           src/selection/DNASequenceSelection.h \
           src/selection/DocumentSelection.h \
           src/selection/GObjectSelection.h \
           src/selection/LRegionsSelection.h \
           src/selection/SelectionTypes.h \
           src/selection/SelectionUtils.h \
           src/selection/TextSelection.h \
           src/test_framework/GTest.h \
           src/test_framework/GTestFrameworkComponents.h \
           src/util_algorithm/DynTable.h \
           src/util_algorithm/FindAlgorithm.h \
           src/util_algorithm/FindAlgorithmTask.h \
           src/util_algorithm/GAutoDeleteList.h \
           src/util_algorithm/MSAUtils.h \
           src/util_algorithm/ORFAlgorithmTask.h \
           src/util_algorithm/ORFFinder.h \
           src/util_algorithm/RingBuffer.h \
           src/util_algorithm/RollingArray.h \
           src/util_algorithm/RollingMatrix.h \
           src/util_find_dialog/FindDialog.h \
           src/util_gui/AddExistingDocumentDialogImpl.h \
           src/util_gui/AddNewDocumentDialogImpl.h \
           src/util_gui/AnnotationSettingsDialogController.h \
           src/util_gui/BaseDocumentFormatConfigurators.h \
           src/util_gui/CreateAnnotationDialog.h \
           src/util_gui/CreateAnnotationWidgetController.h \
           src/util_gui/CreateObjectRelationDialogController.h \
           src/util_gui/DialogUtils.h \
           src/util_gui/DocumentFormatComboboxController.h \
           src/util_gui/GObjectComboBoxController.h \
           src/util_gui/GraphUtils.h \
           src/util_gui/GScrollBar.h \
           src/util_gui/GUIUtils.h \
           src/util_gui/ObjectViewTreeController.h \
           src/util_gui/PositionSelector.h \
           src/util_gui/ProjectDocumentComboBoxController.h \
           src/util_gui/ProjectTreeController.h \
           src/util_gui/ProjectTreeItemSelectorDialog.h \
           src/util_gui/RangeSelector.h \
           src/util_ov_annotated_dna/ADVAlignmentSupport.h \
           src/util_ov_annotated_dna/ADVAnnotationCreation.h \
           src/util_ov_annotated_dna/ADVClipboard.h \
           src/util_ov_annotated_dna/ADVConstants.h \
           src/util_ov_annotated_dna/ADVGraphModel.h \
           src/util_ov_annotated_dna/ADVSequenceObjectContext.h \
           src/util_ov_annotated_dna/ADVSequenceWidget.h \
           src/util_ov_annotated_dna/ADVSingleSequenceWidget.h \
           src/util_ov_annotated_dna/ADVSplitWidget.h \
           src/util_ov_annotated_dna/AnnotatedDNAView.h \
           src/util_ov_annotated_dna/AnnotatedDNAViewFactory.h \
           src/util_ov_annotated_dna/AnnotatedDNAViewState.h \
           src/util_ov_annotated_dna/AnnotatedDNAViewTasks.h \
           src/util_ov_annotated_dna/AnnotationsTreeView.h \
           src/util_ov_annotated_dna/DetView.h \
           src/util_ov_annotated_dna/GSequenceGraphView.h \
           src/util_ov_annotated_dna/GSequenceLineView.h \
           src/util_ov_annotated_dna/GSequenceLineViewAnnotated.h \
           src/util_ov_annotated_dna/PanView.h \
           src/util_ov_annotated_dna/PanViewRows.h \
           src/util_ov_annotated_dna/WindowStepSelectorWidget.h \
           src/util_ov_msaedit/MSAEditor.h \
           src/util_ov_msaedit/MSAEditorConsensusArea.h \
           src/util_ov_msaedit/MSAEditorFactory.h \
           src/util_ov_msaedit/MSAEditorNameList.h \
           src/util_ov_msaedit/MSAEditorSequenceArea.h \
           src/util_ov_msaedit/MSAEditorState.h \
           src/util_ov_msaedit/MSAEditorTasks.h \
           src/util_ov_textview/SimpleTextObjectView.h \
           src/util_ov_textview/SimpleTextObjectViewTasks.h \
           src/util_tasks/AddDocumentTask.h \
           src/util_tasks/CopyDataTask.h \
           src/util_tasks/CreateAnnotationTask.h \
           src/util_tasks/LoadDocumentTask.h \
           src/util_tasks/MultiTask.h \
           src/util_tasks/ObjectViewTasks.h \
           src/util_tasks/ReloadScriptTask.h \
           src/util_tasks/RemoveDocumentTask.h \
           src/util_tasks/SaveDocumentTask.h \
           src/util_tasks/SequenceWalkerTask.h \
           src/util_tasks/TaskSignalMapper.h \
           src/util_text/FormatUtils.h \
           src/util_text/TextUtils.h \
           src/workflow/Attribute.h \
           src/workflow/ConfigurationEditor.h \
           src/workflow/Datatype.h \
           src/workflow/DatatypeConversion.h \
           src/workflow/Descriptor.h \
           src/workflow/IntegralBus.h \
           src/workflow/IntegralBusModel.h \
           src/workflow/IntegralBusType.h \
           src/workflow/Schema.h \
           src/workflow/TypeSet.h \
           src/workflow/WorkflowEnv.h \
           src/workflow/WorkflowManager.h \
           src/workflow/WorkflowModel.h \
           src/workflow/WorkflowRegistry.h \
           src/workflow/WorkflowTransport.h \
           src/workflow_library/BioActorLibrary.h \
           src/workflow_library/BioDatatypes.h \
           src/workflow_library/LocalDomain.h \
           src/workflow_support/CoreDataTypes.h \
           src/workflow_support/DelegateEditors.h \
           src/workflow_support/QVariantUtils.h \
           src/workflow_support/SchemaSerializer.h \
           src/workflow_support/TypeMapEditor.h \
           src/workflow_support/WorkflowEnvImpl.h \
           src/workflow_support/WorkflowUtils.h \
           src/test_framework/find_algo/FindAlgorithmTestFormat.h \
           src/test_framework/xmltest/AnnotationTableObjectTest.h \
           src/test_framework/xmltest/BioStruct3DObjectTests.h \
           src/test_framework/xmltest/DNASequenceObjectTests.h \
           src/test_framework/xmltest/DNATranslationImplTests.h \
           src/test_framework/xmltest/DocumentModelTests.h \
           src/test_framework/xmltest/TaskTests.h \
           src/test_framework/xmltest/XMLTestFormat.h \
           src/test_framework/xmltest/XMLTestUtils.h \
           src/util_tasks/SequenceWalkerTests/SequenceWalkerTests.h
FORMS += src/util_find_dialog/ui/FindDialogUI.ui \
         src/util_gui/ui/AddExistingDocumentDialog.ui \
         src/util_gui/ui/AddNewDocumentDialog.ui \
         src/util_gui/ui/AnnotationSettingsDialog.ui \
         src/util_gui/ui/CreateAnnotationWidget.ui \
         src/util_gui/ui/CreateNewObjectDialog.ui \
         src/util_gui/ui/CreateObjectRelationDialog.ui \
         src/util_gui/ui/FormatSettingsDialog.ui \
         src/util_gui/ui/MultipartDocFormatConfiguratorWidget.ui \
         src/util_gui/ui/ProjectTreeItemSelectorDialogBase.ui
SOURCES += src/core_api/AppContext.cpp \
           src/core_api/DBXRefRegistry.cpp \
           src/core_api/DNAAlphabet.cpp \
           src/core_api/DNATranslation.cpp \
           src/core_api/DocumentFormatConfigurators.cpp \
           src/core_api/DocumentFormats.cpp \
           src/core_api/DocumentModel.cpp \
           src/core_api/GObject.cpp \
           src/core_api/IOAdapter.cpp \
           src/core_api/Log.cpp \
           src/core_api/LRegion.cpp \
           src/core_api/MainWindow.cpp \
           src/core_api/NetworkConfiguration.cpp \
           src/core_api/ObjectViewModel.cpp \
           src/core_api/ResourceTracker.cpp \
           src/core_api/ScriptRegistry.cpp \
           src/core_api/SelectionModel.cpp \
           src/core_api/ServiceModel.cpp \
           src/core_api/StateLockableDataModel.cpp \
           src/core_api/Task.cpp \
           src/core_api/UserApplicationsSettings.cpp \
           src/core_api/Vector3D.cpp \
           src/datatype/BioStruct3D.cpp \
           src/datatype/DNASequence.cpp \
           src/datatype/MAlignment.cpp \
           src/datatype/PhyTree.cpp \
           src/document_format/ABIFormat.cpp \
           src/document_format/BaseAlphabets.cpp \
           src/document_format/BaseTranslations.cpp \
           src/document_format/ClustalWAlnFormat.cpp \
           src/document_format/DNAAlphabetRegistryImpl.cpp \
           src/document_format/DNATranslationImpl.cpp \
           src/document_format/DocumentFormatUtils.cpp \
           src/document_format/EMBLGenbankAbstractDocument.cpp \
           src/document_format/EMBLPlainTextFormat.cpp \
           src/document_format/FastaFormat.cpp \
           src/document_format/GenbankLocationParser.cpp \
           src/document_format/GenbankPlainTextFormat.cpp \
           src/document_format/NewickFormat.cpp \
           src/document_format/PDBFormat.cpp \
           src/document_format/PlainTextFormat.cpp \
           src/document_format/RawDNASequenceFormat.cpp \
           src/document_format/SCFFormat.cpp \
           src/document_format/StockholmFormat.cpp \
           src/gobjects/AnnotationSettings.cpp \
           src/gobjects/AnnotationTableObject.cpp \
           src/gobjects/BioStruct3DObject.cpp \
           src/gobjects/DNAChromatogramObject.cpp \
           src/gobjects/DNASequenceObject.cpp \
           src/gobjects/GObjectRelationRoles.cpp \
           src/gobjects/GObjectTypes.cpp \
           src/gobjects/GObjectUtils.cpp \
           src/gobjects/MAlignmentObject.cpp \
           src/gobjects/PhyTreeObject.cpp \
           src/gobjects/TextObject.cpp \
           src/ioadapter/HttpFileAdapter.cpp \
           src/ioadapter/LocalFileAdapter.cpp \
           src/ioadapter/ZlibAdapter.cpp \
           src/selection/AnnotationSelection.cpp \
           src/selection/DocumentSelection.cpp \
           src/selection/GObjectSelection.cpp \
           src/selection/LRegionsSelection.cpp \
           src/selection/SelectionTypes.cpp \
           src/selection/SelectionUtils.cpp \
           src/test_framework/GTest.cpp \
           src/test_framework/GTestFrameworkComponents.cpp \
           src/util_algorithm/FindAlgorithm.cpp \
           src/util_algorithm/FindAlgorithmTask.cpp \
           src/util_algorithm/MSAUtils.cpp \
           src/util_algorithm/ORFAlgorithmTask.cpp \
           src/util_algorithm/ORFFinder.cpp \
           src/util_find_dialog/FindDialog.cpp \
           src/util_gui/AddExistingDocumentDialogImpl.cpp \
           src/util_gui/AddNewDocumentDialogImpl.cpp \
           src/util_gui/AnnotationSettingsDialogController.cpp \
           src/util_gui/BaseDocumentFormatConfigurators.cpp \
           src/util_gui/CreateAnnotationDialog.cpp \
           src/util_gui/CreateAnnotationWidgetController.cpp \
           src/util_gui/CreateObjectRelationDialogController.cpp \
           src/util_gui/DialogUtils.cpp \
           src/util_gui/DocumentFormatComboboxController.cpp \
           src/util_gui/GObjectComboBoxController.cpp \
           src/util_gui/GraphUtils.cpp \
           src/util_gui/GUIUtils.cpp \
           src/util_gui/ObjectViewTreeController.cpp \
           src/util_gui/PositionSelector.cpp \
           src/util_gui/ProjectDocumentComboBoxController.cpp \
           src/util_gui/ProjectTreeController.cpp \
           src/util_gui/ProjectTreeItemSelectorDialog.cpp \
           src/util_gui/RangeSelector.cpp \
           src/util_ov_annotated_dna/ADVAlignmentSupport.cpp \
           src/util_ov_annotated_dna/ADVAnnotationCreation.cpp \
           src/util_ov_annotated_dna/ADVClipboard.cpp \
           src/util_ov_annotated_dna/ADVGraphModel.cpp \
           src/util_ov_annotated_dna/ADVSequenceObjectContext.cpp \
           src/util_ov_annotated_dna/ADVSequenceWidget.cpp \
           src/util_ov_annotated_dna/ADVSingleSequenceWidget.cpp \
           src/util_ov_annotated_dna/ADVSplitWidget.cpp \
           src/util_ov_annotated_dna/AnnotatedDNAView.cpp \
           src/util_ov_annotated_dna/AnnotatedDNAViewFactory.cpp \
           src/util_ov_annotated_dna/AnnotatedDNAViewState.cpp \
           src/util_ov_annotated_dna/AnnotatedDNAViewTasks.cpp \
           src/util_ov_annotated_dna/AnnotationsTreeView.cpp \
           src/util_ov_annotated_dna/DetView.cpp \
           src/util_ov_annotated_dna/GSequenceGraphView.cpp \
           src/util_ov_annotated_dna/GSequenceLineView.cpp \
           src/util_ov_annotated_dna/GSequenceLineViewAnnotated.cpp \
           src/util_ov_annotated_dna/PanView.cpp \
           src/util_ov_annotated_dna/PanViewRows.cpp \
           src/util_ov_annotated_dna/WindowStepSelectorWidget.cpp \
           src/util_ov_msaedit/MSAEditor.cpp \
           src/util_ov_msaedit/MSAEditorConsensusArea.cpp \
           src/util_ov_msaedit/MSAEditorFactory.cpp \
           src/util_ov_msaedit/MSAEditorNameList.cpp \
           src/util_ov_msaedit/MSAEditorSequenceArea.cpp \
           src/util_ov_msaedit/MSAEditorState.cpp \
           src/util_ov_msaedit/MSAEditorTasks.cpp \
           src/util_ov_textview/SimpleTextObjectView.cpp \
           src/util_ov_textview/SimpleTextObjectViewTasks.cpp \
           src/util_tasks/AddDocumentTask.cpp \
           src/util_tasks/CopyDataTask.cpp \
           src/util_tasks/CreateAnnotationTask.cpp \
           src/util_tasks/LoadDocumentTask.cpp \
           src/util_tasks/MultiTask.cpp \
           src/util_tasks/ObjectViewTasks.cpp \
           src/util_tasks/ReloadScriptTask.cpp \
           src/util_tasks/RemoveDocumentTask.cpp \
           src/util_tasks/SaveDocumentTask.cpp \
           src/util_tasks/SequenceWalkerTask.cpp \
           src/util_tasks/TaskSignalMapper.cpp \
           src/util_text/FormatUtils.cpp \
           src/util_text/TextUtils.cpp \
           src/workflow/Attribute.cpp \
           src/workflow/IntegralBus.cpp \
           src/workflow/IntegralBusModel.cpp \
           src/workflow/IntegralBusType.cpp \
           src/workflow/Schema.cpp \
           src/workflow/WorkflowEnv.cpp \
           src/workflow/WorkflowModel.cpp \
           src/workflow/WorkflowRegistry.cpp \
           src/workflow/WorkflowTransport.cpp \
           src/workflow_library/BioActorLibrary.cpp \
           src/workflow_library/BioDataTypes.cpp \
           src/workflow_library/LocalDomain.cpp \
           src/workflow_support/CoreDataTypes.cpp \
           src/workflow_support/DelegateEditors.cpp \
           src/workflow_support/SchemaSerializer.cpp \
           src/workflow_support/TypeMapEditor.cpp \
           src/workflow_support/WorkflowEnvImpl.cpp \
           src/workflow_support/WorkflowUtils.cpp \
           src/test_framework/find_algo/FindAlgorithmTestFormat.cpp \
           src/test_framework/xmltest/AnnotationTableObjectTest.cpp \
           src/test_framework/xmltest/BioStruct3DObjectTests.cpp \
           src/test_framework/xmltest/DNASequenceObjectTests.cpp \
           src/test_framework/xmltest/DNATranslationImplTests.cpp \
           src/test_framework/xmltest/DocumentModelTests.cpp \
           src/test_framework/xmltest/TaskTests.cpp \
           src/test_framework/xmltest/XMLTestFormat.cpp \
           src/test_framework/xmltest/XMLTestUtils.cpp \
           src/util_tasks/SequenceWalkerTests/SequenceWalkerTests.cpp
RESOURCES += core.qrc
TRANSLATIONS += transl/english.ts transl/russian.ts
