/* ==================================================== ======== ======= *
 *
 *  mimio.hh : MIMIO(TM) driver for the UMS.
 *
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet (adapted from code by from R. Diaz & C. Pillias)
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _mimio_hh_
#define _mimio_hh_
#include "umssource.hpp"
#include "umsflow.hpp"
#include <termios.h>
#include <stdio.h>


void makeraw(struct termios*);


/** Mimio event source.
 */
class UMSmimioSource : public UMSeventSource {
public:
  UMSmimioSource(class UMSmouseFlow*, const char* port_name);
  virtual ~UMSmimioSource();

  virtual int open(const char* port_name);  
  ///< returns filedesc ; can be used to reopen the port

  virtual void close();
  virtual bool read();

  virtual bool canCalibrate() const {return true;}
  virtual void calibrate();
  ///< calibrates (or re-calibrates) the MIMIO.

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

private:
  friend class MIMIOFrame;
  static const speed_t BAUDRATE = B19200;
  struct termios old_tty;  // old state of the serial port.
  class MIMIOFrame& frame;
};

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
#endif
