/* ==================================================== ======== ======= *
 *
 *  uxmldefs.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uxmldefs_hpp_
#define _uxmldefs_hpp_
//pragma ident	"@(#)uxmldefs.hpp	ubit:03.06.00"

#include <xercesc/util/XercesDefs.hpp>

#ifdef XERCES_CPP_NAMESPACE
namespace XERCES_CPP_NAMESPACE {
#endif
  class DOMElement;
  class DOMAttr;
  class DOMNode;
  class DOMDocument;
  class XercesDOMParser;
  class ErrorHandler;
#ifdef XERCES_CPP_NAMESPACE
}
using namespace XERCES_CPP_NAMESPACE;
#endif

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/** XML Attribute.
 */
class UXmlAttr {
public:
  UXmlAttr(DOMAttr* a) : dom_attr(a) {}
  virtual ~UXmlAttr() {}
  const DOMAttr* getDomAttr() const {return dom_attr;}

private:
  DOMAttr* dom_attr;
};

/* ==================================================== ======== ======= */
/** XML Element.
 */
class UXmlElem {
public:
  UXmlElem(DOMElement* e) : dom_elem(e) {}
  virtual ~UXmlElem() {}
  const DOMElement* getDomElement() const {return dom_elem;}

protected:
  virtual void createChildren(class UXmlDoc*, UDoc::Errors&);
  ///< [impl] creates and adda the children to the instance tree.
  
private:
  friend class UXmlDoc;
  DOMElement* dom_elem;
};

/* ==================================================== ======== ======= */
/** XML Link Element.
 */
class UXmlLinkElem : public UXmlElem, public UDoc::Link {
public:
  UXmlLinkElem(DOMElement* e) : UXmlElem(e) {}
  virtual UStr* getNamePath() const {return name_path;}
  virtual UStr* getHRefPath() const {return href_path;}

protected:
  uptr<UStr> name_path, href_path;
  virtual void createChildren(class UXmlDoc*, UDoc::Errors&) = 0;
};

/* ==================================================== ======== ======= */
/** XML Object Element (images, etc.).
 */
class UXmlObjectElem : public UXmlElem, public UDoc::Object {
public:
  UXmlObjectElem(DOMElement* e) : UXmlElem(e) {}
  virtual UStr* getSrcPath() const {return src_path;}
  virtual bool isLoaded() const = 0;
  virtual int  load() = 0;

protected:
  uptr<UStr> src_path;
  virtual void createChildren(class UXmlDoc*, UDoc::Errors&) = 0;
};

/* ==================================================== ======== ======= */

/** XML Attribute Model (for defining DTDs).
 */
struct UXmlAttrModel {
  const char* cname;
  class UBrick* (*create)(class DOMAttr*, UDoc::Errors&);
  mutable XMLCh* dom_name;
};

/** XML Element Model (for defining DTDs).
 */
struct UXmlElemModel {
  const char* cname;
  class UBrick* (*create)(class DOMElement*);
  mutable XMLCh* dom_name;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

