/* ==================================================== ======== ======= *
 *
 *  uustyle.cc
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uustyle.cc	ubit:03.01.00"
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uprop.hpp>
#include <uctrl.hpp>
#include <ufont.hpp>
#include <ucolor.hpp>
#include <uborder.hpp>
#include <ustyle.hpp>
#include <uview.hpp>


UColor** UStyle::makeColors(UColor *off, UColor *on) {
  UColor** colors =
    (UColor**)malloc(2 * UOn::ACTION_COUNT * sizeof(UColor*));

  for (int k = 0; k < UOn::ACTION_COUNT; k++) {
    colors[k] = off;
    colors[UOn::ACTION_COUNT + k] = on;
  }
  return colors;
}

void UStyle::setColor(UColor **colors, int action, UColor*c) {
  colors[action] = c;
  colors[UOn::ACTION_COUNT + action] = c;
}

void UStyle::setColors(int action, UColor&c,
		       bool when_unselected, bool when_selected) {
  if (when_unselected) fgcolors[action] = &c;
  if (when_selected)   fgcolors[UOn::ACTION_COUNT + action] = &c;
}

void UStyle::setBgcolors(int action, UColor&c,
			 bool when_unselected, bool when_selected) {
  if (when_unselected) bgcolors[action] = &c;
  if (when_selected)   bgcolors[UOn::ACTION_COUNT + action] = &c;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

const UColor* UStyle::getColor(const UCtrl *st) const {
  return (fgcolors ? 
	  fgcolors[st->isSelected() * UOn::ACTION_COUNT + (int)st->getState()]
	  : &UColor::inherit);
}

const UColor* UStyle::getBgcolor(const UCtrl *st) const {
  return (bgcolors ?
	  bgcolors[st->isSelected()*UOn::ACTION_COUNT + (int)st->getState()]
	  : &UBgcolor::inherit);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle::UStyle() {
  viewStyle      = &UView::style;

  // text separator between two children when printing
  textSeparator = null;
  orient = UOrient::INHERIT;
  local.halign   = UHalign::LEFT;
  local.valign   = UValign::TOP;
  local.hspacing = 0;
  local.vspacing = 0;
  local.padding.set(0, 0);

  // xpos,ypos DOIVENT etre = 0 sinon decalage systmatique
  // (sert pour effets speciaux et position controlee par UPos)
  local.xpos     = 0;
  local.ypos     = 0;
  // size will automatically adapt
  local.width    = UWidth::AUTO_RESIZE;
  local.height   = UHeight::AUTO_RESIZE;

  // alpha blending
  local.alpha    = 1.0;
  //local.layer  = 0;

  local.border   = null;
  local.edit     = null;
  local.content  = null;
  local.shape    = null;
  local.background = null;

  //NB: null devrait etre equivalent a inherit pour:
  // font, cursor, color, bgcolor
  font          = &UFont::inherit;
  cursor        = null;

  static UColor **standard_fgcolors 
    = makeColors(&UColor::inherit, &UColor::white); 

  setColor(standard_fgcolors, UOn::DISABLED, &UColor::disabled);

  static UColor **standard_bgcolors 
   = makeColors(&UBgcolor::none, &UBgcolor::black);

  fgcolors = standard_fgcolors;
  bgcolors = standard_bgcolors;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

