/* ==================================================== ======== ======= *
 *
 *  uupixmaps.cpp
 *  a wrapping for using some of the great FVWM pixmaps in the Ubit toolkit
 *  
 *
 * ==================================================== [Elc:00] ======= *
 * ==================================================== ======== ======= *

Mini XPM icon package (for fvwm).
Version 1
Free (F) by Ludvig A. Norin 1995
emph@ludd.luth.se

This package contains 14x14 pixel icons
for use with the FVWM 2.x distribution.
The icons might of course be used in just
about any other purpose you can think of,
but since FVWM is such a great wm, I
really suggest that you use them in it,
rather than putting them in your private
.JPG/.GIF pictures just for the fun of it.

The icons are small enough to give the
FVWM menus a spiffy outlook. The icons
are optimized to use as few colors as
possible, and they will totally occypy
14 entrys of the colormap.

 * ==================================================== ======== ======= */

#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uprop.hpp>
#include <ucolor.hpp>
#include <uima.hpp>
#include <uctrl.hpp>

const char *fvwm_mini_bomb_xpm[] = {
  // width height ncolors chars_per_pixel [x_hot y_hot]
"16 16 6 1",
"       c None s None",
".      c black",
"X      c #808080",
"o      c #c0c0c0",
"O      c yellow",
"#      c white",
"                ",
"       ...      ",
"      .   .     ",
"     .     .    ",
"    ...     .   ",
"   .....    .   ",
"  .X#o...    .  ",
" X.#X....X   .  ",
" ..oX.....   O O",
" .......O. O OO ",
" ......Xo.  OOO ",
" X.....X.X  O   ",
"  .......       ",
"   X...X        ",
"                ",
"                "};

const char * fvwm_mini_clock_xpm[] = {
"16 14 4 1",
"       c None s None",
".      c Black",
"X      c White",
"o      c gray85",
"      .....     ",
"    ..XXXXX..   ",
"   .oXXX.XXXo.  ",
"   .XXXX.XXXX.  ",
"  .XXXXX.XXXXX. ",
"  .XXXXX.XXXXX. ",
"  .XXXX..XXXXX. ",
"  .XXXXX..XXXX. ",
"  .XXXXX.X.XXX. ",
"   .XXXXXXXXX.  ",
"   .oXXXXXXXo.  ",
"    ..XXXXX..   ",
"      .....     ",
"                "};

const char * fvwm_mini_colors_xpm[] = {
"16 14 7 1",
"       c None s None",
".      c gray50",
"X      c red",
"o      c yellow",
"O      c blue",
"+      c black",
"#      c white",
"                ",
"                ",
" .............. ",
" .XXXXooooOOOO.+",
" .XXXXooooOOOO.+",
" .XXXXooooOOOO.+",
" .XXXXooooOOOO.+",
" .####....++++.+",
" .####....++++.+",
" .####....++++.+",
" .####....++++.+",
" ..............+",
"  ++++++++++++++",
"                "};

const char *fvwm_mini_edit_xpm[] = {
"    16    14       5            1",
"  c None s None",
". c black",
"# c gray50",
"i c white",
"o c blue",
"#########       ",
"#iiiiiii#.      ",
"#i#####i#i.    o",
"#iiiiiii#...  oo",
"#i#####iiii. oo.",
"#iiiiiiiiii.oo. ",
"#i########ioo.  ",
"#iiiiiiiiioo.   ",
"#i#######.o.    ",
"#iiiiiii....    ",
"#i#####...i.    ",
"#iiiii.iiii.    ",
"#iiiiiiiiii.    ",
"............    "
};

/*
const char *fvwm_mini_exp_xpm[] = {
"16 16 4 1",
"       c None s None",
".      c black",
"X      c #808080",
"o      c yellow",
"                ",
"       .        ",
"       .   .X   ",
"      .o. ..    ",
" ......oo.o.    ",
"  .oooooooo....X",
"   .oooooooooo. ",
"    .oooooooo.  ",
"   ..ooooooo.   ",
"   .oooooooo.   ",
"  .oo..oo..oo.  ",
" .... .oo. ...  ",
" X     ..    .X ",
"        .       ",
"                ",
"                "};
*/

const char * fvwm_mini_eyes_xpm[] = {
"16 14 5 1",
"       c None s None",
".      c black",
"O      c gray50",
"X      c gray85",
"o      c white",
"                ",
"                ",
"  ....   ....   ",
" .XooX. .XooX.  ",
".XooooX.XooooX. ",
".oooooo.oooooo.O",
".oooooo.oooooo.O",
".o..ooo.o..ooo.O",
".X..ooX.X..ooX.O",
" .XooX.O.XooX.OO",
"  ....OO ....OO ",
"   OOOO   OOOO  ",
"                ",
"                "};

const char * fvwm_mini_mail_xpm[] = {
"16 14 4 1",
"       c None s None",
".      c black",
"X      c white",
"o      c gray50",
"                ",
"                ",
" .............  ",
" .XXXXXXXXXXX.o ",
" ..XXXXXXXXX..o ",
" .X.XXXXXXX.X.o ",
" .XX.XXXXX.XX.o ",
" .XX..XXX..XX.o ",
" .X.XX...XX.X.o ",
" ..XXXXXXXXX..o ",
" .............o ",
"  ooooooooooooo ",
"                ",
"                "};

const char * fvwm_mini_book_xpm[] = {
"16 14 6 1",
"       c None s None",
".      c Black",
"X      c Red",
"o      c Yellow",
"O      c gray50",
"+      c White",
"       ..       ",
"      .XX.      ",
"     .XXXX.     ",
"    .XXXoXX.    ",
"   .XXXoXoXX.   ",
"  .XXXXXoXoX.   ",
" .XXXXXXXoX.O   ",
" ..XXXXXXX.+.O  ",
" .+.XXXXX.+.O   ",
"  .+.XXX.+.O    ",
"   .+.X.+.O     ",
"    .+.+.O      ",
"     .+.O       ",
"      .O        "};

const char *fvwm_mini_paint_xpm[] = {
  // width height ncolors chars_per_pixel [x_hot y_hot]
"    16    14       6            1",
  // colors 
"  c None s None",
". c black",
"# c gray50",
"a c red",
"i c white",
"o c blue",
/* pixels */
"#########       ",
"#iiiiiii#.      ",
"#iiiiiii#i.    o",
"#iiiiiii#...  oo",
"#iiiiiiiiii. oo.",
"#iiaiiiiiii.oo. ",
"#iiiaaiiiiioo.  ",
"#iiiiaaiiioo.   ",
"#iiiaaaiioo.    ",
"#iiaaaii#...    ",
"#iiaaii#i.i.    ",
"#iaaaaaa.ii.    ",
"#iaaaaaiiii.    ",
"............    "
};

/*
const char *fvwm_mini_palette_xpm[] = {
"16 16 9 1 0 0",
"       s none  m none  c none",
".      s iconColor1    m black c black",
"X      s iconColor6    m white c yellow",
"o      s iconColor8    m black c magenta",
"O      c #0000FFFF0000",
"+      s iconColor4    m white c green",
"@      c #808080808080",
"#      s iconColor3    m black c red",
"$      s iconColor5    m black c blue",
"    ...         ",
"   .XXX..       ",
"  .XXXXXX.      ",
" .XXXoooXX.    .",
".XXXXooo.X..  ..",
".XXO+@..XXX. .. ",
".X+++@XXXXXX..  ",
".X@@@XXXX.@..X. ",
".XXXXXXXX....XX.",
" .X###.XXX..XXX.",
" .X###.XXXXXXXX.",
"  .X..X$$$$$XXX.",
"   .XXX$$$$XXX. ",
"    ...XXXXX..  ",
"   @.. .....    ",
" @@..           "};
*/

const char * fvwm_mini_question_xpm[] = {
"16 14 5 1",
"       c None s None",
".      c red",
"X      c white",
"o      c black",
"O      c gray50",
"     ......     ",
"    .X......    ",
"   .X..oo...o   ",
"   ...o  ...o   ",
"    oo   ...o   ",
"        ...o    ",
"       ...o     ",
"      ..oo      ",
"      ....o     ",
"      O.oO      ",
"      OX..      ",
"      ....O     ",
"       ..oO     ",
"        oO      "};

const char * fvwm_mini_ray_xpm[] = {
"16 14 4 1",
"       c None s None",
".      c black",
"X      c gold",
"o      c gray50",
"     .........  ",
"     .XXXXXX.o  ",
"    .XXXXXX.o   ",
"    .XXXXX.o    ",
"   .XXXXX.o     ",
"   .XXXX.....   ",
"  .XXXXXXXX.o   ",
"  .....XXX.o    ",
"   oo.XXX.o     ",
"     .XX.o      ",
"    .XX.o       ",
"    .X.o        ",
"   .X.o         ",
"   ..o          "};

const char * fvwm_mini_stop_xpm[] = {
"16 14 5 1",
"       c None s None",
".      c gray50",
"X      c red",
"o      c white",
"O      c black",
"    ........    ",
"   .XXXXXXXX.   ",
"  .XXXXXXXXXX.  ",
" .XXXXXXXXXXXX. ",
".XXoooooXoXXooXO",
".XoXXXoXoXoXoXoO",
".XXoXXoXoXoXooXO",
".XXXoXoXoXoXoXXO",
".XooXXoXXoXXoXXO",
".XXXXXXXXXXXXXXO",
" .XXXXXXXXXXXXO.",
"  .XXXXXXXXXXO. ",
"   .XXXXXXXXO.  ",
"    OOOOOOOO.   "};

/*
const char *fvwm_mini_term_xpm[] = {
"    16    14        6            1",
"  c None s None",
". c Black",
"# c gray50",
"a c blue",
"b c White",
"c c gray85",
"     #########  ",
"    #cccccccc#. ",
"   #bbbbbbbb##. ",
"   #b......b##. ",
"   #b.aaaaab##. ",
"   #b.aaaaab##. ",
"   #b.aaaaab##. ",
"   #bbbbbbbb#.##",
"   #.........#c.",
"  #bbbbbbbbb#c#.",
"  ##.#.#.#.#.##.",
" #c.c.c.c.c.c.. ",
"#bbbbbbbbbbbc.  ",
".............   "
};

const char * fvwm_mini_bricks_xpm[] = {
"16 14 5 1",
"       c None s None",
".      c gray50",
"X      c yellow",
"o      c black",
"O      c red",
"                ",
"                ",
"     ......     ",
"     .XXXXo     ",
"     .XOOOo     ",
"     .XOOOo     ",
"     .XOOOo     ",
"......OOOOoooooo",
".XXXXOXXXXOXXXXo",
".XOOOOXOOOOXOOOo",
".XOOOOXOOOOXOOOo",
".XOOOOXOOOOXOOOo",
".ooooooooooooooo",
"                "};

const char * fvwm_mini_camera_xpm[] = {
"16 14 4 1",
"       c None s None",
".      c black",
"X      c white",
"o      c gray50",
"      ......    ",
"     .XXXXXX.   ",
" ....Xo...oX... ",
".XXXX.......XXX.",
".......ooo......",
".Xoo..oXXoo..oo.",
".Xoo..oXooo..oo.",
".Xoo..ooooo..oo.",
".Xooo..ooo..ooo.",
".Xooo.......ooo.",
".Xooooo...ooooo.",
" .............. ",
"                ",
"                "};
*/

const char * fvwm_mini_windows_xpm[] = {
"16 14 4 1",
"       c None s None",
".      c Black",
"X      c blue",
"o      c white",
"..........      ",
".XXXXXXXX.      ",
".oooooooo.      ",
".ooooo..........",
".ooooo.XXXXXXXX.",
".ooooo.oooooooo.",
".oo..........oo.",
".oo.XXXXXXXX.oo.",
"....oooooooo.oo.",
"   .oooooooo.oo.",
"   .oooooooo.oo.",
"   .oooooooo....",
"   .oooooooo.   ",
"   ..........   "};

/*
const char *fvwm_mini_left_xpm[] = {
  "14 11 2 1",
  ". c None s None",
  "# c red",
  "..............",
  "....#.........",
  "...##.........",
  "..#########.##",
  ".#######.#.#..",
  "#########.#..#",
  ".######.##.#..",
  "..########.#.#",
  "...##.........",
  "....#.........",
  "..............",
};
*/
const char *fvwm_mini_left_xpm[] = {
  // width height num_colors chars_per_pixel
  "12 11 2 1",
  ". c None s None",
  "# c orange",
  "............",
  "....#.......",
  "...##.......",
  "..#########.",
  ".##########.",
  "###########.",
  ".##########.",
  "..#########.",
  "...##.......",
  "....#.......",
  "............",
};

/*
const char *fvwm_mini_right_xpm[] = {
  "14 11 2 1",
  ". c None s None",
  "# c red",
  "..............",
  ".........#....",
  ".........##...",
  "##.#########..",
  "..#.#.#######.",
  "#..#.#########",
  "..#.##.######.",
  "#.#.########..",
  ".........##...",
  ".........#....",
  "..............",
};
*/
const char *fvwm_mini_right_xpm[] = {
  // width height num_colors chars_per_pixel
  "12 11 2 1",
  ". c None s None",
  "# c orange",
  "............",
  ".......#....",
  ".......##...",
  ".#########..",
  ".##########.",
  ".###########",
  ".##########.",
  ".#########..",
  ".......##...",
  ".......#....",
  "............",
};

/*
const char * fvwm_mini_raise_xpm[] = {
  "11 14 2 1",
  "       c None s None",
  ".      c red",
  "     .     ",
  "    ...    ",
  "   .....   ",
  "  .......  ",
  " ......... ",
  "   .....   ",
  "   .....   ",
  "   ... .   ",
  "   . ...   ",
  "   .. ..   ",
  "   . .     ",
  "    . ..   ",
  "   .       ",
  "   . . .   "};
 */
const char * fvwm_mini_raise_xpm[] = {
  // width height num_colors chars_per_pixel
  "11 12 2 1",
  "       c None s None",
  ".      c orange",
  "     .     ",
  "    ...    ",
  "   .....   ",
  "  .......  ",
  " ......... ",
  "   .....   ",
  "   .....   ",
  "   .....   ",
  "   .....   ",
  "   .....   ",
  "   .....   ",
  "           "};

/*
const char *fvwm_mini_lower_xpm[] = {
  "11 14 2 1",
  "       c None s None",
  ".      c red",
  "   . . .   ",
  "   .       ",
  "    . ..   ",
  "   . .     ",
  "   .. ..   ",
  "   . ...   ",
  "   ... .   ",
  "   .....   ",
  "   .....   ",
  " ......... ",
  "  .......  ",
  "   .....   ",
  "    ...    ",
  "     .     "};
 */
const char *fvwm_mini_lower_xpm[] = {
   // width height num_colors chars_per_pixel
   "11 12 2 1",
   "       c None s None",
   ".      c orange",
   "           ",
   "   .....   ",
   "   .....   ",
   "   .....   ",
   "   .....   ",
   "   .....   ",
   "   .....   ",
   " ......... ",
   "  .......  ",
   "   .....   ",
   "    ...    ",
   "     .     "};

/*
const char *fvwm_boule_xpm[] = {
"10 10 8 1",
". c None s None",
"X c None s None",
"O c gray55",
"+ c #acacac",
"@ c #bcbcbc",
"# c gainsboro",
"$ c #ececec",
"% c white",
"..X###@...",
".@#$%%%#O.",
"X#$%%$$#@.",
"#$%%$$##@O",
"#%%$$##@@O",
"#%$$##@@+O",
"@%$##@@++O",
"X###@@++O.",
".O@@@++O..",
"..XOOOO...",
};
*/

UPix UPix::book(fvwm_mini_book_xpm,UMode::UCONST);
UPix UPix::edit(fvwm_mini_edit_xpm, UMode::UCONST);
UPix UPix::clock(fvwm_mini_clock_xpm, UMode::UCONST);
UPix UPix::stop(fvwm_mini_stop_xpm, UMode::UCONST);
UPix UPix::ray(fvwm_mini_ray_xpm, UMode::UCONST);
UPix UPix::question(fvwm_mini_question_xpm, UMode::UCONST);
UPix UPix::colors(fvwm_mini_colors_xpm, UMode::UCONST);
UPix UPix::windows(fvwm_mini_windows_xpm, UMode::UCONST);
UPix UPix::bomb(fvwm_mini_bomb_xpm, UMode::UCONST);
UPix UPix::eyes(fvwm_mini_eyes_xpm, UMode::UCONST);
UPix UPix::leftarrow(fvwm_mini_left_xpm, UMode::UCONST);
UPix UPix::rightarrow(fvwm_mini_right_xpm, UMode::UCONST);
UPix UPix::uparrow(fvwm_mini_raise_xpm, UMode::UCONST);
UPix UPix::downarrow(fvwm_mini_lower_xpm, UMode::UCONST);

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:02] ======= */
