#include "config.h"
#ifdef HAVE_LIBXPM
/* ==================================================== ======== ======= *
 *
 *  uunatxpm.cc : glue with the XPM library.
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2002 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:02] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uunatxpm.cc ubit:03.04.00"
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uerror.hpp>
#include <ucolor.hpp>
#include <ufont.hpp>
#include <uappli.hpp>
#include <unatima.hpp>
#include <unatdisp.hpp>
#include <uima.hpp>
#include <X11/xpm.h>


static void initXPMattributes(UNatDisp *nd, 
			      XpmAttributes  &attributes, 
			      XpmColorSymbol &symbol) {
  // cherche couleurs approchees avec une large tolerance
  attributes.exactColors = false;
  attributes.closeness   = 100000;

  // specifier la bonne combinaison depth / visual / colormap c'est-a-dire
  // celle qui est definie par de UNatDisp
  attributes.depth     = nd->getDepth();
  attributes.colormap  = nd->getXColormap();
  attributes.valuemask = XpmExactColors | XpmCloseness | XpmDepth | XpmColormap;

  // !att: visual can be null in which case it should not be given 
  // as an attribute to Xpm functions
  // (note that the visual also specifies the screen number)
  if ((attributes.visual = nd->getXVisual()) != null)
    attributes.valuemask |= XpmVisual;

  /*
  if (!transp_bg) {   // no transparent -> take specified color as bg
    symbol.name  = NULL;
    symbol.value = (char*)"none";
    symbol.pixel = bg;
    attributes.colorsymbols = &symbol;
    attributes.numsymbols   = 1;
    attributes.valuemask   |= XpmColorSymbols;
    }*/
}

static int decodeXPMstatus(int stat) {
  if (stat >= 0) return UFilestat::Opened;
  else switch(stat) {
  case XpmFileInvalid:
    return UFilestat::InvalidData;
  case XpmOpenFailed:
    return UFilestat::CannotOpen;
  case XpmNoMemory:
    return UFilestat::NoMemory;
  default:
    return UFilestat::MiscError;
  }
}

/* ==================================================== ======== ======= */

int UNatIma::xpmFileReader(UNatDisp *nd, const char *fpath, UNatIma*& natima)
{
  natima = null;
  if (!fpath || !fpath[0]) return UFilestat::CannotOpen;

  XpmAttributes attr;
  XpmColorSymbol symbol;  
  initXPMattributes(nd, attr, symbol);

  UX_Image ima = null, shapeima = null;
  int stat = XpmReadFileToImage(nd->getXDisplay(), (char*)fpath,
				&ima, 
				&shapeima, //(transp_bg ? &shapeima : NULL),
				&attr);
  stat = decodeXPMstatus(stat);
  if (stat >= UFilestat::Opened) {
    //width  = attr.width; height = attr.height;
    natima = new UNatIma(nd, ima, shapeima);
  }
  return stat;
}

/* ==================================================== ======== ======= */

int UNatIma::xpmDataReader(UNatDisp *nd, const char *xpmdata, UNatIma*& natima)
{
  natima = null;
  char **data = (char**)xpmdata;
  if (!data || !data[0]) return UFilestat::CannotOpen;

  XpmAttributes attr;
  XpmColorSymbol symbol;  
  initXPMattributes(nd, attr, symbol);

  UX_Image ima = null, shapeima = null;
  int stat = XpmCreateImageFromData(nd->getXDisplay(), data,
				    &ima,
				    &shapeima, //(transp_bg ? &shapeima : NULL),
				    &attr);
  stat = decodeXPMstatus(stat);
  if (stat >= UFilestat::Opened) {
    //width  = attr.width; height = attr.height;
    natima = new UNatIma(nd, ima, shapeima);
  }
  return stat;
}

/* ==================================================== ======== ======= */
// creates a native pixmap from a X11-XBM file
/*
 include <X11/Xmu/Drawing.h>

int XbmFileReader(UNatDisp *nd, const char *fpath,
		  UX_Image &ima, UX_Image &shapeima
		  u_dim &width, u_dim &height) {
  //NB: XReadBitmapFileData PAS DANS X11r5 !!!
  unsigned char *read_data = NULL;
  Pixmap pix = None;

  if (fpath ) {
    unsigned int ww, hh;
    int x_hot, y_hot;
    int result = XmuReadBitmapDataFromFile((char*)fpath,
					   &ww, &hh, &read_data,
					   &x_hot, &y_hot);
    if (result != BitmapSuccess || !read_data)
      uwarning("UNatPix::createPixmap", "Could not read XBitmap file '%s'", fpath);
    else {
      xpm_data = (char*)read_data;
      width = ww, height = hh;
    }
  }

  // The XCreatePixmapFromBitmapData function creates a pixmap of
  // the given depth and then does a bitmap-format XPutImage of
  // the data into it.  The depth must be supported by the screen
  // of the specified drawable, or a BadMatch error results.
  if (xpm_data) {
    pix = XCreatePixmapFromBitmapData(nd->getXDisplay(), nd->getXWindow(),
				      xpm_data, width, height,
				      nd->getXPixel(fg), nd->getXPixel(bg),
				      nd->getDepth());
  }
  if (read_data) XFree(read_data);

  if (pix == None) return null;
  else return new UNatPix(nd, pix, None, width, height);
}
*/

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
#endif
