/* ==================================================== ======== ======= *
 *
 *  uuflowview.cpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuflowview.cpp	ubit:03.06.04"
#include <iostream>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <ustr.hpp>
#include <uctrl.hpp>
#include <ucontext.hpp>
#include <ubox.hpp>
#include <uboxImpl.hpp>
#include <ustyle.hpp>
#include <uborder.hpp>
#include <uview.hpp>
#include <uviewImpl.hpp>
#include <utable.hpp>
#include <ugraph.hpp>
#include <ucolor.hpp>
#include <uevent.hpp>
#include <uedit.hpp>
using namespace std;

#define MIN_WIDTH_HINT   100  // A_REVOIR
#define LINE_QUANTUM 20
#define CELL_QUANTUM 25

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

struct UFlowCell {
  ULink* link;
  int line;
  int offset, len;
  u_dim w, h;
};

struct UFlowLine {
  u_dim w, h;
  short hflexChildCount;
  bool empty;
};

UViewStyle UFlowView::style(&UFlowView::makeView, UMode::UCONST);

UFlowView::UFlowView(UBoxLink *box_link, UView* par_view, UWinGraph *wgraph) 
  : UView(box_link, par_view, wgraph) {
  lines = null;
  cells = null;
  line_count = cell_count = 0;
  alloc_line_count = alloc_cell_count = 0;
}

// "static" constructor used by UViewStyle to make a new view

UView* UFlowView::makeView(UBoxLink*bl, UView* parview, 
			      UWinGraph *wgraph){
  return new UFlowView(bl, parview, wgraph);
}

UFlowView::~UFlowView() {
  if (lines) {free(lines); lines = null;}
  if (cells) {free(cells); cells = null;}
  alloc_line_count = 0;
  alloc_cell_count = 0;
  line_count = 0;
  cell_count = 0;
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

static void flowGetHints(UView *view, UContext &curp, 
			 UGroup *grp, UViewLayout &vl);


void UFlowView::getHints(UContext &parp, UViewLayout &vl) {
  UBox *box = getBox();
  vflex_count = hflex_count = 0;
  vl.spec_w = vl.spec_h = -1;
  vl.cmin_w = vl.cmax_w = 0;
  vl.cmin_h = vl.cmax_h = 0;
  vl.line_h = vl.line_w = 0;

  UContext curp(box, this, parp);
  flowGetHints(this, curp, box, vl);

  if (vl.spec_w < UWidth::KEEP_SIZE) {  // autoResize
    chwidth = vl.cmax_w; // chwidth n'est pas la taille des enfants!
    width = vl.cmax_w;
  }
  else {			// keepSize ou fixedSize
    setVmodes(UView::FIXED_WIDTH, true);
    if (width <= 0) {		// w <=0 : initialization
      chwidth = std::max(vl.spec_w, vl.cmax_w);
      if (vl.spec_w > UWidth::KEEP_SIZE)
	width = vl.spec_w;              // set spec.
      else
	width = chwidth; // chwidth n'est pas la taille des enfants!
    }
    // else if width >0, it is not changed;
  }
	

  if (vl.spec_h < UHeight::KEEP_SIZE) {  // autoResize
    chheight = vl.cmax_h;  // chheight n'est pas la taille des enfants!
    height = vl.cmax_h;
  }
  else {			// keepSize ou fixedSize
    setVmodes(UView::FIXED_HEIGHT, true);
    if (height <= 0) {		// h <=0 : initialization
      chheight = std::max(vl.spec_h, vl.cmax_h);
      if (vl.spec_h > UHeight::KEEP_SIZE)
	height = vl.spec_h;              // set spec.
      else
	height = chheight; // chheight n'est pas la taille des enfants!
    }
  }

  // box->flexCount = vd.flexCount; // ??
  // shown = false;
};

/* ==================================================== ======== ======= */

static void alaligne(UViewLayout &vl, UContext &curp) {
  // vl.wmax est le max de toutes les lignes
  vl.cmax_w = std::max(vl.cmax_w, vl.line_w);
  vl.cmax_h += vl.line_h += curp.local.vspacing; // moins 1 fois
  vl.line_w = 0;
  vl.line_h = 0;
}

/* ==================================================== ======== ======= */

static void Insecables(UStr *str, UViewLayout &vl, UContext &curp) {
  UFlowCell cell;
  u_dim chww = 0;
  int startchar = 0;
  do {
    cell.offset = startchar;
    // decouper en tokens INSECABLEs
    // str->getSize(&curp, 2,/*MAX = 2 pour s''arreter au 1er separ*/chww, &cell);

    u_dim maxwidth = 2;
    const char* s = str->chars();
    int len = str->length();

    if (s && *s) {
      cell.len = curp.winview->wg().getSubTextSize(&curp.fontdesc, 
						   s + cell.offset,
						   len - cell.offset,
						   maxwidth, chww, 
						   &(cell.w), &(cell.h));
      // sinon il n'y aura pas de place pour afficher le caret en fin de ligne
      // cell->width += 1;
      //cell.truncated = (cell.offset + cell.len < len);
    }
    else {    // voir NOTES ci-dessus
      cell.len = 0;
      cell.w = 1; // $$$$
      cell.h = curp.winview->wg().getTextHeight(curp.fontdesc);
      //cell.truncated = false;
    }

    static char tmp[1000];
    {int k;
    for (k = 0; k < cell.len; k++)
      tmp[k] = str->chars()[startchar+k];
    tmp[k] = 0;
    }
    
    if (cell.w > 0) {
      // l'element devra avoir une taille au moins egale a celle de
      // son plus grand enfant INSECABLE
      vl.cmin_w = std::max(vl.cmin_w, cell.w);
      vl.cmin_h += cell.h;

      // pour une ligne
      vl.line_w += cell.w; // moins 1 fois a la fin
      vl.line_h = std::max(vl.line_h, cell.h);
      startchar += cell.len;
      //sauf q'on passe a la ligne a chaque mot

      if (str->chars()[startchar-1] == '\n') {
	// CR en fin de string ==> passer a la ligne
	//	printf("Insecables1:ligne\n");
	alaligne(vl, curp);
      }
    }
    else {
      // Apparemment on ne passe jamais par la....
      //      printf("Insecables2:ligne\n");
      alaligne(vl, curp);
      startchar += cell.len;
    }
  } while (startchar < str->length());
}

/* ==================================================== ======== ======= */

static void flowGetHints(UView *view, UContext &curp, 
			 UGroup *grp, UViewLayout &vl) {
  UMultiList mlist(curp, grp, true); // rescale

  // if this group is not null (which generally is the case) the object
  // it contains are added to children for normal display
  // (can for instance be used for adding list-item markers, checkboxes...
  
  if (curp.local.content) {
    UGroup *content = curp.local.content;     // pas de curp, meme vd
    curp.local.content = null;	// avoid infinite recursion
    flowGetHints(view, curp, content, vl);
  }

  for (ULink *ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {
      
	UBrick *b = ch->getChild();
	UView *chboxview = null;
	UViewLayout chvl;  //!att: reset by constr.
	UGroup *chgrp = null;

	if (b->propCast())  
	  b->propCast()->putProp(&curp, grp);
	
	else if (b->elemCast()) {
	  // HYPOTHESE: 
	  // tout a la suite quand c'est possible
	  // si <br> ou \n ou impose par type passer alaligne !!!

	  // cas particulier des UStr: trouver aussi la taille min, si un seul mot
	  // par ligne
	  UStr *str = b->strCast();
	  if (str)
	    Insecables(str, vl, curp);
	  else {
	    // pour tous les elems: taille nominale des UPix et taille 'naturelle'
	    // (= si il n'y avait pas de contrainte) des UStr
	    b->elemCast()->getSize(&curp, &(chvl.spec_w), &(chvl.spec_h));
	    
	    // l'element devra avoir une taille au moins egale a celle de
	    // son plus grand enfant
	    vl.cmin_w = std::max(vl.cmin_w, chvl.spec_w);
	    vl.cmin_h += chvl.spec_h;

	    // pour une ligne
	    vl.line_w += chvl.spec_w + curp.local.hspacing; // moins 1 fois a la fin
	    vl.line_h = std::max(vl.line_h, chvl.spec_h);
	  }
	} //end(elemCast)

	
	else if ((chgrp = b->groupCast()) && chgrp->isShowable()) {

	  if (b->boxCast()) {  // QUE boxCast
	    
	    //if (chgrp->isDef(0,UMode::INBOX)) {
	    if (chgrp->isDef(0,UMode::BOX)) {

	      //!att: UBoxLink ou WinLink!
	      if ((chboxview = ((UBoxLink*)ch)->getViewInside(view))) {

		if (chgrp->isDef(0, UMode::FLOATING)) {
		  //vd.mustLayoutAgain |=
		  chboxview->doLayout(curp, chvl);
		}

		else {
                  if (chboxview->getViewStyle() == &UFlowView::style) {
		    ((UFlowView*)chboxview)->getHints(curp, chvl);
                  }

		  //else if(chboxview->getViewStyle() == &UTableView::style) 
		  //((UTableView*)chboxview)->getHints(&curp, chvl);

		  // autres objets
		  else chboxview->doLayout(curp, chvl);

		  // !!if (alaligne_debut) alaligne(vl, curp);!!!!!

		  // l'element devra avoir une taille au moins egale a celle
		  // de la taille min de son plus grand enfant insecable
		  vl.cmin_w = std::max(vl.cmin_w, chvl.cmin_w);
		  vl.cmin_h += chvl.cmin_h;
		  
		  // pour une ligne
		  vl.line_w += chvl.cmax_w + curp.local.hspacing;// moins 1 fois a la fin
		  vl.line_h = std::max(vl.line_h, chvl.cmax_h);
		  
		  ////!!!!!!if (alaligne_fin) alaligne(vl, curp);!!!!
		}
	      }
	    } //endif(UMode::INBOX)
	  }
	  else { //just an UGroup
	    UContext chcurp(chgrp, view, curp);   // own curp, same vd
	    flowGetHints(view, chcurp, chgrp, vl);
	  }
	}
    }

  // la suite ne concerne pas les UGroup
  if (grp->boxCast()) {

    // a la ligne final
    // Les UTcell COMMENCENT et se TERMINENT par un alaligne! A COMPTER!!
    alaligne(vl, curp);

    // NOTE That: value >=0 means: "fixed width"
    vl.spec_w = curp.local.width;
    vl.spec_h = curp.local.height;
    // whint et hhint seront negatifs si indefinis
    // ==> ne PAS y toucher, meme si definis et < valeurs min
 
    // retrancher le spacing compte en trop (si au moins un element)
    if (vl.cmax_w > 0) vl.cmax_w -= curp.local.hspacing; 
    if (vl.cmax_h > 0) vl.cmax_h -= curp.local.vspacing; 

    // rajouters  borders et marges
    UMargins margins(0, 0);

    if (curp.local.border) {

      // !!! A COMPLETER !!!

      //curp.local.border->doLayout(view, curp, margin);
      curp.local.border->getSize(curp, margins); // !!!!!
    }

    int aux = margins.left + margins.right
      + curp.local.padding.left + curp.local.padding.right;
    vl.cmin_w += aux;
    vl.cmax_w += aux;

    aux = margins.top + margins.bottom 
      + curp.local.padding.top + curp.local.padding.bottom;
    vl.cmin_h += aux;
    vl.cmax_h += aux;
  } 
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

struct UFlowLayoutImpl : public UViewLayoutImpl {
  UFlowCell *cell;
  UFlowLine *line;
  int l, c;
  int wlimit, line_maxw;
  UFlowView* flowview;

  UFlowLayoutImpl(UFlowView *v);
  void addLine(UContext *curp);
  void addCell(UContext *curp, ULink* _link, 
	       u_dim _w, u_dim _h, int _offset, int _len);
};


UFlowLayoutImpl::UFlowLayoutImpl(UFlowView *v) : UViewLayoutImpl(v) {
  flowview = v;
  flowview->lastline_strcell = -1; 
  wlimit = line_maxw = 0;
  c = -1; 
  l = -1;
  addLine(null); 
  // l vaut maintenant 0 et l[0] est initialise
  //!! faudra rajouter au addLine a la fin
}

void UFlowLayoutImpl::addLine(UContext *curp) {
  // NB: pas forcement null : peut avoir ete alloue lors d'un precedent 
  // appel de Layout()
  if (!flowview->lines) {
    flowview->alloc_line_count = LINE_QUANTUM;
    flowview->lines = (UFlowLine*) malloc(sizeof(UFlowLine)
					  * flowview->alloc_line_count);
  }
  else if (l+1 >= flowview->alloc_line_count) {
    flowview->alloc_line_count += LINE_QUANTUM;
    flowview->lines = (UFlowLine*) realloc(flowview->lines, sizeof(UFlowLine)
					   * (flowview->alloc_line_count));
  }
  line = flowview->lines;

  // (sauf pour init)
  if (l >= 0) {
    // calculer la MAX taille de la ligne precedente a chaque chgt de ligne
    if (line[l].w > line_maxw) line_maxw = line[l].w;
    // add height of the last line (and add interline)
    //obs: flowview->favoriteHeight += curp->local.vspacing + line[l].h;
    flowview->chheight += curp->local.vspacing + line[l].h;
  }

  l++;
  line[l].empty = true;
  line[l].w = 0;
  line[l].h = 0;
  line[l].hflexChildCount = 0;
}

/* ==================================================== ======== ======= */

void UFlowLayoutImpl::addCell(UContext *curp, ULink* _link, 
			      u_dim _w, u_dim _h, int _offset, int _len) {
  if (!flowview->cells) {
    flowview->alloc_cell_count = CELL_QUANTUM;
    flowview->cells = (UFlowCell*) malloc(sizeof(UFlowCell)
					  * flowview->alloc_cell_count);
  }
  else if (c+1 >= flowview->alloc_cell_count) {
    flowview->alloc_cell_count += CELL_QUANTUM;
    flowview->cells = (UFlowCell*) realloc(flowview->cells, sizeof(UFlowCell)
					   * (flowview->alloc_cell_count));
  }
  cell = flowview->cells;

  c++;
  cell[c].link = _link;
  cell[c].offset = _offset;
  cell[c].len = _len;
  cell[c].w = _w; 
  cell[c].h = _h;

  // cell points to current line
  cell[c].line = l;  

  // number of horizontally "flex"ible child objects
  if (curp->local.halign == UHalign::FLEX) line[l].hflexChildCount++;

  // line height is the max of all cell heights
  if (cell[c].h > line[l].h)  line[l].h = cell[c].h;

  // update line width
  line[l].w += cell[c].w;

  // add horizontal spacing to separe this cell from previous cell 
  if (line[l].empty) line[l].empty = false;
  else line[l].w += curp->local.hspacing;
}

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */

static void flowDoLayout(UFlowLayoutImpl &vd, UGroup *grp, UContext &curp, 
			 UMultiList &mlist);

bool UFlowView::doLayout(UContext &parp, UViewLayout &vl) {
  UFlowLayoutImpl vd(this);
  UBox *box = getBox();
  UContext curp(box, this, parp);
  UMultiList mlist(curp, box, true);  //rescale

  // Border and Box size
  UMargins margins(0, 0);

  if (curp.local.border) {                     // !! A COMPLETER !!
    curp.local.border->getSize(curp, margins);
  }

  // value >=0 means: "fixed size hint" / should be >= 0 in this case
  if (vl.strategy == UViewLayout::IMPOSE_WIDTH) {
    //imposer la taille donnee par parent;
    curp.local.width = width = vl.spec_w;
  }

  // le pbm est qu'un flow n'a pas de taille intrinseque. on prend
  // donc une base de MIN_WIDTH_HINT mais en pratique il faudra
  // rendre le flow 'boxIsHFlex' pour qu'il s'adapte toujours
  // a la taille de son parent

  vd.wlimit = (width > 0) ? width : MIN_WIDTH_HINT;

  vd.wlimit -= margins.left + margins.right
    + curp.local.padding.left + curp.local.padding.right;
  if (vd.wlimit < 0) vd.wlimit = 0; // securite 

  //calculer la MAX taille des la ligne : init a 0
  vd.line_maxw = 0;

  // IMPORTANT:
  // Height depend de Width pour les UFlowView
  // ceci impose de refaire une seconde fois le layout du parent
  // (sauf dans le cas ou Width est fixe a priori auquel cas Height
  // (peut directement etre determine des la premier passe)
  
  if (curp.boxIsHFlex) vd.mustLayoutAgain = true;  // ?? necessaire ??

  chwidth = vd.wlimit;
  chheight = 0;

  flowDoLayout(vd, box, curp, mlist);

  // se termine par newline: rajouter une cell

  if (vd.line[vd.l].empty && vd.c >= 0 
      && vd.cell[vd.c].link
      && vd.cell[vd.c].link->getChild()->strCast()
      ) {

    UStr*s = vd.cell[vd.c].link->getChild()->strCast();
    int len = s ? s->length() : 0;
    vd.addCell(&curp, vd.cell[vd.c].link, 
	       2, // width: assez pour afficher le caret 
	       vd.cell[vd.c].h,  // height: comme preced
	       len, 0);
    // noter l'existence de cette cell pour affichage du caret
    // sur derniere line vide
    lastline_strcell = vd.c; 
  }

  // +1 car commence a -1
  cell_count = vd.c + 1;

  // il en faut un de plus pour calculer favoriteHeight/Width
  vd.addLine(&curp);
  // enlever le dernier qui ne sert qu'aux calculs
  line_count = vd.l + 1 - 1;

  // !! BORDER A GENERALISER ICI !!

  vd.children_w = vd.line_maxw;
  vd.computeWidth(curp, margins, vl);

  vd.children_h = chheight;    // chheight deja initialise
  vd.computeHeight(curp, margins, vl);

  // vl.cmin_w = vl.cmax_w = width;  deplace dans computeWidth
  // vl.cmin_h = vl.cmax_h = height; deplace dans computeHeight

  return vd.mustLayoutAgain;  // true if must lay out again
}

/* ==================================================== ======== ======= */
//!! curp pas parp!

static void flowDoLayout(UFlowLayoutImpl &vd, UGroup *grp, UContext &curp, 
			 UMultiList &mlist) {

  // if this group is not null (which generally is the case) the object
  // it contains are added to children for normal display
  // (can for instance be used for adding list-item markers, checkboxes...

  if (curp.local.content) {
    UGroup* content = curp.local.content;     // pas de curp, meme vd
    curp.local.content = null;	// avoid infinite recursion
    UMultiList mlist2(curp, content, true);  //rescale
    flowDoLayout(vd, content, curp, mlist2);
  }

  bool no_str_found = true;

  // process Elem and Box children (Windows are ignored)
  for (ULink *ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {

      UBrick *b = ch->getChild();
      UView *chboxview = null;
      UElem *it = null;
      UViewLayout chvl;      // !att: reinit par constr.
      UGroup *chgrp = null;  // !att reinit!
      
      if (b->propCast())  
	b->propCast()->putProp(&curp, grp);

      else if ((chgrp = b->groupCast())
	       && chgrp->isDef(0,UMode::GROUP)
	       ) {
	if (chgrp->isShowable()) {
	  UContext chcurp(chgrp, vd.view, curp);    // own curp, same vd
	  UMultiList chmlist(chcurp, chgrp, true);  //rescale
	  flowDoLayout(vd, chgrp, chcurp, chmlist);
	}
      }
      
      // UElems + UBoxes, UWins
      else if ((it = b->elemCast())
	       ||
	       (chgrp
		&& chgrp->isShowable()
		&& chgrp->isDef(0, UMode::BOX)
		&& (chboxview = ((UBoxLink*)ch)->getViewInside(vd.view)))
	       ) {

	UStr *str = (it ? it->strCast() : null);
	if (str) {
	  int offset = 0;
	  do {
	    u_dim subw, subh;
	    int sublen = 0;
	    int change_line = 0;

	    str->getSize(&curp, &subw, &subh, 
			 vd.wlimit - vd.line[vd.l].w, // taille max disponible
			 offset, &sublen, &change_line);

            // substr contient NL ne tient pas: passer a la ligne suivante
            // (sauf si la ligne courante est vide, ce qui signifie que
            // substr est de tt facon trop grande et sera donc clippee)

	    // ajouter cette cellule a la ligne si non vide
	    // (sauf si c'est la premiere pour cas pas encore init)
	    if (sublen > 0 || no_str_found) {
	      no_str_found = false;
	      vd.addCell(&curp, ch, subw, subh, offset, sublen);
	      offset += sublen;
	    }

            if (change_line >= 2       // contient \n
                || (change_line > 0 && vd.line[vd.l].w > 0)) {
              vd.addLine(&curp);
            }            
            
	    // sortir qunad tous les chars de la str ont ete pris en compte
	  } while (offset < str->length());
	} // endif(str)
	
	
	// cas des enfants autre que UStr : sous-cas a)
	// -a- cas des floating
	
	else if (chgrp && chgrp->isDef(0, UMode::FLOATING)) {
	  vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);
	}
	
	// cas des enfants autre que UStr: sous-cas b)
	// -b- tout le reste excepte les floating
	
	else {
	  u_dim ww=0, hh=0;

	  if (it) it->getSize(&curp, &ww, &hh);
	  else {
	    chboxview->doLayout(curp, chvl);
	    ww = chboxview->getWidth();
	    hh = chboxview->getHeight();

	    // pour les UFlowView, ils doivent prendre toute la place disponible 
	    // pour le parent, donc passage a la ligne avant si lines_maxw 
	    // et taille = maxwidth !
	    
	    if (chboxview->getViewStyle() == &UFlowView::style) {
	      // fait passer a la ligne *AVANT* un UFlow imbrique
              if (vd.line[vd.l].w >0) vd.addLine(&curp);
              
	      // chboxview->w  modifie !!
	      chboxview->setWidth(vd.wlimit);
              
              // pour que UView::computeWidth() fonctionne correctement
              chvl.strategy = UViewLayout::NESTED;
	    }
	
	    // recommencer
	    chboxview->doLayout(curp, chvl);

            if (chboxview->getViewStyle() == &UFlowView::style) {
              ww = chboxview->getWidth();
            }
	    hh = chboxview->getHeight();  // a include dans accolade?
	  } // end else(it)

	  // passe a la ligne si pas assez de place 
	  // SAUF si la ligne est vide (auquel ca ca depassera: tant pis !)
	  if (vd.c >= 0
              && vd.line[vd.l].w + vd.cell[vd.c].w > vd.wlimit
	      && vd.line[vd.l].w > 0) {
	    vd.addLine(&curp);
          }
          
	  vd.addCell(&curp, ch, ww, hh, 0, 0);
	  
	  // fait passer a la ligne *APRES* un UFlow imbrique
          if (chboxview && chboxview->getViewStyle() == &UFlowView::style) {
	    vd.addLine(&curp);
          }
	}
      }
    } // endfor ( ; ch...)
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */

struct UFlowUpdateImpl : public UViewUpdateImpl {
  UFlowLine *line;
  UFlowCell *cell;
  int l, c;
  int line_y;
  bool newline;
  UFlowView* flowview;

  UFlowUpdateImpl(UFlowView *v, const URegion &r, UViewUpdate &vup, 
		  UFlowLine *_lines, UFlowCell *_cells)
    : UViewUpdateImpl(v, r, vup) {
    flowview = v;
    line = _lines;
    cell = _cells;
    l = c = 0;
    line_y = 0; 
    newline = true;
  }
};

/* ==================================================== ======== ======= */
//NB: mode SearchElem: juste recuperer l'elem et sa position sans redessiner
//!ATT il faut IMPERATIVEMENT elem_props != null dans le mode SearchElem !
//NB: clip est passe en valeur, pas r

static void flowDoUpdate(UFlowUpdateImpl&, UContext &curp, 
			 UGroup *grp, UMultiList &mlist, 
			 UWinGraph &g, const URegion &r, URegion &clip, 
			 UViewUpdate &vup);

void UFlowView::doUpdate(UContext &parp, URegion r, URegion clip, 
			 UViewUpdate &vup) {
  UBox *box = getBox();

  // test pas valable pour les FLOATING car leurs coords dependent de curp
  // et sont donc changees apres creation et parsing de ce dernier

  if (!box->isDef(0, UMode::FLOATING)) {
    // toujours initialiser les coords meme si objet cache par autre chose,
    // (voir note dans UView::doUpdate)
    this->set(r);

    // elem is not visible because of scrolling, etc... 
    // l'intersection de clip et de r est affectee dans clip
    if (clip.setInter(r) == 0) return;
  }

  // ex: faux: il faut poursuivre le calcul meme quand le contenu est vide
  // afin de pouvoir tenir compte des margins et borders
  // if (!lines || !cells || line_count <= 0 || cell_count <=0) 
  //  return;

  {
    UFlowUpdateImpl vd(this, r, vup, lines, cells);
    UContext curp(box, this, parp);
    UMultiList mlist(curp, box, true);  //rescale
    //fait aussi:
    //a) if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);
    //b) bool is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);

    if (box->isDef(0, UMode::FLOATING)) {
      vd.setFloating(curp, box, r);
      if (clip.setInter(r) == 0) return;

      // !! voir uuview.cc !!

      if (vup.damaged_level == 0 && vup.after_damaged) {
	switch (vup.mode) {
	case UViewUpdate::PAINT_DAMAGED:
	  vd.can_paint = true;
	  vup.above_damaged_count++;
	  break;

	case UViewUpdate::UPDATE_DATA:
	  vup.above_damaged_count++;
	  break;

	default:
	  // rien a faire dans les autres cas
	  break;
	}
      }
    }

    UWinGraph &g = curp.winview->wg();
    bool g_end = false;
    vd.edit = curp.local.edit; //  !NEW

    // !att: setClip peut provoquer un seg fault si appele avec des donnees
    // non initialisee (c'est le cas pour les operations LOCATE sans PAINT)
    // MAIS (correct:15May03: g doit etre init. pour les INCRUST dans
    // tous les cas d'affichage meme si can_paint = false afin que le
    // contenu ne soit pas decale lors de l'affichage des children

    if (vup.mode < UViewUpdate::UPDATE_DATA 
	&& box->isCmode(UMode::INCRUST)){
      g.beginSubwin(clip, r.x, r.y);
      g_end = true;      // NB: ne pas oublier de faire g.end()
    }
    else if (vd.can_paint) {
      if (box->isDef(0, UMode::DOUBLE_BUFFER)){
	g.beginDoublebuf(clip);
	g_end = true;      // NB: ne pas oublier de faire g.end()
      } 
      else g.setClip(clip);
    }
    
    //vd.chclip.set(clip);
    vd.chclip = clip;

    vd.updateBackground(g, curp, r, clip);

    // initializes vd.x, vd.y, vd.width, vd.height
    vd.setMargins(g, curp, r, true);

    // !! A COMPLETER !!!!!!!!!!!!!!!!

    //vd.line_y = r.y + vd.margin.top; // !!!
    vd.line_y = vd.y;
    
    // clipping limits (NB: les bords sont exclus !)
    vd.chclip.set(vd.x, vd.y, vd.width, vd.height);
    //ex: nb bugge on avait oublie 1 marge pour h, w
    //vd.chclip.set(r.x + vd.margin.left, r.y + vd.margin.top,
    //		  r.width - vd.margin.right, r.height - vd.margin.bottom);

    // pas la peine de chercher a afficher les enfants
    // s'ils sont hors zone de clip
    if (vd.chclip.setInter(clip) != 0) {
      flowDoUpdate(vd, curp, box, mlist, g, r, clip, vup);
    }

    if (g_end) g.end();   // ne pas oublier!!

  } //NB: finalisation par destructeur de UFlowUpdateImpl
}

/* ==================================================== ======== ======= */

static void flowDoUpdate(UFlowUpdateImpl &vd, UContext &curp, 
			 UGroup *grp, UMultiList &mlist, UWinGraph &g, 
			 const URegion &r, URegion &clip, UViewUpdate &vup) {
  vd.hflex_space = 0;
  vd.vflex_space = 0;

  // if this group is not null (which generally is the case) the object
  // it contains are added to children for normal display
  // (can for instance be used for adding list-item markers, checkboxes...
  
  if (curp.local.content) {
    UGroup* content = curp.local.content;     // same curp, same vd
    curp.local.content = null;	// avoid infinite recursion
    UMultiList mlist2(curp, content, true); // rescale
    flowDoUpdate(vd, curp, content, mlist2, g, r, clip, vup);
  }

  for (ULink* ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {

      UBrick *b = ch->getChild();
      UView *chboxview = null;
      UElem *it = null; 
      UGroup *chgrp = null; //!att reinit!

      if (b->propCast())  
	b->propCast()->putProp(&curp, grp);

      //else if ((chgrp = dynamic_cast<UGroup*>(b))
      else if ((chgrp = b->groupCast())
		 && chgrp->isDef(0, UMode::GROUP)
	       ) {
	if (chgrp->isShowable()) {
	  UContext chcurp(chgrp, vd.view, curp);    // own curp, same vd
	  UMultiList chmlist(chcurp, chgrp, true);  //rescale
	  flowDoUpdate(vd, chcurp, chgrp, chmlist, g, r, clip, vup);
	}
      }

      // UElems + UBoxes, UWins
      else if ((it = b->elemCast())
	       ||
	       (chgrp
		&& chgrp->isShowable()
		&& chgrp->isDef(0, UMode::BOX)
		&& (chboxview = ((UBoxLink*)ch)->getViewInside(vd.view)))
	       ) {

	// 1::cas des Floating
	if (chgrp && chgrp->isDef(0, UMode::FLOATING)) {
	  URegion fl_chr; //chr for floatings
	  chboxview->getSize(fl_chr.width, fl_chr.height);
	  //!att: on rajoute la MARGE: les coords sont locales 
	  // % a l'INTERIEUR du CADRE et non % a l'origine de la Box.
	  fl_chr.x = r.x + vd.margins.left;
	  fl_chr.y = r.y + vd.margins.top;
	  // coords relatives rajoutees ensuite dans doUpdate
	  chboxview->doUpdate(curp, fl_chr, vd.chclip, vup);
	}

	// 2::tous les autres objets
	
	else {

	  if (vd.c >= vd.flowview->cell_count
	      // ce lien n'a pas de cell car il est vide
	      || vd.cell[vd.c].link != ch)
	    continue;

	  while (vd.c < vd.flowview->cell_count) {
	  
	    if (vd.newline) {
	      vd.newline = false;

	      //HALIGN
	      vd.hflex_space = 0;
	      
	      // there are flexible objects => use all space
	      /**** fait chier cette merde: tout en LEFT
		    if (vd.pline->hflexChildCount > 0)  {
		    vd.chr.x = r.x + vd.margin.left;
		    vd.hflex_space = 
		    (r.width - vd.pline->chw - vd.margin.left -vd.margin.right)
		    / vd.pline->hflexChildCount;
		    vd.pline->chw = r.width - vd.margin.left - vd.margin.right;
		    }
		    else 
	      ****/
	      switch (curp.local.halign) {
	      case UHalign::LEFT:
		vd.chr.x = r.x + vd.margins.left;
		break;
		
	      case UHalign::CENTER:
		vd.chr.x = (r.width - vd.line[vd.l].w) / 2;
		// box smaller than child ==> impose left margin
		if (vd.chr.x < vd.margins.left)  vd.chr.x = vd.margins.left;
		vd.chr.x += r.x;
		break;
		
	      case UHalign::RIGHT: 
		vd.chr.x = r.width - vd.line[vd.l].w - vd.margins.right;
		// box smaller than child ==> impose left margin
		if (vd.chr.x < vd.margins.left)  vd.chr.x = vd.margins.left;
		vd.chr.x += r.x;
		break;

	      default:
		// cas d'erreur divers et aussi les HFLEX que l'on a avire
		vd.chr.x = r.x + vd.margins.left;
		break;
	      }
	      
	    } // endif(newline)

	    
	    // VALIGN
	    /*
	      switch (curp.local.valign) {
	      case V_BOTTOM:
	      case V_CENTER:
	      case V_TOP:
	      case V_FLEX:
	    */

	    // !NOTE: pour les Elems FLEX == CENTER
	    // Cas BOX et FLEX
	    if (!it && curp.local.valign == UValign::FLEX) {
	      // !!!elc25jun: A VOIR: different de uuview !!!
	      // adapter sur max de tous les enfants
	      vd.chr.height = vd.line[vd.l].h;
	      //vd.chr.y = r.y + vd.margin.top; 
	      vd.chr.y = vd.line_y;
	    }
	    else {
	      vd.chr.height = vd.cell[vd.c].h;
	      //vd.chr.y = r.y + vd.margin.top; 
	      vd.chr.y = vd.line_y;
	    }
	    
	    // flexible horizontal object  ==>  add flexible width space
	    if (curp.local.halign == UHalign::FLEX)
	      vd.chr.width = vd.cell[vd.c].w + vd.hflex_space;
	    else vd.chr.width = vd.cell[vd.c].w;
	    
	    if (vd.chr.width > 0 && vd.chr.height > 0) {
	    
	      //pas un elem => c'est forcement un Box
	      if (!it) chboxview->doUpdate(curp, vd.chr, vd.chclip, vup);
	      else {
		//NB: ELEM_OPS => vd.can_paint == false mais pas l'inverse !
		if (vd.can_paint) {
		  if (vd.chr.y + vd.chr.height > vd.chclip.y
		      && vd.chr.y < vd.chclip.y + vd.chclip.height) {
		    
		    g.setClip(vd.chclip);
		    UStr *str = (it ? it->strCast() : null);
		    
		    if (!str) it->paint(g, &curp, vd.chr);
		    else {
		      str->paint(g, &curp, vd.chr, 
				 vd.cell[vd.c].offset ,vd.cell[vd.c].len);
		    
		      //pbm subtil: 2 cas differents
		      //-1- newline (explicite par \n ou implicite par taille)
		      //    au milieu d'une UStr --> test pos_in_string <strict
		      //    sinon le caret s'affiche 2 fois (debut+fin de ligne)
		      //-2- newline implicite juste a la fin physique de la UStr
		      //    --> test >= sinon le caret va disparaitre
		      
		      int strpos = 0;
		      UFlowCell& cell = vd.cell[vd.c];
		      if (vd.edit 
			  && vd.edit->getCaretStr(strpos) == (const UStr*)str
			  && strpos >= cell.offset
		       
			  && (strpos < cell.offset + cell.len
			      || (vd.flowview->lastline_strcell > 0 
				  && vd.flowview->lastline_strcell == vd.c)
			      || (strpos == cell.offset + cell.len
				  // en fin de str
				  && strpos == str->length()
				  // et str nulle/vide ou pas terminee par \n
				  && (str->length() < 1
				      || str->chars()[str->length()-1] != '\n')
				  )
			      )
			  ) {
			// nb: danger: ne pas ecraser le curseur en reaffichant
			// l'elem suivant par dessus
			vd.edit->paint(g, &curp, vd.chr, cell.offset, cell.len);
		      }
		    }
		  }
		}
		
		else if (vup.mode >= UViewUpdate::LOCATE_ELEM_POS) {
		  // do not draw, just find Elem
		  if (vup.mode == UViewUpdate::LOCATE_ELEM_POS) {
		    if (vd.flowview->locateElemPos(curp,ch, &vd.cell[vd.c],
						   g,vd.chr,vup))
		      return;
		  }
		  else if (vup.mode == UViewUpdate::LOCATE_ELEM_PTR) {
		    if (vd.flowview->locateElemPtr(curp,ch, &vd.cell[vd.c],
						   g,vd.chr,vup))
		      return;
		  }
		}
	      }
	      
	      // increment vd.chr.x in all cases
	      vd.chr.x += vd.chr.width + curp.local.hspacing;
	      
	    } // endif (vd.chr.width > 0 && vd.chr.height > 0)


	    // next cell
	    vd.c++;

	    // fin de liste
	    if (vd.c >= vd.flowview->cell_count) break;
	    
	    // on a change de ligne
	    if (vd.cell[vd.c].line > vd.cell[vd.c-1].line) {
	      vd.newline = true;
	      vd.line_y += vd.line[vd.l].h + curp.local.vspacing;
	      vd.l++;
	    }

	    // on est passe a l'elem suivant dans la liste
	    if (vd.cell[vd.c].link != ch) break;

	  } // end while (vd.c < vd.flowview->cell_count) 
	}	  
      } // endif
    } // endfor

  // call callbacks (desormais appeles en fin de traitement)
  if (vd.can_paint 
      && grp->isDef(UMode::VIEW_PAINT_CB|UMode::VIEW_CHANGE_CB,0)) 
    vd.callbacks(grp, curp.winview);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// retrieves elem and info from x,y position
//!!ATT: 
// - suppose que elem_props!= null !
// - return==true signifie: ne pas chercher davantage car:
//                trouve' OU pas trouve' mais plus la peine de chercher
// - return==false signifie: continuer a chercher car:
//                pas trouve' mais on peut encore trouver 
//

bool UFlowView::locateElemPos(UContext &props, 
			      ULink *link, UFlowCell *cell,
			      UWinGraph &g, 
			      const URegion &r, UViewUpdate &vup) {
  if (r.y > vup.e->getYwin()) return true;  // plus rien a chercher (not found)
  UElem *elem;
  UStr *str;

  if (vup.e->getYwin() >= r.y && vup.e->getYwin() <= r.y + r.height
      && ((elem = link->getChild()->elemCast()))
      ) {

    if (r.x <= vup.e->getXwin()) {
 
      int strpos = -1;

      if ((str = elem->strCast())
	  && link == cell->link // petite verif
	  && str->chars()
	  ) {
	strpos = cell->offset          	// search the strpos
	  + g.getCharPos(props.fontdesc, 
			 str->chars() + cell->offset, cell->len,
			 vup.e->getXwin() - r.x);
      }
      
      if (vup.e->getXwin() <= r.x + r.width) { 
	//exact match: elem exactly found -> stop searching
	vup.elem_props->set(props, elem, link, r, strpos, true);
	return true;
      }
      else { // elem approximatively found -> continue seraching
	vup.elem_props->set(props, elem, link, r, strpos, false);
      }
    }
  }
  return false;	// continuer a chercher (plusieurs cas)
}


bool UFlowView::locateElemPtr(UContext &props, 
			      ULink *link, UFlowCell *cell,
			      UWinGraph &g, 
			      const URegion &r, UViewUpdate &vup) {
  UElem *elem;
  if ((vup.elem_props->elemLink == link || vup.elem_props->elem == link->getChild())
       && ((elem = link->getChild()->elemCast()))
       ) {

    if (!elem->strCast()) {
      // not an UStr: positions don't matter
      vup.elem_props->set(props, elem, link, r, vup.elem_props->strpos, true);
      return true;
    }
    else {
      // inutile de continuer a chercher
      if (cell->offset > vup.elem_props->strpos2) return true;

      if (cell->offset + cell->len >= vup.elem_props->strpos) {
	vup.elem_props->merge(props, elem, link, r, true);
      }
      // pas de return true: continuer a chercher et a ajouter les regions:
      // il peut y avoir plusieurs cells concernes et on renverra la region globale
    }
  }

  //tous les cas pas trouve (PAS de else!)
  return false;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
