/* ==================================================== ======== ======= *
 *
 *  uflow.hpp
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uflow_hpp_
#define	_uflow_hpp_
//pragma ident	"@(#)uflow.hpp	ubit:03.05.00"
#include <ubit/uappli.hpp>
#include <ubit/uevent.hpp>


/** Event Flow [Ubit Internals].
 * Note: The default Event Flow is the standard X window event flow.
 * Its flow ID is 0.
 */
class UFlow {
public:
  UFlow(int flow_id, class UAppli&, class UDisp&);
  virtual ~UFlow();

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  int getID() const  {return id;}
  class UDisp&  getDisp()  const {return disp;}
  class UAppli& getAppli() const {return disp.getAppli();}

  class UGroup* getBrowsingGroup() const {return browsing_group;}
  void setBrowsingGroup (UGroup* grp) {browsing_group = grp;}
  ///< [impl] gets/sets current browse group.

  class UMenuCtrl& getMenuCtrl() const {return menuCtrl;}
  ///< [impl] returns the Menu Controller.

  class UTextsel& getTextsel() const {return textsel;}
  ///< [impl] returns the text selection of the application.

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  void setCursor(class UEvent&, const class UCursor*);

  void winMousePress(UWin *win, UEvent&);
  void winMouseRelease(UWin *win, UEvent&);
  void winMouseMove(UWin *win, UEvent&);
  void winKeyPress(UWin *win, UEvent&);
  void winKeyRelease(UWin *win, UEvent&);
  void winLeave(UWin *win, UEvent&);
  void winDestroy(UWin *win, UEvent&);

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  class UBox* findBox(const UEvent& e, u_modes, UView*& found_view);
  void boxEnter(UEvent&, UBox*, int bstyle);
  void boxLeave(UEvent&);
  void boxMousePress(UEvent&);
  void boxMouseRelease(UEvent&);
  void boxMouseMove(UEvent&);
  void boxKeyPress(UEvent&);
  void boxKeyRelease(UEvent&);

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  void deleteNotify(class UView* deleted_view);
  void deleteNotify(class UGroup* deleted_group);
  ///< [impl] notifies the application(s) that a view/object has been deleted

  class UWin* retrieveRemPointer(class UDisp*);
  void showRemPointers(class UEvent&, int mode = 0);

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

private:
  friend class UAppli;
  friend class UCtrl;

  UAppli& appli;
  UDisp& disp;
  const int id;

  // last entered, pressed, armed, browsed object in the Display
  UEvent lastEnteredEvent, lastPressedEvent;
  UCtrl *lastPressed, *lastArmed, *dragSource, *dropTarget;
  uptr<UCtrl> inAction;
  UView *lastEnteredView;
  UBox  *lastEnteredBox;

  u_count mclickCount;
  u_time  mclickTime;
  u_pos   mclickX, mclickY;

  // cursor being currently shown
  const class UCursor* lastCursor;

  // current browsing group (for Menus, Lists, Choices...)
  // (null if no browsing group currently activated)
  UGroup* browsing_group;
  //uptr<UGroup> browse_group;

  // controls the menus and menubars of the application
  class UMenuCtrl& menuCtrl;

  // controls the text selection of the application
  class UTextsel& textsel;

  std::vector<class UWin*> rempointers;
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
