/* ==================================================== ======== ======= *
 *
 *  uubrowser.cpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uubrowser.cpp	ubit:03.06.03"
#include <string.h>
#include <stdio.h>
#include <iostream>
#include <unistd.h>
#include <ubit/ubit.hpp>
#include <ubit/udir.hpp>
#include <ubit/ext/ubrowser.hpp>
#include <ubit/ext/ufinder.hpp>
#include <ubit/ext/udoc.hpp>
using namespace std;

// moins large que UPix::doc
static const char *doc_xpm[] = {
  "13 16 4 1",
  "       c None s None",
  ".      c black",
  "X      c white",
  "o      c #808080",
  "             ",
  " .......     ",
  " .XXXXX..    ",
  " .XoooX.X.   ",
  " .XXXXX....  ",
  " .XooooXoo.o ",
  " .XXXXXXXX.o ",
  " .XooooooX.o ",
  " .XXXXXXXX.o ",
  " .XooooooX.o ",
  " .XXXXXXXX.o ",
  " .XooooooX.o ",
  " .XXXXXXXX.o ",
  " ..........o ",
  "  oooooooooo ",
  "             "
};
static UPix doc_pix(doc_xpm, UMode::UCONST);

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UBrowser::Options::Options() :
  show_icon_previews(true),

  background(UColor::white),
  fgcolor(UColor::black),

controls_info_width(100),
controls_info_height(150),
main_panel_width(725),
main_panel_height(545),
doc_width(720),
doc_height(540),

  icon_width(70),
  iconbox_hspacing(4),     //5
  iconbox_vspacing(4),       //5
  icon_content_width(56),  //60
  icon_content_height(56), //60

  preview_content_width(90),
  preview_content_height(90),

  clone_frame_width(600),
  clone_frame_height(450){
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UBrowser::~UBrowser() {
  delete link_callbacks;
  // final destroy of objects being deleted
  //kill_ring = null; tto late fout le bordel a virer de tt facon
}

UBrowser::UBrowser(const UStr& _pathname) : 
  mode(NoMode),
  open_in_fullwin(false),  // 11 sept: etait oublie!
  //finder_spane(true, false),
  //doc_spane(new UScrollpane(true, false)),
  doc_spane(new UScrollpane(true, true)),  // 25sep
  ctrls(new BrwControls(this)),
  fullwin(new BrwFullWin(this)),
  alertbox(new UAlertbox()),
  link_callbacks(new BrwLinkCallbacks(this)),
  selected_iconbox(null),
  selected_fullwin(null)
  //selected_ima(null)
{
  opts.preview_content_width.setAutoUpdate(false);
  opts.preview_content_height.setAutoUpdate(false);
    
  //===========================================
  // open file box and menu
  
  open_box.add(ucallref(this, open_box, 
 			(int(UBrowser::*)(UFilebox&))&UBrowser::open));

  open_menu.addlist
    (
     uvspacing(0) + uhmargin(0) + UBorder::none + UBgcolor::none
     + ugroup(UFont::bold + UFont::large + UColor::orange 
	       + "Open File or Folder")
     + ubox(UBgcolor::white + ualpha(0.75) + open_box)
     );

  //===========================================
  // navigator & document

  finder.addAttr(uvflex());
  finder.addAttr(uhflex());
  finder.addAttr(title_location);
  
  doc_spane->addlist(UBgcolor::white + docbox);
  doc_panel.addlist(uvflex() + doc_spane);
  
  //===========================================

  alertbox->show(false);

  ask_dialog.addlist
    (
     uhcenter() + uvflex()
     + uvmargin(20) + uhmargin(15) + uvspacing(20)
     + UFont::bold + UFont::large
     + uhbox(UColor::orange + "Remote Request")
     + uhbox(UColor::navy + ask_dialog_msg)
     + uhcenter()
     + uhbox(ubutton(UPix::check + "  OK " + ucloseWin(1))
             + ubutton(UPix::cross + " Cancel " + ucloseWin(0))
             )
     );
  // doit toujours rester une hardwin, meme en mode -group et
  // etre afficher sur le display initial (= celui du maitre)
  ask_dialog.setSoftwinMode(false);

  //===========================================

  main_panel.addAttr(uvflex());
  main_panel.addAttr(uvflex());
  main_panel.addAttr(opts.main_panel_width);
  main_panel.addAttr(opts.main_panel_height);
  main_panel.addAttr(opts.background);

  addlist
    (
     UOrient::vertical + uvflex() + uhflex()
     + uhbox( uvflex()
	      + uleft()  + ctrls
              + uhflex() + upane(main_panel + alertbox + ask_dialog)
	      )
     + fullwin
     );
  
  open(_pathname);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

BrwControls::~BrwControls() {
}

BrwControls::BrwControls(UBrowser* _brw) :
  brw(*_brw),
big_custom_controls(uvbox(UBgcolor::orange)),
  small_custom_controls(uvbox()),
  preview(_brw->opts.preview_content_width,
	  _brw->opts.preview_content_height)
          //brw.opts.background + brw.opts.fgcolor)
{
  // HISTORY
  history_list.addAttr(UBgcolor::white);
  UBox& history_box = uscrollpane(true, false, history_list);

  //===========================================
  // HOSTS
  UStr& host_str = ustr();
  UMenu& new_host_menu = umenu
    (
     UOrient::horizontal
     + "Host Name: "
     + utextfield(uwidth(150) + host_str
                  + ucallref(&brw, host_str, &UBrowser::addHostCB)
                  + ucloseWin())
     + ubutton(" Add "
               + ucallref(&brw, host_str, &UBrowser::addHostCB)
               + ucloseWin())
     );

  UBox& host_box = uscrollpane(true, false,  host_list);

  host_list.addAttr(UBgcolor::white);
  host_list.addAttr(uhmargin(4));
  host_list.addlist    // att aux insert!
    (
     uitem(UFont::bold + "new host "
           + uright() + ugroup(uscale(-1) + USymbol::down)
           + new_host_menu)
     );

  //===========================================

  UBox& info_box = uvbox
    (
     brw.opts.controls_info_height 
     + ubar(UFont::small + UFont::bold  + UBorder::none
            + UBgcolor::none + UColor::inherit
            + UOn::select   / ugroup(UPix::windows + " Hosts ")
            + UOn::select   / ushow(&history_box, false)
            + UOn::select   / ushow(&host_box, true)
            + UOn::unselect / ugroup(UPix::folder + " History ")
            + UOn::unselect / ushow(&history_box, true)
            + UOn::unselect / ushow(&host_box, false)
            + uvbox(UMode::ignoreEvents + uscale(-2) + USymbol::up + USymbol::down)
            )
     + uvflex()
     + history_box
     + host_box
     );
  host_box.show(false);
    
  //===========================================

  // un click ouvre la fullwin
  preview.add(UOn::action / ucall(&brw, &UBrowser::showFullWin));

  UBox& preview_panel = uvbox
    (
     uhflex() + uvflex() + uvmargin(2) + preview
     );
  preview_panel.show(false);
  
  //===========================================
  //===========================================

  UBox& big_navig_box = uhbox
    (
     uhflex() + uhspacing(0)
     + uitem(uhcenter() + UIcon::up
             + ucall(&brw, &UBrowser::openParent))
     + uitem(uhcenter() + UIcon::left
             + ucall(&brw, &UBrowser::previousEntry))
     + uitem(uhcenter() + UIcon::right
             + ucall(&brw, &UBrowser::nextEntry))
     );

  file_list.addAttr(uhflex());
  file_list.addAttr(uvflex());
  // fout la merde
  //file_list.addAttr(uflagdef(UTitlebox::BottomTitle));

  //===========================================
  //===========================================

  UBox& left_panel = uvbox
    (
     brw.opts.controls_info_width
     + utop()
     + info_box
     + big_navig_box
     + *big_custom_controls
     + uvflex()
     + uvbox(uhflex() + uvflex()
             + brw.opts.background + brw.opts.fgcolor
             + file_list
             + preview_panel
             )
     );
      
  //===========================================
  
  show_controls_btn.addlist
    (
     uhcenter()
     + UMode::canSelect + UMode::selected
     + UOn::select   / UBgcolor::none
     + UOn::select   / UPix::leftarrow
     + UOn::select   / ushow(&small_navig_box, false)
     + UOn::select   / ushow(&left_panel, true)
     + UOn::unselect / UPix::rightarrow
     + UOn::unselect / ushow(&left_panel, false)
     + UOn::unselect   / ushow(&small_navig_box, true)
     );

  small_navig_box.addlist
    (
     uhmargin(0) + uvspacing(2)
     + uitem(uhcenter() + USymbol::up + ucall(&brw, &UBrowser::openParent))
     + uitem(uhcenter() + USymbol::left + ucall(&brw, &UBrowser::previousEntry))
     + uitem(uhcenter() + USymbol::right + ucall(&brw, &UBrowser::nextEntry))
     );
  small_navig_box.show(false);
  
  UBox& control_bar = ubar
    (
     UOrient::vertical + uhflex()
     + UBorder::none + uhmargin(0) + uwidth(13)
     + utop()
     + show_controls_btn
     + uitem(uhcenter() + doc_pix + brw.getOpenMenu())
    
     + uvflex()
     + uvbox(uhmargin(0) + uvflex()
             + small_navig_box_valign
             + small_navig_box
             + *small_custom_controls
             )
     
     + ubottom()

     + uitem(uhcenter() + UPix::bomb
             + ucall(&brw, UUpdate::paint, &UBrowser::update))
     
     + ubox(UBgcolor::none + uhcenter() + USymbol::square
            + UOn::select / ucall(this, 1, &BrwControls::changeLayout)
            + UOn::unselect / ucall(this, 0, &BrwControls::changeLayout)
            )
     + show_controls_btn

     );

  //===========================================

  addlist
    (
     uvflex()
     + uhflex() + left_panel
     + uright() + control_bar
     );	
}

void UBrowser::showControlPanel(bool state) {
  ctrls->show_controls_btn.select(state);
}

UBox& UBrowser::getBigCustomControls() {
  return *ctrls->big_custom_controls;
}

UBox& UBrowser::getSmallCustomControls() {
  return *ctrls->small_custom_controls;
}

/* ==================================================== ======== ======= */

void BrwControls::showSelectedIcon() {
  UIconbox* ibox = brw.getSelectedIconbox();
  if (ibox) {
    UIcon* icon = ibox->getSelectedIcon();
    if (icon) {
      vector<UView*> icon_views;
      icon->getViews(icon_views);
      bool move_x = false, move_y = false;
      
      for (unsigned int k = 0; k < icon_views.size(); k++) {
        UView* itemv = icon_views[k];
        UView* listv = ibox->list().getViewContaining(itemv);
        UView* panev = ibox->getSpane()->getViewContaining(itemv);

        if (listv && panev
            && listv->getHeight() > 0 && listv->getWidth() > 0  // ICI isShown() serait utile!!!
            && panev->getHeight() > 0 && panev->getWidth() > 0
            ) {
          u_pos pane_x, pane_y;
          UView::convertPos(panev, pane_x, pane_y, itemv, 0, 0);

          if (pane_x + itemv->getWidth() > panev->getWidth()) move_x = true;
          else if (pane_x < 0) move_x = true;

          if (pane_y + itemv->getHeight() > panev->getHeight()) move_y= true;
          else if (pane_y < 0) move_y= true;

          if (move_x || move_y) {
            u_pos list_x, list_y;
            UView::convertPos(listv, list_x, list_y, itemv, 0, 0);

            if (move_x) {
              float xscroll = (float)list_x / listv->getWidth() * 100;
              ibox->getSpane()->setXScroll(xscroll);
            }
            if (move_y) {
              float yscroll = (float)list_y / listv->getHeight() * 100;
              //cerr << " -- k: " << k  << " " << icon_views[k]<< " yscroll : "<< yscroll<< endl;
              //cerr << "    paneh " << panev->getHeight() << " listh " <<  listv->getHeight() << endl;
              ibox->getSpane()->setYScroll(yscroll);
            }
          }
        }
      }
    }
  }
}

void BrwControls::showDoc() {
  UIconbox* ibox = brw.getSelectedIconbox();
  if (ibox) {
    ibox->showTitleName(false);
    //ibox->showZoomButtons(false);
    ibox->showIconContents(true);
    ibox->showDirIcons(false);
    file_list.add(ibox, false);
  }
  file_list.show(true);
  showSelectedIcon();
}

void BrwControls::showDir() {
  file_list.removeAll(true, false); 
  UIconbox* ibox = brw.getSelectedIconbox();
  if (ibox) {
    ibox->showTitleName(true);
    //ibox->showZoomButtons(true);
    ibox->showIconContents(true);
    ibox->showDirIcons(true);
  }
  file_list.show(false);
}

void BrwControls::changeLayout(int l) {
  UIconbox* ibox = brw.getSelectedIconbox();
  if (ibox) {
    if (l==1) {
      brw.title_location.set(UIconbox::BottomTitle);
      //ibox->moveTitleToBottom();
      small_navig_box_valign.set(ubottom());
    }
    else {
      brw.title_location.set(null);
      //ibox->moveTitleToTop();
      small_navig_box_valign.set(utop());
    }
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// HOSTS

UItem& UBrowser::addHost(UStr* hostname) {
  
  UItem& item = uitem( UPix::rball + hostname );
  item.add( ucall(this, &item, hostname, &UBrowser::createClone) );

  ctrls->host_list.add(item);
  return item;
}

void UBrowser::addHostCB(const UStr& s) {
  UStr& hostname = ustr(s);           // s duplique !
  
  UItem& item = uitem( UPix::rball + hostname); 
  item.add( ucall(this, &item, &hostname, &UBrowser::createClone) );

  ctrls->host_list.insert(1, item);
}

void UBrowser::addHosts(const vector<UStr*>& hostnames) {
  for (unsigned int k = 0; k < hostnames.size(); k++)
    addHost(hostnames[k]);
}

void UBrowser::addHosts(char const* hostnames[]) {
  for (unsigned int k = 0; hostnames[k] != null; k++)
    addHost(&ustr(hostnames[k]));
}

void UBrowser::createCloneRequest(const UStr& arg) {
  ask_dialog_msg = "Open Clone on " & arg & " ?";
  int resp = ask_dialog.lock(UAppli::getApp());
  if (resp) createClone(arg);
}

bool UBrowser::createClone(const UStr& _hostname) {
  UStr* hostname = new UStr(_hostname);
  return createClone(&addHost(hostname), hostname);
}

bool UBrowser::createClone(UItem* item, UStr* hostname) {
  if (!hostname || hostname->empty()) return false;

  UDisp* disp = UAppli::openDisp(*hostname);
  if (!disp) {
    showAlert("can't open display: " & *hostname);
    return false;
  }
  else {
    item->select(true); // !!

    UWin* win = createCloneFrame("Clone");
    win->add(UOn::close / ucall(this, win, item, &UBrowser::deleteClone));

    disp->add(win);
    win->show(true);
    return true;
  }
}

void UBrowser::deleteClone(UWin* win, UItem* item) {
  //ctrls->host_list.remove(item);
  item->select(false); // !!
  win->show(false);
  delete win;
  // faudrait aussi fermer le display!
}

UFrame* UBrowser::createCloneFrame(const UStr& title) {
  return
  new UFrame(utitle(title)
             + opts.clone_frame_width + opts.clone_frame_height
             + this);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

int UBrowser::open(UFilebox& openbox) {
  return open(openbox.getPath());
}

int UBrowser::open(const UStr& pathname) {
  UStr path = pathname;
  return open(path);
}

int UBrowser::open(UStr& pathname) {
  if (pathname.empty()) return false;
  bool is_regular_file, is_directory;

  if (pathname.charAt(0) == '~'
      && (pathname.charAt(1) == '/' || pathname.charAt(1) == 0)) {
    //NB: ne PAS faire de free() sur un getenv!
    char *home = getenv("HOME");
    if (home) pathname.replace(0, 1, home); // virer ~mais pas /
  }

  // cas xxxx/. virer le . (mais pas /..)
  if (pathname.length() > 1
      && pathname.charAt(pathname.length()-1) == '.'
      && pathname.charAt(pathname.length()-2) == '/'
      ) {
    pathname.remove(-1, 1);  // remove last char
  }

  if (!pathname.getFileType(is_regular_file, is_directory)) {
    showAlert("file not found: " & pathname);
    return false;
  }
  
  if (is_regular_file) {
    return openDoc(pathname);
  }
  else if (is_directory) {
    return openDir(pathname, true);  // true = reload
  }
  else {
    showAlert("invalid file: " & pathname);
    return false;
  }
}

void UBrowser::openParent() {
  UStr name;
  if (selected_iconbox) name = selected_iconbox->getPath();
  else name = ".";

  if (mode == DocMode) {
    //showDir(name); ne genere pas les bonnes Actions
    openDir(name, false);
  }
  else {
    name &= "/..";
    openDir(name, true); // true = reload
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void BrwLinkCallbacks::notify(UEvent& e, UStr* path, UDoc* doc) {
  if (!path || path->empty()) return;

  if (e.getCond() == &UOn::enter)
    brw.actionNotify(UBrowser::LinkEnter, *path, doc);
  else if (e.getCond() == &UOn::leave)
    brw.actionNotify(UBrowser::LinkLeave, *path, doc);
  else if (e.getCond() == &UOn::mpress)
    brw.actionNotify(UBrowser::LinkPress, *path, doc);
  else if (e.getCond() == &UOn::mrelease)
    brw.actionNotify(UBrowser::LinkRelease, *path, doc);
  else if (e.getCond() == &UOn::action) {
    brw.actionNotify(UBrowser::LinkAction, *path, doc);
    //cerr << "link: (" << *path<< ")" << endl; 
    if (path) brw.open(*path);
  }
}

void UBrowser::showAlert(const UStr& msg) {
  alertbox->show(msg);
}

void UBrowser::showAlert(bool state) {
  alertbox->show(state);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UBrowser::processMessage(UEvent& e) {
  UStr msg;
  bool stat = e.getMessage(msg);

  if (!stat || msg.empty()) return;

  UStr arg;
  for (int k = 0; k < msg.length(); k++) {
    if (msg.charAt(k) == ':') {
      arg = msg.split(k, true);
      break;
    }
  }
  //cerr << "processMessage: '" << msg << "'" << " arg: " << arg <<endl;

  if (msg == "file") {
    if (arg.empty()) getOpenMenu()->open();
    else {
      cerr << arg.getFileDir() << endl;
      open(arg.getFileDir());
      open(arg);
      if (selected_iconbox)
        selected_iconbox->selectIcon(arg.getFileName());
    }
  }
  else if (msg == "next")
    nextEntry();
  else if (msg == "previous")
    previousEntry();
  else if (msg == "open")
    openEntry();
  else if (msg == "parent")
    openParent();
  else if (msg == "clone") {                        // DANGER!!
    //cerr << "Warning: Attempt to create clone on " << arg << endl;
    createCloneRequest(arg);
  }
  else if (msg == "zoom") {
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

static int getLine(char* buffer, int buffer_size, FILE* fd) {
  char* res = fgets(buffer, buffer_size, fd);
  if (!res) return 0;

  // enlever les \n \t et spaces a la fin
  int ll = strlen(buffer)-1;
  if (ll <= 0) {*buffer = 0; return -1;}

  while (buffer[ll] == '\n' || buffer[ll] == '\t' || buffer[ll] == ' ') {
    buffer[ll] = 0;
    ll--;
  }
  if (ll <= 0) {*buffer = 0; return -1;}
  return 1;  // OK
}

/* ==================================================== ======== ======= */

bool UBrowser::readBookmarks(const char* filename, bool from_home_dir) {
  UStr path;

  if (from_home_dir) {
    const char* homedir = ::getenv("HOME"); // pas de free!
    if (!homedir) return false;
    path = homedir;
    path.append("/");
  }
  
  path.append(filename);
  if (path.empty()) return false;
  
  FILE* fd = fopen(path.chars(), "r");
  if (!fd)  return false;

  char buffer[1000];
  while (getLine(buffer, sizeof(buffer), fd)) {
    if (buffer[0]) ctrls->history_list.add(new BrwDir(this, buffer));
  }
  
  fclose(fd);
  return true;
}

/* ==================================================== ======== ======= */

bool UBrowser::writeBookmarks(const char* filename, bool from_home_dir) {
  UStr path;

  if (from_home_dir) {
    const char* homedir = getenv("HOME"); // pas de free!
    if (!homedir) return false;
    path = homedir;
    path.append("/");
  }
  
  path.append(filename);
  if (path.empty()) return false;
  
  FILE* fd = fopen(path.chars(), "w");
  if (!fd) return false;

  UBrick** chlist = ctrls->history_list.getChildren();
  if (chlist) {
    for (UBrick** pchild = chlist; *pchild; pchild++) {
      BrwDir* de = dynamic_cast<BrwDir*>(*pchild);
      if (de) {
        fputs(de->fpath.chars(), fd);
        fputs("\n", fd);
      }
    }
    delete[] chlist;
  }
  
  fclose(fd);
  return true;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
