/* ==================================================== ======== ======= *
 *
 *  ufinder.hpp (part of ubrowser)
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _ufinder_hpp_
#define _ufinder_hpp_
//pragma ident	"@(#)ufinder.hpp	ubit:03.05.06"
#include <ubit/uwin.hpp>
#include <ubit/ext/uicon.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class BrwLinkCallbacks : public UDoc::Callbacks {
  UBrowser& brw;
public:
  BrwLinkCallbacks(UBrowser* _brw) : brw(*_brw) {}
  void notify(UEvent& e, UStr* path, UDoc* doc);
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class BrwControls : public UHbox {
public:
  BrwControls(class UBrowser*);
  ~BrwControls();
  
  void showDir();
  void showDoc();
  void showSelectedIcon();
  void changeLayout(int);

private:
  friend class UBrowser;
  UBrowser& brw;
  UVbox     history_list, host_list, file_list, small_navig_box;
  uptr<UVbox> big_custom_controls, small_custom_controls;
  UItem     show_controls_btn;
  UIcon     preview;
  UValign   small_navig_box_valign;
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class BrwDir : public UItem {
  friend class UBrowser;
  UFont    font;
  UStr     fpath, fname;
  uptr<UIconbox> iconbox;
  UPopmenu popmenu;
  bool keep_open;

public:
  BrwDir(class UBrowser*, const UStr& dirname);
  ~BrwDir();

  const UStr& getDir() const;
  class UIconbox* getIconbox() const;

  void setDir(const UStr& dirname);
  void setIconbox(class UIconbox*);

  void emph(bool state);
  void setKeepOpen(bool st) {keep_open = st;}
  bool isKeepOpen() {return keep_open;}
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class BrwFullWin : public UFrame {
  friend class UBrowser;
  UBrowser&    brw;
  enum WinSize {SmallWinSize, MediumWinSize, LargeWinSize, FullWinSize}
  winsize;
  bool         resizing;
  UWidth       width;
  UHeight      height;
  UIcon        content;

public:    
  BrwFullWin(UBrowser*);
  ~BrwFullWin();
  
  void setSize(WinSize);
  void rescale();
  void resized(UEvent&);
  void keyPressed(UEvent&);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
