#include <iostream>
#include <ubit/ubit.hpp>
using namespace std;


class Demo : public UFrame {
public:
	Demo(const UArgs& a = UArgs::none);

private:
	UListbox listbox;
	UBox box;
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

int main(int argc, char* argv[]) {
  // create the application context.
  UAppli appli(argc, argv);

  // create the main frame, add it to the appli and show it
  Demo frame;
  appli.add(frame);
  frame.show();

  // start the event loop
  return appli.mainLoop();
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void foo(const char* s) {
  cerr << "foo: " << s << endl;
}

Demo::Demo(const UArgs& a) : UFrame(a) {

  listbox.addlist
  (
   UOn::action / ucall("action", foo)
   + UOn::select / ucall("select", foo)
   + UOn::unselect / ucall("unselect", foo)

   +  uitem(UPix::folder + "aaaa"
            + UOn::select   / ucall("aaa on", foo)
            + UOn::unselect / ucall("aaa off", foo)
            + UOn::action   / ucall("aaa action", foo)
            )
   + uitem("bbbb" + UPix::zoom + uflatbutton(" b2 ") + UPix::ray
           + UOn::select   / ucall("bbb on", foo)
           + UOn::unselect / ucall("bbb off", foo)
           + UOn::action   / ucall("bbb action", foo)
           )
   + uitem("cccc" + ulinkbutton(USymbol::right + USymbol::right + USymbol::right)
           + UOn::select   / ucall("ccc on",foo)
           + UOn::unselect / ucall("ccc off",foo)
           + UOn::action   / ucall("ccc action", foo)
           )
   + uitem("dddd"
           + UOn::select   / ucall("ddd on",foo)
           + UOn::unselect / ucall("ddd off",foo)
           + UOn::action   / ucall("ddd action", foo)
           )
   + ubutton("eeee"
             + UOn::select   / ucall("eee on",foo)
             + UOn::unselect / ucall("eee off",foo)
             + UOn::action   / ucall("eee action", foo)
             )
   + ucheckbox("ffff"
               + UOn::select   / ucall("fff on",foo)
               + UOn::unselect / ucall("fff off",foo)
               + UOn::action   / ucall("fff action", foo)
               )
   + ulinkbutton("gggg"
                 + UOn::select   / ucall("ggg on",foo)
                 + UOn::unselect / ucall("ggg off",foo)
                 + UOn::action   / ucall("ggg action", foo)
                 )
     );

  URadioSelect& sel = uradioSelect();
  box.addlist
    (
     UBorder::etchedIn
     + UOrient::horizontal + uhflex() + uhflex()

     + uvbox( uitem("xxxx" + sel
                    + UOn::select   / ucall("xxx on", foo)
                    + UOn::unselect / ucall("xxx off", foo)
                    )
              + uitem("yyyy" + sel
                      + UOn::select   / ucall("yyy on", foo)
                      + UOn::unselect / ucall("yyy off", foo)
                      )
              + utextfield("tttt ttt tt" + sel
                           + UOn::select   / ucall("ttt on", foo)
                           + UOn::unselect / ucall("ttt off", foo)
                           )
              )
     + ubutton("zzzz" + sel
               + UOn::select   / ucall("zzz on",foo)
               + UOn::unselect / ucall("zzz off",foo)
               )
     );

  addlist(uhmargin(10) + uvmargin(10)
          + uhbox(listbox + " " + box)
          + uvbox(UBgcolor::white + UBorder::etchedOut
                  + " List boxes can contain any widget "
                  + " List items can contain any brick "
                  )
          );
}
