#include <iostream>
#include <ubit/ubit.hpp>
using namespace std;

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

class Demo : public UFrame {
public:
  Demo(const UArgs& a = UArgs::none);

private:
  UStr str;               // string entered in the text field
  UStr text;              // text body in the text area
  UScrollpane scrollpane;

  void enter();		        // callback function
};

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

int main(int argc, char* argv[]) {
  UAppli appli(&argc, argv);

  Demo frame(uwidth(300) + uheight(300));
  appli.add(frame);
  frame.show(true);

  return appli.mainLoop();
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

Demo::Demo(const UArgs& a) : UFrame(a) {
	
  UBox& toolbar = ubar
    (
     uleft()    + ulabel( UFont::bold + " Enter: " )
     + uhflex() + utextfield( str + ucall(this, &Demo::enter) )
     + uright() + ubutton( UFont::bold + "  Ok  " + ucall(this, &Demo::enter) )
     );

  UFlowbox& textarea = uflowbox
  (
   UBgcolor::white + UColor::navy
   + uedit()           // makes the text editable
   + text
   );

  scrollpane.addlist(textarea);

  UBox& statusbar = uhbox(" Ready");
		
  addlist
  (
   utop()      + toolbar
   + uvflex()  + scrollpane
   + ubottom() + statusbar
   );
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

void Demo::enter() {
  text.append(str);
  text.append("\n");
		str = null;
		scrollpane.setYScroll(99.);
}

