#include <stdio.h>
#include <X11/Intrinsic.h>
#include <ubit/ubit.hpp>
#include <ubit/ugraph.hpp>
//#include <unatdisp.hh>

void foo(UEvent& e, const char *s) {
  printf("action %s - so: %s / x %d y %d - xwin %d ywin %d\n",
	 s, 
	 e.getSource() ? e.getSource()->cname() : "none", 
	 e.getX(), e.getY(), e.getXwin(), e.getYwin());
}

void openpop1(UEvent&e, UMenu *pop, int btn_id) {
  if (e.getButtons() == btn_id) {
    u_dim ww = 0, hh = 0;
    UUpdate upd(UUpdate::LAYOUT);
    upd.layoutIfNotShown();  // updates layout even if hidden
    pop->update(upd);
    pop->getSize(ww,hh);
    pop->move(e, -ww/2, -hh/2);
    pop->open();  //use open(), not show()!
  }
}

void openpop2(UEvent&e, UBox *parent) {
  static UMenu *popm = null;
  if (popm) {delete popm; popm = null;}
  printf("create new menu\n");
  popm = &upopmenu(ubutton("top") + ubutton("bottom"));
  //this mode must be set before adding this obj to its parent
  popm->setSoftwinMode(true);
  parent->add(popm);
  
  u_dim ww, hh;
  UUpdate upd(UUpdate::LAYOUT);
  upd.layoutIfNotShown();  // updates layout even if hidden
  popm->update(upd);
  popm->getSize(ww,hh);
  popm->move(e, -ww/2, -hh/2);
  popm->open();  //use open(), not show()!
}

static UButton *btn = null;

void addobj(UEvent&e, UBox *parent) {
  if (!btn) {
    btn = &ubutton("new button");
    parent->add(btn);
    parent->update();
  }
}

void remobj(UEvent&e, UBox *parent) {
  if (btn) {
    parent->remove(btn, true);
    parent->update();
  }
  btn = null;
}

void show(UEvent *e, UBox *parent, UBox *obj, bool stat) {
  obj->show(stat);
  //parent->update();
}

//=========================================================================

int main(int argc, char *argv[]) {

  UAppli appli(&argc, argv);

  // TrueColor is necessary because we use alpha blending
  // 24 is the requested depth (but actual depth may be smaller)
  appli.setTrueColors(/*depth hint*/24);

  // where the appli must search images (if no absolute path is provided)
  appli.setImaPath("../../images");

  /*
  int win_w = 400, win_h = 150;
  XSetWindowAttributes wattr;
  wattr.colormap = cmap;
  wattr.background_pixel = wattr.border_pixel = BlackPixelOfScreen(XtScreen(toplevel));
  Window xwin = XCreateWindow(XtDisplay(toplevel), XtWindow(toplevel), 
			      // offsets of this win from toplevel origin
			      // (set by function GuiCreateWidgets)
			      0, 0, 
			      win_w, win_h, 0,
			      8, //16
			      (unsigned int)InputOutput, 
			      0, //g->glvisual->visual,
			      CWBackPixel|CWBorderPixel, &wattr); 
  */

  UMenu &popm = upopmenu(ubutton("aaaaaaa") + ubutton("bbbbbbb"));

  UBox &incrust = uincrust();
  //UBox &incrust = ubox();
  incrust.addlist
    (
     uhflex() + uvflex() + UOrient::horizontal + uwidth(700)
     + UBorder::etchedIn
     + uvbox( uhflex() + utop()
	      + UColor::blue
	      + ucheckbox("Press here to see event ...xxxxxxxx..."
			  + UOn::mpress / ucall("press", foo))
	      + ucheckbox("Press here to see event"
			  + UOn::mpress / ucall("press", foo))
	      + uvflex()
	      + ulinkbutton(UBgcolor::wheat
		      + UFlowView::style
		      + "press mouse to open menu"
		      + UOn::mpress / ucall(&incrust, openpop2)
		      )
	      )
     + ubutton(uima("frisco.gif")
	       + UOn::mpress / ucall("press",foo)
	       + UOn::viewResize / ucall("resize",foo)
	       )
     + "press mouse to open menu"
     + popm   //note that 'popm' must have a parent!
     + UOn::mpress / ucall(&popm, (int)UEvent::MButton1, openpop1)
     + UOn::viewResize / ucall("resize",foo)
     );

  //UBox &mesg = utextbox(uedit() + " bla bla");
  UBox &mesg = ulabel(UBgcolor::white + uedit() + " bla bla" 
		      + UOn::viewResize / ucall("resize",foo));
  UHspacing hsp(1);

  UBox &panel = uhbox();
   panel.addlist
     (
      hsp
      + ucheckbox(" Show text "  + UMode::selected 
		+ upix("xfig.xpm")
		//+ UOn::change / ucall(foo, "change") 
		+ UOn::select / ushow(&mesg, true) 
		+ UOn::unselect / ushow(&mesg, false) 
		)
      + mesg
      + uvbox(uvflex()
	      + ubutton("spacing=1"
		      + UOn::action / ucall(&hsp, 1, &UHspacing::set))
	      + ubutton("spacing=10"
			+ UOn::action / uset(&hsp, 10))
	      )
      + ubutton(USymbol::right + " Add "
		+ UOn::action / ucall(&panel, addobj)
		+ UOn::viewResize / ucall("resize",foo)
		)
      + ubutton(" Remove " + USymbol::left
		+ UOn::action / ucall(&panel,remobj)
		+ UOn::viewResize / ucall("resize",foo)
		)
      );

  UFrame *frame = &uframe
    (
     uhflex() + uvflex()
     + UOn::viewResize / ucall("resize", foo)
     + umenubar( UOn::viewResize / ucall("resize", foo)
		+ ubutton("aaaa" 
			+ umenu(ubutton("xxxx") + ubutton("xxxx"))
			)
		+ ubutton("bbb bb"
			  + umenu(ubutton("zzzz") + ubutton("ttt"))
			  )
		+ ubutton("open dialog"
			  + udialog("My Dialog"
				    + utextbox(uedit() + "")
				    + ubutton("OK")
				    )
			  )
		)
     + incrust
     + ubutton("      ")
     + panel
     );

  appli.add(frame);
  frame->show();

  printf("depth = %d \n", appli.getDepth());

  return appli.mainLoop();
}

