/*
 * HypBrowser: part of Ubit demos
 * Franck Shen - Cedric Timsit. 2003
 */
#ifndef HNODE_HPP
#define HNODE_HPP
#include "hcomplex.hpp"
#include "hbrowser.hpp"


struct HNode {
  HComplex v;
  HComplex o;
  class NodeInfo* info;
  HNode* bro;
  HNode* child;

  HNode(class NodeInfo* = NULL);

  // ! recursive deletion of the tree
  virtual ~HNode();

  void addBro(HNode* br);
  void setChildren(HNode* ch);
  void setInfo(class NodeInfo*);

  // counts child nodes
  unsigned long getNodeCount() const;
  void recenterTree(double r);
  void transTree(HComplex& s, HComplex& d);

private:
  void countNodes(unsigned long&) const;
  void transNode_cc();
  void transNode_cl();
  void transNode_lc();
  void transNode_ll();
};


struct HTree {
  friend class HNode;
  HComplex _C1, _C2;
  double _R1, _R2, R1, R2;
  //void computeCenters(HComplex& s, HComplex& d);
public:
  HTree();
};

#endif
