#ifndef HCOMPLEX_HPP
#define HCOMPLEX_HPP

#define H_PI 3.14159265358979323846

enum HComplexType {COORDPOL,COORDCART,COORDHYP};

struct HComplex{
  int type;
  double x, y;

  HComplex(int type = COORDPOL);
  //HComplex(double x, double y);
  HComplex(int type, double x, double y);
  //HComplex(int type, const HComplex&);
  //HComplex(const HComplex&);

  void set(double x, double y);
  void set(int type, double x, double y);
  //void set(int type, const HComplex&);
};


/*
struct HPoint : public HComplex {
  HPoint() : HComplex() {}
  HPoint(double a, double b) : HComplex(a,b) {}
};


struct HAffix: public HComplex{
  HAffix() : HComplex() {}
  HAffix(double r, double t) : HComplex(r,t) {}
  double& r() {return x;}
  double& t() {return y;}
};


struct HCoord: public HComplex{
  HCoord() : HComplex() {}
  HCoord(double r, double d) : HComplex(r,d) {}
  double& r() {return x;}
  double& d() {return y;}
};
*/

void HypToCart(HComplex& h, HComplex& m);
void AffixToCart(HComplex& z, HComplex& m); // coord polaire en coord cartesien
void CartToAffix(HComplex& m, HComplex& z); // marche tres tres mal

void AddComplex(HComplex& res, HComplex& a, HComplex& b);
void AddComplexReal(HComplex& res, HComplex& c, double r);
void MulComplexReal(HComplex& res, HComplex& c, double r);
void InvSignComplex(HComplex& res, HComplex& c);
void ConjugateComplex(HComplex& res, HComplex& c);
void MulComplex(HComplex& res, HComplex& c1, HComplex& c2);
void InvComplex(HComplex& res, HComplex& c);

double ComplexNorm(HComplex& c);
double ComplexNorm2(HComplex& c);

double InnerProdComplex(HComplex& a, HComplex& b);
void AddToModule(HComplex& s, double rplus);

#endif
