#include <iostream>
#include <ubit/ubit.hpp>
#include <ubit/ext/ubrowser.hpp>
#include <ubit/ext/uctlmenu.hpp>
using namespace std;

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

int main(int argc, char* argv[]) {
  // create the application context.
  UAppli appli(argc, argv);

  // create the main panel
  UBrowser br;

  // create the main frame window, add it to the appli and show it
  UFrame frame(uwidth(600) + uheight(450)
               + br
               // processes messages sent by other applis such as 'ums/remote'
               + UOn::umessage / ucall(&br, &UBrowser::processMessage)
               );
  appli.add(frame);
  frame.show();
  
  // open clones on alternate display
  for (int k = 1; k < argc; k++) {
    UDisp* disp = appli.openDisp(argv[k]);

    if (disp) {
      UStr t = ustr("Browser on ") & argv[k];
      UFrame& frame2 = uframe(uwidth(600) + uheight(450) + utitle(t) + br );
      disp->add(frame2);
      frame2.show();
    }
  }

#ifdef HAVE_LIBXERCESC
  UDoc::Reader* html_reader = new UHtmlDoc::Reader();
  UDoc::addReader("html", html_reader);
  UDoc::addReader("htm",  html_reader);
  UDoc::addReader("xhtml",html_reader);
#endif

  // start the event loop
  return appli.mainLoop();
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/*
struct ZoomAction : public UCtlmenu::Action {
  static const int SCALE_QUANTUM = 10;
  Edi* mainbox;
  int scale_base, scale_incr;

  ZoomAction(Edi* _mainbox) {mainbox = _mainbox;}

  virtual void select(UEvent&, UCtlmenu&) {
    scale_base = mainbox->spinbox.value().getValue();
    scale_incr = 0;
  }

  virtual void mdrag(UEvent& e, UCtlmenu& c) {
    int new_scale = (e.getXwin() - c.getXselect()) / SCALE_QUANTUM;
    if (new_scale != scale_incr 
	&& scale_base + new_scale < 10
	&& scale_base + new_scale > -10
	) {
      scale_incr = new_scale;
      mainbox->spinbox.setValue(scale_base + scale_incr);
      mainbox->update();
    }
  }
};


struct ScrollAction : public UCtlmenu::Action {
  static const int SCROLL_QUANTUM = 3;
  Edi* mainbox;
  float scroll_base, scroll_incr;

  ScrollAction(Edi* _mainbox) {mainbox = _mainbox;}

  virtual void select(UEvent&, UCtlmenu&) {
    scroll_base = mainbox->scrollpane.getYScroll();
    scroll_incr = 0;
  }

  virtual void mdrag(UEvent& e, UCtlmenu& c) {
    int new_scroll = (e.getYwin() - c.getYselect()) / SCROLL_QUANTUM;
    if (new_scroll != scroll_incr 
	 && scroll_base + new_scroll < 100
	&& scroll_base + new_scroll > 0
	) {
      scroll_incr = new_scroll;
      mainbox->scrollpane.setYScroll(scroll_base + scroll_incr);
    }
  }
};

UCtlmenu* Edi::newCtlmenu() {
  UCtlmenu* cmenu = new UCtlmenu();

  ZoomAction* za = new ZoomAction(this);
  cmenu->setAction(0, uitem(UPix::right), *za);
  cmenu->setAction(4, uitem(UPix::left), *za);

  ScrollAction* sa = new ScrollAction(this);
  cmenu->setAction(2, uitem(UPix::up), *sa);
  cmenu->setAction(6, uitem(UPix::down), *sa);

  // Button3 opens the menu. last arg = true means that the menu is always
  // opened, even if the event is located inside a child of the opener 
  cmenu->autoOpens(*this, UEvent::MButton3, 0, true);

  return cmenu;
}
*/
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
