//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Robert Denda 1997
// 
// uProfiler.cc -- 
// 
// Author           : Robert Denda
// Created On       : Tue Jul 16 16:45:16 1996
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Oct  6 21:17:08 2005
// Update Count     : 676
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

#ifndef __U_PROFILER_H__
#define __U_PROFILER_H__

#include <uC++.h>


class uProfileAnalyze;					// forward declarations
class uSymbolTable;
class uCallGraphInfo;
class uProfileTaskSampler;
class uExecutionMonitor;
class uExecutionMonitorNode;
class uMemoryInfoEntry;


// The maximum number of metrics that are allowed to request memory allocation in the uC++ kernel
#define U_MAX_METRICS 8


//######################### uCreateMetricFunctions #########################


struct uCreateMetricFunctions : public uSeqable {
    char *className;
    void *createWidgetFunction;                         // address of function to create metric startup widget in Profiler startup window
    void *createMonitorFunction;

    uCreateMetricFunctions(char *name);
    ~uCreateMetricFunctions();
}; // uCreateMetricFunctions 


//######################### uProfileEvent #########################


class uProfileEvent : public uSeqable {
    friend _Task uProfiler;				// only profiler can access member routines
    friend class uProfileMonitorSet;
    
    uExecutionMonitorNode &monitor;
    uTime time;
  public:    
    uProfileEvent( uExecutionMonitorNode &monitor );
}; // uProfileEvent


//######################### uProfileMonitorSet #########################


class uProfileMonitorSet : private uSequence<uProfileEvent> {
  public:
    void OrderedInsert( uProfileEvent *np );
    uProfileEvent *Head();
    uProfileEvent *Succ( uProfileEvent *e );
    void Remove( uProfileEvent *e );
    void Reorder( uProfileEvent *np );
}; // uProfileMonitorSet


//######################### uProfiler ##########################


_Task uProfiler {
    friend class uMachContext;				// access: uProfilerInstance
    friend class uBaseCoroutine;			// access: uProfilerInstance
    friend class uCoroutineConstructor;			// access: uProfilerInstance
    friend class uCoroutineDestructor;			// access: uProfilerInstance
    friend class uCoroutineMain;			// access: uProfilerInstance
    friend class uBaseTask;				// access: uProfilerInstance
    friend class uTaskConstructor;			// access: uProfilerInstance
    friend class uTaskDestructor;			// access: uProfilerInstance
    friend class uTaskMain;				// access: uProfilerInstance
    friend class uSerial;				// access: uProfilerInstance
    friend class uSerialConstructor;			// access: uProfilerInstance
    friend class uSerialDestructor;			// access: uProfilerInstance    
    friend class uSerialMember;				// access: uProfilerInstance
    friend class uCluster;				// access: uProfilerInstance
    friend class uProcessor;				// access: uProfilerInstance
    friend _Task uProcessorTask;			// access: uProfilerInstance
    friend class uHeapManager;				// access: uProfilerInstance
    friend void *malloc( size_t size ) __THROW;		// access: uProfilerInstance
    friend void *memalign( size_t alignment, size_t size ) __THROW; // access: uProfilerInstance
    friend class uCondLock;                             // access: uProfilerInstance
    friend class uOwnerLock;                            // access: uProfilerInstance
    friend class uCondition;				// access: uProfilerInstance                    
    friend class uEventList;                            // access: uProfilerInstance

    // profiling

    friend class uProfilerBoot;
    friend class uSymbolTable;
    friend class uProfilerStartWidget;
    friend class uExecutionMonitor;
    friend class uMemoryExecutionMonitor;               // access: uGetMetricMemoryIndex()
    friend class uSPMonitor;				// activate uProfiler hooks in distributed monitoring mode
    friend class uCGMonitor;				// activate uProfiler hooks in distributed monitoring mode
    friend class uESMonitor;				// activate uProfiler hooks in distributed monitoring mode
    friend class uPOTMonitor;				// activate uProfiler hooks in distributed monitoring mode
    friend class uMemoryMonitor;			// activate uProfiler hooks in distributed monitoring mode
    friend class uHWMonitor;                            // activate uProfiler hooks in distributed monitoring mode
    friend class uHWFunctionMonitor;                    // activate uProfiler hooks in distributed monitoring mode
    friend class uProfileTaskSampler;			// access: addFuncCallInfo, memory allocation hooks
    friend class uProfileAnalyze;			// access: symbolTable, InfoList
    friend void __cyg_profile_func_enter( void *pcCurrentFunction, void *pcCallingFunction );
    friend void __cyg_profile_func_exit( void *pcCurrentFunction, void *pcCallingFunction );

    static uProfiler *uProfilerInstance;		// pointer to profiler

    uSequence<uCreateMetricFunctions> *metricList;      // list of metrics, used to create the profiler's startup window
    unsigned int numMetrics;
    int numMemoryMetrics;				// current index into the metric memory array

    uProfileMonitorSet monitorSet;			// list of poll events for samplers 
    uCluster           cluster;				// own cluster
    uProcessor         processor;			// own processor
    uSymbolTable      *symbolTable;			// symbol table of the executable
    uClock            &processorClock;			// clock used to get current time
    bool               finish;				// end of gathering data

    uCondition delay;					// TEMPORARY: don't even ask

    // communication 
    const uBaseTask	*taskToProcess;
    uBaseTask::State     taskState;
    const uBaseCoroutine *coroutineToProcess;
    const uBaseCoroutine *coroutineFromProcess;
    const uCluster	*clusterToCluster;
    const uProcessor	*processorToProcess;
    const uCluster	*cluster1;
    const uCluster	*cluster2;
    const uSerial	*serial;
    const char          *objectName;
    const uCondition	*condition;
    void		*currentFunction;
    void		*callingFunction;
    void		*firstArg;
    uTime               contextSwTime;			// used to reduced the number of calls to uGetTime(), which is expensive
    void                *memAddress;
    size_t              memSizeRequested, memSizeAllocated;
    
    // monitoring modules
    mutable uSequence<uExecutionMonitorNode> &MonitorList;
    mutable uSequence<uExecutionMonitorNode> &RegisterTaskDecentrList;        // list of monitors to be informed upon task registration
    mutable uSequence<uExecutionMonitorNode> &RegisterTaskMonitorList;        
    mutable uSequence<uExecutionMonitorNode> &DeregisterTaskDecentrList;      // list of monitors to be informed upon task deregistration
    mutable uSequence<uExecutionMonitorNode> &DeregisterTaskMonitorList;      
    mutable uSequence<uExecutionMonitorNode> &RegisterTaskStartExecutionDecentrList; // list of monitors to be infor. upon task registration
    mutable uSequence<uExecutionMonitorNode> &RegisterTaskStartExecutionMonitorList; 
    mutable uSequence<uExecutionMonitorNode> &RegisterTaskEndExecutionDecentrList;   // list of monitors to be infor. upon task registration
    mutable uSequence<uExecutionMonitorNode> &RegisterTaskEndExecutionMonitorList;   
    mutable uSequence<uExecutionMonitorNode> &RegisterClusterDecentrList;     // list of monitors to be informed upon cluster registr.
    mutable uSequence<uExecutionMonitorNode> &RegisterClusterMonitorList;     
    mutable uSequence<uExecutionMonitorNode> &DeregisterClusterDecentrList;   // list of monitors to be informed upon cluster dereg.
    mutable uSequence<uExecutionMonitorNode> &DeregisterClusterMonitorList;   
    mutable uSequence<uExecutionMonitorNode> &RegisterProcessorDecentrList;   // list of monitors to be informed upon processor registr.
    mutable uSequence<uExecutionMonitorNode> &RegisterProcessorMonitorList;   
    mutable uSequence<uExecutionMonitorNode> &DeregisterProcessorDecentrList; // list of monitors to be informed upon processor dereg.
    mutable uSequence<uExecutionMonitorNode> &DeregisterProcessorMonitorList; 
    mutable uSequence<uExecutionMonitorNode> &MigrateTaskDecentrList;         // list of monitors to be informed upon task migration
    mutable uSequence<uExecutionMonitorNode> &MigrateTaskMonitorList;         
    mutable uSequence<uExecutionMonitorNode> &MigrateProcessorDecentrList;    // list of monitors to be informed upon processor migration
    mutable uSequence<uExecutionMonitorNode> &MigrateProcessorMonitorList;    
    mutable uSequence<uExecutionMonitorNode> &RegisterFunctionEntryDecentrList;	// list of monitors to be informed upon routine entry
    mutable uSequence<uExecutionMonitorNode> &RegisterFunctionEntryMonitorList;	
    mutable uSequence<uExecutionMonitorNode> &RegisterFunctionExitDecentrList;  // list of monitors to be informed upon routine exit
    mutable uSequence<uExecutionMonitorNode> &RegisterFunctionExitMonitorList;  
    mutable uSequence<uExecutionMonitorNode> &RegisterMutexFunctionEntryTryDecentrList;	// list of monitors to be informed upon mutex routine entry petition
    mutable uSequence<uExecutionMonitorNode> &RegisterMutexFunctionEntryTryMonitorList;	
    mutable uSequence<uExecutionMonitorNode> &RegisterMutexFunctionEntryDoneDecentrList; // list of monitors to be informed upon mutex routine entry 
    mutable uSequence<uExecutionMonitorNode> &RegisterMutexFunctionEntryDoneMonitorList; 
    mutable uSequence<uExecutionMonitorNode> &RegisterMutexFunctionExitDecentrList; // list of monitors informed upon mutex routine exit
    mutable uSequence<uExecutionMonitorNode> &RegisterMutexFunctionExitMonitorList; 
    mutable uSequence<uExecutionMonitorNode> &RegisterMonitorDecentrList;     // list of monitors to be informed upon monitor creation
    mutable uSequence<uExecutionMonitorNode> &RegisterMonitorMonitorList;     
    mutable uSequence<uExecutionMonitorNode> &DeregisterMonitorDecentrList;   // list of monitors to be informed upon monitor creation    
    mutable uSequence<uExecutionMonitorNode> &DeregisterMonitorMonitorList;   
    mutable uSequence<uExecutionMonitorNode> &RegisterAcceptStartDecentrList; // list of monitors to be informed upon accept start
    mutable uSequence<uExecutionMonitorNode> &RegisterAcceptStartMonitorList; 
    mutable uSequence<uExecutionMonitorNode> &RegisterAcceptEndDecentrList;   // list of monitors to be informed upon accept end
    mutable uSequence<uExecutionMonitorNode> &RegisterAcceptEndMonitorList;   
    mutable uSequence<uExecutionMonitorNode> &RegisterWaitDecentrList;        // list of monitors to be informed upon wait on condition
    mutable uSequence<uExecutionMonitorNode> &RegisterWaitMonitorList;        
    mutable uSequence<uExecutionMonitorNode> &RegisterReadyDecentrList;       // list of monitors to be informed upon wake up after wait on condition
    mutable uSequence<uExecutionMonitorNode> &RegisterReadyMonitorList;       
    mutable uSequence<uExecutionMonitorNode> &RegisterSignalDecentrList;      // list of monitors to be informed upon signal on condition
    mutable uSequence<uExecutionMonitorNode> &RegisterSignalMonitorList;      
    mutable uSequence<uExecutionMonitorNode> &RegisterCoroutineDecentrList;   // list of monitors to be informed upon coroutine creation
    mutable uSequence<uExecutionMonitorNode> &RegisterCoroutineMonitorList;   
    mutable uSequence<uExecutionMonitorNode> &DeregisterCoroutineDecentrList; // list of monitors to be informed upon coroutine deletion
    mutable uSequence<uExecutionMonitorNode> &DeregisterCoroutineMonitorList; 
    mutable uSequence<uExecutionMonitorNode> &RegisterCoroutineBlockDecentrList;  // list of monitors to be informed on coroutine inactivate
    mutable uSequence<uExecutionMonitorNode> &RegisterCoroutineBlockMonitorList;  
    mutable uSequence<uExecutionMonitorNode> &RegisterCoroutineUnblockDecentrList; // list of monitors to be informed on coroutine activate
    mutable uSequence<uExecutionMonitorNode> &RegisterCoroutineUnblockMonitorList; 
    mutable uSequence<uExecutionMonitorNode> &RegisterTaskExecStateDecentrList; // list of monitors to be informed on change of task state
    mutable uSequence<uExecutionMonitorNode> &RegisterTaskExecStateMonitorList; 
    mutable uSequence<uExecutionMonitorNode> &RegisterSetNameDecentrList;       //  monitors to be inf. on task/coroutine change of name
    mutable uSequence<uExecutionMonitorNode> &RegisterSetNameMonitorList;       
    mutable uSequence<uExecutionMonitorNode> &RegisterMemoryAllocateDecentrList;
    mutable uSequence<uExecutionMonitorNode> &RegisterMemoryAllocateMonitorList;
    mutable uSequence<uExecutionMonitorNode> &RegisterMemoryDeallocateDecentrList;
    mutable uSequence<uExecutionMonitorNode> &RegisterMemoryDeallocateMonitorList;
    mutable uSequence<uExecutionMonitorNode> &PollDecentrList;                // list of monitors to be periodically polled
    mutable uSequence<uExecutionMonitorNode> &PollMonitorList;                
	 
    // built in monitoring modules 
    mutable uSequence<uExecutionMonitorNode> &BuiltInRegisterTaskBlockDecentrList; // list of monitors to be informed upon task block
    mutable uSequence<uExecutionMonitorNode> &BuiltInRegisterTaskUnblockDecentrList; // list of monitors to be informed upon task unblock
    mutable uSequence<uExecutionMonitorNode> &BuiltInRegisterFunctionEntryDecentrList;
    mutable uSequence<uExecutionMonitorNode> &BuiltInRegisterFunctionExitDecentrList;
    mutable uSequence<uExecutionMonitorNode> &BuiltInRegisterProcessorDecentrList;
    mutable uSequence<uExecutionMonitorNode> &BuiltInDeregisterProcessorDecentrList;
    mutable uSequence<uExecutionMonitorNode> &BuiltInRegisterTaskStartSpinDecentrList;
    mutable uSequence<uExecutionMonitorNode> &BuiltInRegisterTaskStopSpinDecentrList;

    // Statistical-profiling signal handlers
    static void uSigVirtualAlrmHandler( __U_SIGPARMS__ );
    static void uSigHWOverflowHandler( __U_SIGPARMS__ );

    void main();
    void CheckMetricList( void );			// make sure all required info for creating metrics is provided

    // functions for handling dynamic memory allocation in uC++ kernel
    int  uGetMetricMemoryIndex();                                       // get an index into the metric memory array
    void uPreallocateMetricMemory( void **, const uBaseTask & ) const;  // preallocate required metric memory for current task in provided array
    void uPostallocateMetricMemory( const uBaseTask & ) const;          // postallocate required metric memory for current task
    void uSetMetricMemoryPointers( void **, const uBaseTask & ) const;  // force profiler to use provided array for memory management
    void uResetMetricMemoryPointers( const uBaseTask & ) const;         // allow profiler to resume using its native array for memory management

    void AddToMonitorList( uExecutionMonitor *mon ) const;

    _Mutex void RegisterTaskMutex( const uBaseTask &task, const uSerial &serial, const uBaseTask &parent );
    _Mutex void DeregisterTaskMutex( const uBaseTask &task );
    _Mutex void RegisterTaskStartExecutionMutex( const uBaseTask &task );
    _Mutex void RegisterTaskEndExecutionMutex( const uBaseTask &task );
    _Mutex void MigrateTaskMutex( const uBaseTask &task, const uCluster &fromCluster, const uCluster &toCluster );
    _Mutex void RegisterClusterMutex( const uCluster &cluster );
    _Mutex void DeregisterClusterMutex( const uCluster &cluster );
    _Mutex void RegisterProcessorMutex( const uProcessor &processor );
    _Mutex void DeregisterProcessorMutex( const uProcessor &processor );
    _Mutex void MigrateProcessorMutex( const uProcessor &processor, const uCluster &fromCluster, const uCluster &toCluster );
    _Mutex void RegisterFunctionEntryMutex( uBaseTask *task, void *pcCallingFunction, void *pcCurrentFunction, void *pcFirstArg );
    _Mutex void RegisterFunctionExitMutex( uBaseTask *task, void *pcCallingFunction, void *pcCurrentFunction, void *pcFirstArg );
    _Mutex void RegisterMutexFunctionEntryTryMutex( const uSerial &serial, const uBaseTask &task );
    _Mutex void RegisterMutexFunctionEntryDoneMutex( const uSerial &serial, const uBaseTask &task );    
    _Mutex void RegisterMutexFunctionExitMutex( const uSerial &serial, const uBaseTask &task );
    _Mutex void RegisterMonitorMutex( const uSerial &serial, const char *name, const uBaseTask &task );
    _Mutex void DeregisterMonitorMutex( const uSerial &serial, const uBaseTask &task );    
    _Mutex void RegisterAcceptStartMutex( const uSerial &serial, const uBaseTask &task );
    _Mutex void RegisterAcceptEndMutex( const uSerial &serial, const uBaseTask &task );
    _Mutex void RegisterWaitMutex( const uCondition &condition, const uBaseTask &task, const uSerial &serial );
    _Mutex void RegisterReadyMutex( const uCondition &condition, const uBaseTask &task, const uSerial &serial );    
    _Mutex void RegisterSignalMutex( const uCondition &condition, const uBaseTask &task, const uSerial &serial );    
    _Mutex void RegisterCoroutineMutex( const uBaseCoroutine &coroutine, const uSerial &serial );
    _Mutex void DeregisterCoroutineMutex( const uBaseCoroutine &coroutine );
    _Mutex void RegisterCoroutineBlockMutex( const uBaseTask &task, const uBaseCoroutine &coroutine );
    _Mutex void RegisterCoroutineUnblockMutex( const uBaseTask &task );
    _Mutex void RegisterTaskExecStateMutex( const uBaseTask &task, uBaseTask::State state, void *function );
    _Mutex void RegisterSetNameMutex( const uBaseCoroutine &coroutine, const char *name );
    _Mutex void RegisterMemoryAllocateMutex( void *address, size_t sizeRequested, size_t sizeAllocated, const uBaseTask &task );
    _Mutex void RegisterMemoryDeallocateMutex( void *address, size_t requestedSize, const uBaseTask &task );
     
    _Mutex void Finish();
  public:
    uProfiler();
    ~uProfiler();

    _Nomutex const uSymbolTable *GetSymbolTable() const;
    _Nomutex const uProfileAnalyze *GetAnalyzer() const;
    _Nomutex uCluster &GetCluster() const { return const_cast<uCluster &>( cluster ); }

    uTime WakeUp();

    _Nomutex void RegisterTask( const uBaseTask &task, const uSerial &serial, const uBaseTask &parent );
    _Nomutex void DeregisterTask( const uBaseTask &task );
    _Nomutex void RegisterTaskStartExecution( const uBaseTask &task );
    _Nomutex void RegisterTaskEndExecution( const uBaseTask &task );
    _Nomutex void RegisterCluster( const uCluster &cluster );
    _Nomutex void DeregisterCluster( const uCluster &cluster );
    _Nomutex void RegisterProcessor( const uProcessor &processor );
    _Nomutex void DeregisterProcessor( const uProcessor &processor );
    _Nomutex void MigrateTask( const uBaseTask &task, const uCluster &fromCluster, const uCluster &toCluster );
    _Nomutex void MigrateProcessor( const uProcessor &processor, const uCluster &fromCluster, const uCluster &toCluster );
    _Nomutex void RegisterFunctionEntry( uBaseTask *task, void *pcCallingFunction, void *pcCurrentFunction, void *pcFirstArg );
    _Nomutex void RegisterFunctionExit( uBaseTask *task, void *pcCallingFunction, void *pcCurrentFunction, void *pcFirstArg  );
    _Nomutex void RegisterMutexFunctionEntryTry( const uSerial &serial, const uBaseTask &task );
    _Nomutex void RegisterMutexFunctionEntryDone( const uSerial &serial, const uBaseTask &task );
    _Nomutex void RegisterMutexFunctionExit( const uSerial &serial, const uBaseTask &task );
    _Nomutex void RegisterMonitor( const uSerial &serial, const char *name, const uBaseTask &task );
    _Nomutex void DeregisterMonitor( const uSerial &serial, const uBaseTask &task );
    _Nomutex void RegisterAcceptStart( const uSerial &serial, const uBaseTask &task );
    _Nomutex void RegisterAcceptEnd( const uSerial &serial, const uBaseTask &task );
    _Nomutex void RegisterWait( const uCondition &condition, const uBaseTask &task, const uSerial &serial );
    _Nomutex void RegisterReady( const uCondition &condition, const uBaseTask &task, const uSerial &serial );
    _Nomutex void RegisterSignal( const uCondition &condition, const uBaseTask &task, const uSerial &serial );
    _Nomutex void RegisterCoroutine( const uBaseCoroutine &coroutine, const uSerial &serial );
    _Nomutex void DeregisterCoroutine( const uBaseCoroutine &coroutine );
    _Nomutex void RegisterCoroutineBlock( const uBaseTask &task, const uBaseCoroutine &coroutine );
    _Nomutex void RegisterCoroutineUnblock( const uBaseTask &task );
    _Nomutex void RegisterTaskExecState( const uBaseTask &task, uBaseTask::State state );
    _Nomutex void RegisterSetName( const uBaseCoroutine &coroutine, const char *name );
    _Nomutex uMemoryInfoEntry *RegisterMemoryAllocate( void *address, size_t sizeRequested, size_t sizeAllocated );
    _Nomutex void RegisterMemoryDeallocate( void *address, size_t requestedSize, uMemoryInfoEntry *entry );
    _Nomutex void Poll();

    // built-in modules (do not have corresponding mutex members => cannot be used by user metrics)
    _Nomutex void BuiltInRegisterTaskBlock( const uBaseTask &task ); // not allowed to block ( hook inside context switch routine )
    _Nomutex void BuiltInRegisterTaskUnblock( const uBaseTask &task ); // not allowed to block  ( hook inside context switch routine )
    _Nomutex void BuiltInRegisterFunctionEntry();
    _Nomutex void BuiltInRegisterFunctionExit();
    _Nomutex void BuiltInRegisterProcessor( const uProcessor & );    // not allowed to block (hook inside uC++ kernel)
    _Nomutex void BuiltInDeregisterProcessor( const uProcessor & );  // not allowed to block (hook inside uC++ kernel)
    _Nomutex void BuiltInRegisterTaskStartSpin( const uBaseTask & ); // not allowed to block
    _Nomutex void BuiltInRegisterTaskStopSpin( const uBaseTask & );  // not allowed to block

    // routine pointers to member routines in uProfiler

    static void (* uProfiler_RegisterTask)(uProfiler *, const uBaseTask &, const uSerial &, const uBaseTask & );
    static void (* uProfiler_DeregisterTask)(uProfiler *, const uBaseTask &);
    static void (* uProfiler_RegisterTaskStartExecution)(uProfiler *, const uBaseTask & );
    static void (* uProfiler_RegisterTaskEndExecution)(uProfiler *, const uBaseTask & );
    static void (* uProfiler_RegisterCluster)(uProfiler *, const uCluster &);
    static void (* uProfiler_DeregisterCluster)(uProfiler *, const uCluster &);
    static void (* uProfiler_RegisterProcessor)(uProfiler *, const uProcessor &);
    static void (* uProfiler_DeregisterProcessor)(uProfiler *, const uProcessor &);
    static void (* uProfiler_RegisterTaskMigrate)(uProfiler *, const uBaseTask &, const uCluster &, const uCluster & );
    static void (* uProfiler_RegisterProcessorMigrate)(uProfiler *, const uProcessor &, const uCluster &, const uCluster & );
    static void (* uProfiler_RegisterFunctionEntry)(uProfiler *, uBaseTask *, unsigned int, unsigned int, unsigned int );
    static void (* uProfiler_RegisterFunctionExit)(uProfiler *, uBaseTask * );
    static void (* uProfiler_RegisterMutexFunctionEntryTry)(uProfiler *, const uSerial &, const uBaseTask & );
    static void (* uProfiler_RegisterMutexFunctionEntryDone)(uProfiler *, const uSerial &, const uBaseTask & );    
    static void (* uProfiler_RegisterMutexFunctionExit)(uProfiler *, const uSerial &, const uBaseTask & );
    static void (* uProfiler_RegisterMonitor)(uProfiler *, const uSerial &, const char *, const uBaseTask &  );
    static void (* uProfiler_DeregisterMonitor)(uProfiler *, const uSerial &, const uBaseTask & );
    static void (* uProfiler_RegisterAcceptStart)(uProfiler *, const uSerial &, const uBaseTask & );
    static void (* uProfiler_RegisterAcceptEnd)(uProfiler *, const uSerial &, const uBaseTask & );    
    static void (* uProfiler_RegisterWait)(uProfiler *, const uCondition &, const uBaseTask &, const uSerial & );
    static void (* uProfiler_RegisterReady)(uProfiler *, const uCondition &, const uBaseTask &, const uSerial & );
    static void (* uProfiler_RegisterSignal)(uProfiler *, const uCondition &, const uBaseTask &, const uSerial & );
    static void (* uProfiler_RegisterCoroutine)(uProfiler *, const uBaseCoroutine &, const uSerial & );
    static void (* uProfiler_DeregisterCoroutine)(uProfiler *, const uBaseCoroutine & );
    static void (* uProfiler_RegisterCoroutineBlock)(uProfiler *, const uBaseTask &, const uBaseCoroutine & );    
    static void (* uProfiler_RegisterCoroutineUnblock)(uProfiler *, const uBaseTask & );
    static void (* uProfiler_RegisterTaskExecState)(uProfiler *, const uBaseTask &, uBaseTask::State );
    static void (* uProfiler_Poll)(uProfiler * );
    static void (* uProfiler_RegisterSetName)(uProfiler *, const uBaseCoroutine &, const char * );
    static uMemoryInfoEntry *(* uProfiler_RegisterMemoryAllocate)(uProfiler *, void *, size_t, size_t );
    static void (* uProfiler_RegisterMemoryDeallocate)(uProfiler *, void *, size_t, uMemoryInfoEntry * );
    
    // hooks for built in metrics (cannot be used by user metrics because they do not notify execution monitors)

    static void (* uProfiler_BuiltInRegisterTaskBlock)(uProfiler *, const uBaseTask & );
    static void (* uProfiler_BuiltInRegisterTaskUnblock)(uProfiler *, const uBaseTask & );
    static void (* uProfiler_BuiltInRegisterFunctionEntry)(uProfiler * );
    static void (* uProfiler_BuiltInRegisterFunctionExit)(uProfiler * );
    static void (* uProfiler_BuiltInRegisterProcessor)(uProfiler *, const uProcessor & );
    static void (* uProfiler_BuiltInDeregisterProcessor)(uProfiler *, const uProcessor & );
    static void (* uProfiler_BuiltInRegisterTaskStartSpin)(uProfiler *, const uBaseTask & );
    static void (* uProfiler_BuiltInRegisterTaskStopSpin)(uProfiler *, const uBaseTask & );

    // dynamic memory allocation in uC++ kernel

    static void (* uProfiler_PreallocateMetricMemory)(uProfiler *, void **, const uBaseTask & );
    static void (* uProfiler_PostallocateMetricMemory)(uProfiler *, const uBaseTask & );
    static void (* uProfiler_SetMetricMemoryPointers)(uProfiler *, void **, const uBaseTask & );
    static void (* uProfiler_ResetMetricMemoryPointers)(uProfiler *, const uBaseTask & );

    // debugging hook
    static void (* uProfiler_printCallStack)(uProfileTaskSampler * );
}; // uProfiler


#endif // __U_PROFILER_H__


// Local variables: //
// compile-command: "gmake install" //
// End: //
