# Copyright (c) 2007 Andrew Price
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import sys
import htmllib
import simplejson
import xml.dom.minidom as minidom

class User:

	def __init__(self, user):

		self.id = user[u'id']
		self.name = user[u'name']
		self.screen_name = user[u'screen_name']
		self.location = user[u'location']
		self.description = user[u'description']
		self.profile_image_url = user[u'profile_image_url']
		self.url = user[u'url']
		self.protected = user[u'protected']


class Status:

	def __init__(self, status=None):
		if status:
			self.set(status)

	def __str__(self):
		string = ""
		try:		
			string = "[%d] %s: %s (%s via %s)" % (self.id,
							self.user.name,
							self.text,
							self.created_at,
							self.source)
		except AttributeError, e:
			print >>sys.stderr, e

		return string

	def set(self, status):

		p = htmllib.HTMLParser(None)
		p.save_bgn()
		p.feed(status[u'text'])

		self.text = p.save_end()
		self.created_at = status[u'created_at']
		self.id = status[u'id']
		self.source = status[u'source']
		self.truncated = status[u'truncated']
		self.user = User(status[u'user'])

	def loads(self, s):

		if s:
			jsobj = simplejson.loads(s)
			self.set(jsobj)

class DirectMsg:

	def __init__(self, msg=None):
		if msg:
			self.set(msg)

	def __str__(self):

		string = ""
		try:
			string = "[%d] %s -> %s: %s (%s)" % (self.id,
							self.sender.name,
							self.recipient.name,
							self.text,
							self.created_at)
		except AttributeError, e:
			print >>sys.stderr, e
		return string

	def set(self, msg):

		p = htmllib.HTMLParser(None)
		p.save_bgn()
		p.feed(msg[u'text'])

		self.text = p.save_end()
		self.created_at = msg[u'created_at']
		self.id = msg[u'id']
		self.recipient_id = msg[u'recipient_id']
		self.recipient = User(msg[u'recipient'])
		self.recipient_screen_name = msg[u'recipient_screen_name']
		self.sender_id = msg[u'sender_id']
		self.sender = User(msg[u'sender'])
		self.sender_screen_name = msg[u'sender_screen_name']

	def loads(self, s):

		if s:
			jsobj = simplejson.loads(s)
			self.set(jsobj)


class StatusList(list):

	def __init__(self, json=None):

		self.lastread = ""
		self.lastid = 0
		if json is not None:
			try:
				self.jsobj = simplejson.loads(json)
			except ValueError:
				self.jsobj = []

			for i in self.jsobj:
				self.append(Status(i))
			if len(self) > 0:
				self.lastread = self[0].created_at
				self.lastid = self[0].id

	def gettime(self):
		return self.lastread
	
	def getlastid(self):
		return self.lastid


class DirectList(list):

	def __init__(self, json=None):

		if json is not None:
			try:
				self.jsobj = simplejson.loads(json)
			except ValueError:
				self.jsobj = []

			for i in self.jsobj:
				self.append(DirectMsg(i))

