/*
 * twpsk:  A gui application for PSK
 * Copyright (C) 1999-2005 Ted Williams WA0EIR 
 * widgets.C
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 2.1 - Aug 2002
 */

#include "twpskWids.h"
#include "sa.xbm"
#include "wf.xbm"

extern Scope scope; 
extern Disp disp;
extern Wids pskwids;
extern XtAppContext ac;
extern Pixel lightBG, darkBG;
extern int scconfig[2];

int netmode;


/*
 *  buildWidgets Method
 *  Creates all of the widgets for the interface
 */
void Wids::buildWidgets (Widget shell, AppRes *appRes)
{  
   /*
    * mainform - main form
    */
   mainform = XtVaCreateWidget ("mainform", xmFormWidgetClass, shell,
      XmNverticalSpacing, SPACING,
      XmNhorizontalSpacing, SPACING,
      NULL);

   /*
    * label1 - callsign label
    */
   label1 = XtVaCreateManagedWidget ("label1", xmLabelWidgetClass, mainform,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * menubar -  menubar and submenus
    */
   menuBar = XmCreateMenuBar (mainform, "menuBar", NULL, 0);

   /* All bar buttons get the tear off treatment */
   XtSetArg (args[i], XmNtearOffModel, XmTEAR_OFF_ENABLED); i++;

   fileMenu = XmCreatePulldownMenu (menuBar, "filePulldown", args, i);
   controlsMenu = XmCreatePulldownMenu (menuBar, "controlsPulldown", args, i);
   seekMenu = XmCreatePulldownMenu (menuBar, "SeekPulldown", args, i);
   /* Help menu is done later now */

   /*
    * File Cascade Button and submenu buttons
    */
   xs[0] = XmStringCreateLocalized ("File");
   fileCas = XtVaCreateManagedWidget ("File", xmCascadeButtonWidgetClass,
      menuBar,
      XmNlabelString, xs[0],
      XmNmnemonic, 'F',
      XmNsubMenuId, fileMenu,
      NULL);
   XmStringFree (xs[0]);

   /* Create button to match filenames in resource - appRes->buttonNames */
   createButtons (shell, appRes->buttonNames); 

   /*
    * Controls Cascade Button and submenu buttons
    */
   xs[0] = XmStringCreateLocalized ("Controls");
   controlsCas = XtVaCreateManagedWidget ("controls",
      xmCascadeButtonWidgetClass, menuBar,
      XmNlabelString, xs[0],
      XmNmnemonic, 'C',
      XmNsubMenuId, controlsMenu,
      NULL);
   XmStringFree (xs[0]);

   /* Audio menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-A");
   audioBtn = XtVaCreateManagedWidget("Audio",
      xmPushButtonWidgetClass, controlsMenu,
      XmNsensitive, appRes->noMixer ? 0 : 1,
      XmNaccelerator, "Ctrl<Key>A",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'A',
      NULL);
   XmStringFree (xs[0]);
   
   /* Video menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-V");
   videoBtn = XtVaCreateManagedWidget("Video",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>V",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'V',
      NULL);
   XmStringFree (xs[0]);

   /* Separator */
   sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, controlsMenu,
      NULL);

   /* Recv menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-R");
   rxBtn = XtVaCreateManagedWidget("Recv",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>R",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'R',
      NULL);
   XmStringFree (xs[0]);

   /* Xmit menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-X");
   txBtn = XtVaCreateManagedWidget("Xmit",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>X",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'X',
      NULL);
   XmStringFree (xs[0]);

   /* Tune menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-T");
   tuneBtn = XtVaCreateManagedWidget("Tune",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>T",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'T',
      NULL);
   XmStringFree (xs[0]);

   /* Separator */
   sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, controlsMenu,
      NULL);

   /* Broad menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-B");
   broadBtn = XtVaCreateManagedWidget("Broad",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>B",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'B',
      NULL);
   XmStringFree (xs[0]);

   /* Medium menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-M");
   mediumBtn = XtVaCreateManagedWidget("Medium",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>M",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'M',
      NULL);
   XmStringFree (xs[0]);

   /* Narrow menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-N");
   narrowBtn = XtVaCreateManagedWidget("Narrow",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>N",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'N',
      NULL);
   XmStringFree (xs[0]);

   /* Separator */
   sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, controlsMenu,
      NULL);

   /* Spectrum menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-S");
   saBtn = XtVaCreateManagedWidget("Spectrum",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>S",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'S',
      NULL);
   XmStringFree (xs[0]);

   /* Waterfall menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-W");
   wfBtn = XtVaCreateManagedWidget("Waterfall",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>W",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'W',
      NULL);
   XmStringFree (xs[0]);

   /* Separator */
   sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, controlsMenu,
      NULL);

   /* Decoder window */
   xs[0] = XmStringCreateLocalized ("Ctrl-O");
   openBtn = XtVaCreateManagedWidget("Open Decoder",
      xmPushButtonWidgetClass, controlsMenu,
      XmNaccelerator, "Ctrl<Key>O",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'O',
      NULL);
   XmStringFree (xs[0]);

/* End of Controls Menu */

   /* 
    * Seek Cascade Button and submenu.  
    */
   xs[0] = XmStringCreateLocalized ("Seek");
   seekCas = XtVaCreateManagedWidget ("seek",
      xmCascadeButtonWidgetClass, menuBar,
      XmNlabelString, xs[0],
      XmNmnemonic, 'S',
      XmNsubMenuId, seekMenu,
      NULL);
   XmStringFree (xs[0]);

   /* Seek Up menu button */
   xs[0] = XmStringCreateLocalized ("Ctrl-U");
   upBtn = XtVaCreateManagedWidget("Up",
      xmPushButtonWidgetClass, seekMenu,
      XmNaccelerator, "Ctrl<Key>U",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'U',
      NULL);
   XmStringFree (xs[0]);
   
   /* Seek Down button */
   xs[0] = XmStringCreateLocalized ("Ctrl-D");
   downBtn = XtVaCreateManagedWidget("Down",
      xmPushButtonWidgetClass, seekMenu,
      XmNaccelerator, "Ctrl<Key>D",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'D',
      NULL);
   XmStringFree (xs[0]);
   
   /* Seek Halt button */
   xs[0] = XmStringCreateLocalized ("Ctrl-H");
   haltBtn = XtVaCreateManagedWidget("Halt",
      xmPushButtonWidgetClass, seekMenu,
      XmNaccelerator, "Ctrl<Key>H",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'H',
      NULL);
   XmStringFree (xs[0]);

/* Help Menu Button */
   xs[0] = XmStringCreateLocalized ("Help");
   helpCas = XtVaCreateManagedWidget ("Help", xmCascadeButtonWidgetClass,
      menuBar,
      XmNlabelString, xs[0],
      XmNmnemonic, 'H',
      XmNsubMenuId, helpMenu,
      NULL);
   XmStringFree (xs[0]);

   /*
    * Help Cascade Button and submenu
    */
   i = 0;
   xs[i] = XmStringCreateLocalized ("About"); i++;
   xs[i] = XmStringCreateLocalized ("Introduction"); i++;
   xs[i] = XmStringCreateLocalized ("Menu Bar"); i++;
   xs[i] = XmStringCreateLocalized ("Help Windows"); i++;
   xs[i] = XmStringCreateLocalized ("Main Window"); i++;
   xs[i] = XmStringCreateLocalized ("Tuning"); i++;
   xs[i] = XmStringCreateLocalized ("Secondary Windows"); i++;
   xs[i] = XmStringCreateLocalized ("Sending Files"); i++;
   xs[i] = XmStringCreateLocalized ("Macros"); i++;
   xs[i] = XmStringCreateLocalized ("Resources"); i++;
   xs[i] = XmStringCreateLocalized ("Accelerator Keys"); i++;
                                                                                
   helpMenu = XmVaCreateSimplePulldownMenu (menuBar, "helpMenu", 3, helpCB,
      XmVaPUSHBUTTON, xs[0], 'A', NULL, NULL,
      XmVaPUSHBUTTON, xs[1], 'I', NULL, NULL,
      XmVaPUSHBUTTON, xs[2], 'B', NULL, NULL,
      XmVaPUSHBUTTON, xs[3], 'H', NULL, NULL,
      XmVaPUSHBUTTON, xs[4], 'M', NULL, NULL,
      XmVaPUSHBUTTON, xs[5], 'T', NULL, NULL,
      XmVaPUSHBUTTON, xs[6], 'W', NULL, NULL,
      XmVaPUSHBUTTON, xs[7], 'S', NULL, NULL,
      XmVaPUSHBUTTON, xs[8], 'M', NULL, NULL,
      XmVaPUSHBUTTON, xs[9], 'R', NULL, NULL,
      XmVaPUSHBUTTON, xs[10], 'K', NULL, NULL,
      NULL);
                                                                                
   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   XtVaSetValues (helpMenu,
      XmNtearOffModel, XmTEAR_OFF_ENABLED,
      NULL);

   /* Main Menu Properties */
   XtVaSetValues (menuBar,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, label1,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNmenuHelpWidget, XtNameToWidget(menuBar, "button_1"),
      XmNmenuHelpWidget, helpCas,
      NULL);

/* 
 * End of menu stuff
 */

   /*
    * scopeDA - Scope drawing area 
    * child of mainform and other widget get built/attached to it
    */
   scopeDA = XtVaCreateManagedWidget ("scopeDA", xmDrawingAreaWidgetClass,
      mainform,
      XmNheight, scope.SCOPE_WIDTH,
      XmNwidth, scope.SCOPE_WIDTH,
      XmNtopAttachment, XmATTACH_NONE,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      XmNtraversalOn, False,
      NULL);


   /*
    * displayForm - for display row/column
    */
   displayForm = XtVaCreateWidget ("displayForm", xmFormWidgetClass, mainform,
      // XmNentryAlignment, XmALIGNMENT_CENTER,
      XmNtopAttachment, XmATTACH_NONE,
      XmNtopOffset, SPACING,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, scopeDA,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * displayRC - row/column for label, displayRB, and bwRB
    */
   displayRC = XtVaCreateWidget ("displayRC", xmRowColumnWidgetClass,
      displayForm,
      XmNentryAlignment, XmALIGNMENT_CENTER,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * dispLabel - label for display controls
    */
   dispLabel = XtVaCreateManagedWidget ("Display Controls", xmLabelWidgetClass,
      displayRC,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
   /*
    * displayRB - spectrum analyser/waterfall radiobox
    */
   i = 0;
   XtSetArg (args[i], XmNorientation, XmHORIZONTAL); i++;
   XtSetArg (args[i], XmNmarginWidth, 0); i++;
   XtSetArg (args[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
   XtSetArg (args[i], XmNtopWidget, dispLabel); i++;
   XtSetArg (args[i], XmNbottomAttachment, XmATTACH_NONE); i++;
   XtSetArg (args[i], XmNleftAttachment, XmATTACH_FORM); i++;
   XtSetArg (args[i], XmNrightAttachment, XmATTACH_FORM); i++;

   displayRB = XmCreateRadioBox (displayRC, "displayRB", args, i);

   /* Pixmaps for sa and wf ToggleButtons */
   fg = WhitePixelOfScreen (XtScreen (shell));
   bg = BlackPixelOfScreen (XtScreen (shell));

   saPixmap = XCreatePixmapFromBitmapData (XtDisplay (shell),
      RootWindowOfScreen (XtScreen (shell)),
      sa_bits, sa_width, sa_height, bg, fg,
      DefaultDepthOfScreen (XtScreen (shell)));

   wfPixmap = XCreatePixmapFromBitmapData (XtDisplay (shell),
      RootWindowOfScreen (XtScreen (shell)),
      wf_bits, wf_width, wf_height, bg, fg,
      DefaultDepthOfScreen (XtScreen (shell)));

   saTB = XtVaCreateManagedWidget ("saTB", xmToggleButtonWidgetClass, displayRB,
      XmNlabelType, XmPIXMAP,
      XmNlabelPixmap, saPixmap,
      NULL);
      
   wfTB = XtVaCreateManagedWidget ("wfTB", xmToggleButtonWidgetClass, displayRB,
      XmNlabelType, XmPIXMAP,
      XmNlabelPixmap, wfPixmap,
      NULL);

   XtVaGetValues (wfTB,
      XmNset, &i,
      NULL);
   disp.changeDisplay (i);

   /*
    * bwRB - band width selection radio box
    */
   i = 0;
   XtSetArg (args[i], XmNorientation, XmHORIZONTAL); i++;
   XtSetArg (args[i], XmNmarginWidth, 0); i++;
   XtSetArg (args[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
   XtSetArg (args[i], XmNtopWidget, displayRB); i++;
   XtSetArg (args[i], XmNbottomAttachment, XmATTACH_NONE); i++;;
   XtSetArg (args[i], XmNleftAttachment, XmATTACH_FORM); i++;
   XtSetArg (args[i], XmNrightAttachment, XmATTACH_FORM); i++;

   bwRB = XmCreateRadioBox (displayRC, "bwRB", args, i);

   broadTB = XtVaCreateManagedWidget ("B", xmToggleButtonWidgetClass, bwRB,
      XmNmnemonic, 'B',
      NULL);

   mediumTB = XtVaCreateManagedWidget ("M", xmToggleButtonWidgetClass, bwRB,
      XmNmnemonic, 'M',
      NULL);

   narrowTB = XtVaCreateManagedWidget ("N", xmToggleButtonWidgetClass, bwRB,
      XmNmnemonic, 'N',
      NULL);

   /*
    * find the toggle button set by the resource file
    * and set fftSample.
    */
   if (XmToggleButtonGetState(broadTB) == 1)
      fftSample = 2;

   if (XmToggleButtonGetState(mediumTB) == 1)
      fftSample = 4;

   if (XmToggleButtonGetState(narrowTB) == 1)
      fftSample = 8;

   /*
    * controlsForm - for rxFreq, txFreq forms, and T/R radiobox
    * and Mode toggle buttons radio box
    */
   controlsForm = XtVaCreateWidget ("controlsForm", xmFormWidgetClass, mainform,
      XmNhorizontalSpacing, SPACING,
      XmNtopAttachment, XmATTACH_NONE,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, displayForm,
      XmNrightAttachment, XmATTACH_NONE,
      XmNleftOffset, 0,
      NULL);

   /*
    * modesRC - row column for DCD, QPSK, LSB, CW ID, and IMD toggle buttons,
    * and IMD display
    */
    modesRC = XtVaCreateWidget ("modesRC", xmRowColumnWidgetClass, controlsForm,
      XmNentryAlignment, XmALIGNMENT_BEGINNING,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * modeLabel - label for mode buttons
    */
   modeLabel = XtVaCreateManagedWidget ("Modes", xmLabelWidgetClass, modesRC,
      NULL); 

   /*
    * dcdTB - DCD toggle button
    */
   dcdTB = XtVaCreateManagedWidget ("DCD", xmToggleButtonWidgetClass, modesRC,
      XmNset, 0,
      XmNshadowThickness, 2,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL);
  
   commControl(COMM_RXCH, COMM_DCDLEVEL, 15);   /* 15 seems to work nicely! */

   /*
    * qpsk - enables Qpsk mode when on
    * defaults to off state, unless set in resource file
    */
   qpskTB = XtVaCreateManagedWidget ("QPSK", xmToggleButtonWidgetClass, modesRC,
      XmNshadowThickness, 2,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL);
 
   /*
    * sbTB - enables LSB mode when on
    * defaults to off state, unless set in resource file
    */
   lsbTB = XtVaCreateManagedWidget ("LSB", xmToggleButtonWidgetClass, modesRC,
      XmNshadowThickness, 2,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL);

   /*
    * cwidTB - enables CW ID mode when on
    */
   cwidTB = XtVaCreateManagedWidget ("CW ID", xmToggleButtonWidgetClass,
      modesRC,
      XmNshadowThickness, 2,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL);

   /*
    * imdFrame - frame for IMD display so it looks like a button
    */
   imdFrame = XtVaCreateWidget ("imdFrame", xmFrameWidgetClass, modesRC,
      XmNshadowThickness, 2,
      XmNshadowType, XmSHADOW_OUT,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL);
      
   /*
    * imdForm - form for IMD display
    */
   imdForm = XtVaCreateWidget ("imdForm", xmFormWidgetClass, imdFrame,
      NULL);
      
   /*
    * imdTF - textfield for IMD display
    */
   imdTF = XtVaCreateManagedWidget ("imdTF", xmTextFieldWidgetClass, imdForm,
      XmNcolumns, 3,
      XmNshadowThickness, 0,
      XmNvalue, "---",
      XmNcursorPositionVisible, False,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * imdLabel - label for IMD display
    */
   imdLabel = XtVaCreateManagedWidget ("IMD", xmLabelWidgetClass, imdForm,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, imdTF,
      XmNrightAttachment, XmATTACH_FORM,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL);
   /*
    * Sync classes with lsb and qpsk widgets.   They are not set in
    * resource file, but just in case. 
    */
   XtVaGetValues(lsbTB,
      XmNset, &lsb,
      NULL);

   XtVaGetValues(qpskTB,
      XmNset, &qpsk,
      NULL);

   commControl(COMM_TXCH, COMM_QPSK, qpsk);
   commControl(COMM_RXCH, COMM_QPSK, qpsk);
   commControl(COMM_TXCH, COMM_LSB, lsb);
   commControl(COMM_RXCH, COMM_LSB, lsb);

   /*
    * controlsRC - row column for frequency, xmit, and mode controls
    */
   controlsRC = XtVaCreateWidget ("controlsRC", xmRowColumnWidgetClass,
      controlsForm,
      XmNentryAlignment, XmALIGNMENT_CENTER,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_WIDGET,
      XmNrightWidget, modesRC,
      NULL);

   /*
    *  rxLabel - label for rx controls
    */
   rxLabel = XtVaCreateManagedWidget ("Rx Freq", xmLabelWidgetClass, controlsRC,
      NULL);

   /*
    * rxComboForm - for recv controls - freq, up/down, and AFC
    */      
   rxComboForm = XtVaCreateWidget ("rxComboForm", xmFormWidgetClass, controlsRC,
      NULL);
  
   /*
    * rxFreqText - Rec freq Text Field 
    */
   if (appRes->rxFreq == 0.0)
      appRes->rxFreq = 1000.0;

   commControl(COMM_RXCH, COMM_FREQ, (int)(appRes->rxFreq*100));
   sprintf (str, "%4.1f\n", appRes->rxFreq);

   rxFreqTF = XtVaCreateManagedWidget ("rxFreqText", xmTextFieldWidgetClass,
      rxComboForm,
      XmNhighlightOnEnter, True,
      XmNuserData, (XtPointer) 'R',
      XmNmaxLength, 6,
      XmNcolumns, 6,
      XmNmarginHeight, 10,
      XmNvalue, str,
      XmNtopAttachment,XmATTACH_FORM,
      XmNbottomAttachment,XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * rxUpArrow - Arrow button for rx freq Up
    */
   rxUpArrow = XtVaCreateManagedWidget ("rxUpArrow", xmArrowButtonWidgetClass,
      rxComboForm,
      XmNuserData, (XtPointer) 'R',
      XmNwidth, ARROW_WIDTH,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_POSITION,
      XmNbottomPosition, 50,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, rxFreqTF,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * rxDownArrow - Arrow button for rx freq Down
    */
   rxDnArrow = XtVaCreateManagedWidget ("rxUpArrow", xmArrowButtonWidgetClass,
      rxComboForm,
      XmNuserData, (XtPointer) 'R',
      XmNwidth, ARROW_WIDTH,
      XmNarrowDirection, XmARROW_DOWN,
      XmNtopAttachment, XmATTACH_POSITION,
      XmNtopPosition, 50,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, rxFreqTF,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * afcTB - Create Toggle button for AFC and set to start up value 
    */
   afcTB = XtVaCreateManagedWidget ("AFC", xmToggleButtonWidgetClass,
      rxComboForm,
      XmNset, appRes->afc,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, rxUpArrow,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
      
   /* Sync class with widget */
   commControl(COMM_RXCH, COMM_AFC, appRes->afc);

   /*
    *  txLabel - label for tx controls
    */
   txLabel = XtVaCreateManagedWidget ("Tx Freq", xmLabelWidgetClass,
      controlsRC,
      NULL);

   /*
    * txComboForm - for xmit controls - freq, up/down, and Net
    */      
   txComboForm = XtVaCreateWidget ("txComboForm", xmFormWidgetClass, controlsRC,
      NULL);   

   /*
    * txFreqText - Xmit freq Text Field
    */
   if (appRes->txFreq == 0.0)
      appRes->txFreq = 1000.0;

   sprintf (str, "%4.1f", appRes->txFreq);
   commControl(COMM_TXCH, COMM_FREQ, (int)(appRes->txFreq*100));

   txFreqTF = XtVaCreateManagedWidget ("txFreqText", xmTextFieldWidgetClass,
      txComboForm,
      XmNuserData, (XtPointer) 'T',
      XmNmaxLength, 6,
      XmNcolumns, 6,
      XmNmarginHeight, 10,
      XmNvalue, str,
      XmNtopAttachment,XmATTACH_FORM,
      XmNbottomAttachment,XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * txUpArrow - Arrow button for tx freq Up
    */
   txUpArrow = XtVaCreateManagedWidget ("txUpArrow", xmArrowButtonWidgetClass,
      txComboForm,
      XmNuserData, (XtPointer) 'T',
      XmNwidth, ARROW_WIDTH,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_POSITION,
      XmNbottomPosition, 50,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, txFreqTF,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * txDownArrow - Arrow button for tx freq Down
    */
   txDnArrow = XtVaCreateManagedWidget ("txUpArrow", xmArrowButtonWidgetClass,
      txComboForm,
      XmNuserData, (XtPointer) 'T',
      XmNwidth, ARROW_WIDTH,
      XmNarrowDirection, XmARROW_DOWN,
      XmNtopAttachment, XmATTACH_POSITION,
      XmNtopPosition, 50,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, txFreqTF,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * netTB - Toggle button for NET
    */
   netTB = XtVaCreateManagedWidget ("NET", xmToggleButtonWidgetClass,
      txComboForm,
      XmNset, appRes->net,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, txUpArrow,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
      
   /* Sync class with widget */
   netmode = appRes->net;

   /*
    *  trLabel - label for xmit/rec/tune controls
    */
   trLabel = XtVaCreateManagedWidget ("T/R Controls", xmLabelWidgetClass,
      controlsRC,
      NULL);

   /*
    * trRB - Radio Box for xmit/recv/tune mode controls
    */
   trRB = XmCreateRadioBox (controlsForm, "trRB", NULL, 0);
   XtVaSetValues (trRB,
      XmNentryAlignment, XmALIGNMENT_CENTER,
      XmNorientation, XmHORIZONTAL,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, trLabel,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /*
    * rxTB - Rec toggle button
    * The rx, tx, and tune togglebuttons have the indicator OFF
    * and the shadow thickness = 2, so they look like regular
    * push buttons.
    */
   rxTB = XtVaCreateManagedWidget ("Recv", xmToggleButtonWidgetClass, trRB,
      XmNset, True,
      XmNindicatorOn, False,
      XmNshadowThickness, 2,
      XmNmnemonic, 'R',
      NULL);

   /*
    * txTB - Xmit toggle button
    */
   txTB = XtVaCreateManagedWidget ("Xmit", xmToggleButtonWidgetClass, trRB,
      XmNindicatorOn, False,
      XmNshadowThickness, 2,
      XmNmnemonic, 'X',
      NULL);

   /*
    * tuneTB - Xmit toggle button
    */
   tuneTB = XtVaCreateManagedWidget ("tuneTB", xmToggleButtonWidgetClass, trRB,
      XmNindicatorOn, False,
      XmNshadowThickness, 2,
      XmNmnemonic, 'T',
      NULL);

   /*
    * wfDA - water fall drawing area
    */
   wfDA = XtVaCreateWidget ("wfDA", xmDrawingAreaWidgetClass, mainform,
      XmNheight, WF_HEIGHT,
      XmNwidth, WF_WIDTH,
      XmNbackground, lightBG,
      XmNtopAttachment, XmATTACH_NONE,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, controlsForm,
      XmNleftAttachment, XmATTACH_FORM,
      XmNtraversalOn, False,
      NULL);

   /* 
    * paneWin - paned window for rx and tx text wids.`
    */
   paneWin = XtVaCreateWidget ( "paneWin", xmPanedWindowWidgetClass, mainform,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, menuBar,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, wfDA,
      XmNspacing, 15,
      NULL);

   /*
    * rxTextSW - Receive Text Scrolled Window
    */
   rxTextSW = XtVaCreateWidget ("rxTextSW", xmScrolledWindowWidgetClass,
   paneWin,
   NULL);

   /* rxText - text widget for received data */
   rxText = XtVaCreateManagedWidget ("rxText", xmTextWidgetClass, rxTextSW,
      XmNeditMode, XmMULTI_LINE_EDIT,
      XmNeditable, False,
      XmNwordWrap, True,
      XmNcursorPositionVisible, False,
      XmNautoShowCursorPosition, False,
      XmNscrollHorizontal, False,
      XmNuserData, (XtPointer)this,
      NULL);

   /* 
    * txTextSW - Transmit Text Scrolled Window
    */
   txTextSW = XtVaCreateWidget ("txTextSW", xmScrolledWindowWidgetClass,
   paneWin,
   NULL);
   
   /* txText widget - text widget for transmit data */
   txText = XtVaCreateManagedWidget ("txText", xmTextWidgetClass, txTextSW,
      XmNcolumns, 8,
      XmNeditMode, XmMULTI_LINE_EDIT,
      XmNeditable, True,
      XmNwordWrap, True,
      XmNhighlightThickness, 2,
      XmNautoShowCursorPosition, True,
      XmNblinkRate, 0,
      XmNscrollHorizontal, False,
      NULL);

   /*
    * Set up rxScrollFlag for normal and scroll mode 
    */
   rxScrollFlag = 0;                         /* rxText scrolling off */

   XtVaGetValues (rxTextSW,                  /* get scrollbar widget */
      XmNverticalScrollBar, &rxScrollBar,    /* for adding to callbacks */
      NULL);
   /*
    * End of main window
    */


   /*
    * audioDiag - create the audio mixer and soundcard configuration
    * dialog and its children
    */
   audioDiag = XmCreateFormDialog(shell, "audioDiag", NULL, 0);

   XtVaSetValues (audioDiag,
      XmNverticalSpacing, SPACING/2,
      XmNhorizontalSpacing, SPACING,
      NULL);

   XtVaSetValues (XtParent(audioDiag),   
      XmNtitle, "TWPSK AUDIO",
      XmNmwmDecorations, MWM_DECOR_ALL | MWM_DECOR_RESIZEH,
      NULL);
      
   /*
    * mixerLabel - label for audio mixer control
    */
   mixerLabel = XtVaCreateManagedWidget ("Mixer Controls", xmLabelWidgetClass,
      audioDiag,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
      
   /*
    * mixerFrame - frame for mixer controls
    */
   mixerFrame = XtVaCreateManagedWidget ("mixerFrame", xmFrameWidgetClass,
      audioDiag,
      XmNshadowThickness, 3,
      XmNshadowType, XmSHADOW_OUT,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, mixerLabel,
      XmNbottomWidget, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      NULL);

   mixerForm = XtVaCreateManagedWidget ("mixerForm", xmFormWidgetClass,
      mixerFrame,
      XmNverticalSpacing, SPACING,
      XmNhorizontalSpacing, SPACING,
      NULL);
      
   /*
    * mainLabel - label for main audio mixer control
    */
   mainLabel = XtVaCreateManagedWidget ("Main", xmLabelWidgetClass, mixerForm,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
      
   /*
    * mainScale - scale for main mixer control
    */
   mainScale = XtVaCreateManagedWidget ("mainScale", xmScaleWidgetClass,
      mixerForm,
      XmNorientation, XmHORIZONTAL,
      XmNvalue, appRes->mainVol,
      XmNscaleMultiple, 1,
      XmNshowValue, True,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, mainLabel,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
      
   /* Sync the mixer with the widget */
   appRes->mainVol = (appRes->mainVol << 8) + appRes->mainVol;
   setLevel (SOUND_MIXER_VOLUME, appRes->mainVol);
   
   /*
    * outLabel - label for out mixer control
    */
   outLabel = XtVaCreateManagedWidget ("Out", xmLabelWidgetClass, mixerForm,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, mainScale,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
      
   /*
    * pcmScale - scale for pcm/output mixer control
    */
   pcmScale = XtVaCreateManagedWidget ("pcmScale", xmScaleWidgetClass,
      mixerForm,
      XmNorientation, XmHORIZONTAL,
      XmNvalue, appRes->outVol,
      XmNscaleMultiple, 1,
      XmNshowValue, True,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, outLabel,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
      
   /* Sync the mixer with the widget */
   appRes->outVol = (appRes->outVol << 8) + appRes->outVol;
   setLevel (SOUND_MIXER_PCM, appRes->outVol);
   
   /*
    * inputLabel - label for input mixer control
    */
   inputLabel = XtVaCreateManagedWidget ("In", xmLabelWidgetClass, mixerForm,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, pcmScale,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL); 

   /*
    * inScale - scale for input mixer control
    */
   inScale = XtVaCreateManagedWidget ("inScale", xmScaleWidgetClass, mixerForm,
      XmNorientation, XmHORIZONTAL,
      XmNvalue, appRes->inVol,
      XmNscaleMultiple, 1,
      XmNshowValue, True,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, inputLabel,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /* Sync the mixer with the widget */
   appRes->inVol = (appRes->inVol << 8) + appRes->inVol;
   setLevel (SOUND_MIXER_LINE, appRes->inVol);

   /*
    * configLabel - label for Soundcard configuration radioboxes
    */
   configLabel = XtVaCreateManagedWidget ("Soundcard Configuration",
      xmLabelWidgetClass, audioDiag,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, mixerForm,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * scFrame - frame for soundcard configuration options
    */
   scFrame = XtVaCreateManagedWidget ("scFrame", xmFrameWidgetClass,
      audioDiag,
      XmNshadowThickness, 3,
      XmNshadowType, XmSHADOW_OUT,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, configLabel,
      XmNbottomWidget, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      NULL);

   scForm = XtVaCreateWidget ("scForm", xmFormWidgetClass,
      scFrame,
      NULL);
//TJW
   scRC = XtVaCreateWidget ("scRC", xmRowColumnWidgetClass, scForm,
      XmNrightAttachment, XmATTACH_POSITION,
      XmNrightPosition, 80,
      XmNleftAttachment, XmATTACH_POSITION,
      XmNleftPosition, 20,
      NULL);
      
   /*
    * 8 or 16 bit Option Menu
    */
   i = 0;
   xs[i] = XmStringCreateLocalized ("8 Bit"); i++;
   xs[i] = XmStringCreateLocalized ("16 Bit"); i++;

   bitsOM = XmVaCreateSimpleOptionMenu (scRC, "bitsOM", NULL, 0,
      scconfig[0], bitsCB,
      XmVaPUSHBUTTON, xs[0], NULL, NULL, NULL,
      XmVaPUSHBUTTON, xs[1], NULL, NULL, NULL,
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   XtVaSetValues (bitsOM,
      XmNorientation, XmHORIZONTAL,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_POSITION,
      XmNleftPosition, 10,
      XmNrightAttachment, XmATTACH_POSITION,
      XmNrightPosition, 90,
      NULL);

   XtUnmanageChild (XmOptionLabelGadget (bitsOM));

   /*
    * Mono/Stereo Option Menu
    */
   i = 0;
   xs[i] = XmStringCreateLocalized ("Mono"); i++;
   xs[i] = XmStringCreateLocalized ("Stereo"); i++;

   chansOM = XmVaCreateSimpleOptionMenu (scRC, "chansOM", NULL, 0,
      scconfig[1], chansCB,
      XmVaPUSHBUTTON, xs[0], NULL, NULL, NULL,
      XmVaPUSHBUTTON, xs[1], NULL, NULL, NULL,
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   XtVaSetValues (chansOM,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, bitsOM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNbottomWidget, bitsOM,
      XmNleftAttachment, XmATTACH_FORM,
      //XmNleftPosition, 10,
      XmNrightAttachment, XmATTACH_FORM,
      //XmNrightPosition, 100,
      NULL);

   XtUnmanageChild (XmOptionLabelGadget (chansOM));

   /*
    * audioCloseBtn - button to close the mixer dialog
    */  
   audioCloseBtn = XtVaCreateManagedWidget ("Close", xmPushButtonWidgetClass,
      audioDiag,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopOffset, 2 * SPACING,
      XmNtopWidget, bitsOM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNbottomOffset, SPACING,
      XmNleftAttachment, XmATTACH_FORM,
      XmNleftOffset, 4 * SPACING,
      XmNrightAttachment, XmATTACH_FORM,
      XmNrightOffset, 4 * SPACING,
      NULL);


   /*
    * displayDiag - create the display dialog/form and its children
    */
   displayDiag = XmCreateFormDialog(shell, "displayDiag", NULL, 0);
   XtVaSetValues (displayDiag,
      XmNverticalSpacing, SPACING/2,
      XmNhorizontalSpacing, SPACING,
      NULL);

   XtVaSetValues (XtParent(displayDiag),   
      XmNtitle, "TWPSK VIDEO",
      XmNmwmDecorations, MWM_DECOR_ALL | MWM_DECOR_RESIZEH,
      NULL);

   /*
    * brightLabel - label for Brightness control
    */
   brightLabel = XtVaCreateManagedWidget ("Brightness", xmLabelWidgetClass,
      displayDiag,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * brightScale - fft display brightness
    */
    brightScale = XtVaCreateManagedWidget ("brightScale", xmScaleWidgetClass,
      displayDiag,
      XmNscaleMultiple, 1,
      XmNminimum, 1,
      XmNorientation, XmHORIZONTAL,
      XmNshowValue, True,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, brightLabel,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

      XtVaGetValues (brightScale,
         XmNvalue, &brightness,
         NULL);
      disp.brightness = brightness;     

   /*
    * fftLabel - label for fft control
    */
   fftLabel = XtVaCreateManagedWidget ("Display Speed", xmLabelWidgetClass,
      displayDiag,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, brightScale,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);
            
   /*
    * fftScale - sets speed of display
    */
   fftScale = XtVaCreateManagedWidget ("fftSpeedScale", xmScaleWidgetClass,
      displayDiag,
      XmNorientation, XmHORIZONTAL,
      XmNshowValue, True,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, fftLabel,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * Get the value set by the resource file for
    * the fft setup
    */
   XtVaGetValues (fftScale,    /* for fft setup */
      XmNvalue, &fftSpeed,
      NULL);

   /*
    * displayCloseBtn - close button 
    */  
   displayCloseBtn = XtVaCreateManagedWidget ("Close", xmPushButtonWidgetClass,
      displayDiag,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopOffset,2 * SPACING,
      XmNtopWidget, fftScale,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNbottomOffset, SPACING,
      XmNleftAttachment, XmATTACH_FORM,
      XmNleftOffset, 4 * SPACING,
      XmNrightAttachment, XmATTACH_FORM,
      XmNrightOffset, 4 * SPACING,
      NULL);

   /*
    * Create two popup menus for clearing rx and tx text widgets
    */
   i = 0;
   xs[i] = XmStringCreateLocalized ("Rx Text"); i++;
   xs[i] = XmStringCreateLocalized ("Tx Text"); i++;
   xs[i] = XmStringCreateLocalized ("Clear"); i++;
   xs[i] = XmStringCreateLocalized ("Ctrl-C"); i++;

   clrRxPopup = XmVaCreateSimplePopupMenu(rxTextSW, "clrRx", clrTextCB,
      XmVaTITLE, xs[0],
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, xs[2], 'C', "Ctrl<Key>c", xs[3],
      NULL);

   XtVaSetValues (clrRxPopup,         /* userdata is text wid to clear */
      XmNuserData, (XtPointer)rxText,
      NULL);

   clrTxPopup = XmVaCreateSimplePopupMenu(txTextSW, "clrTx", clrTextCB,
      XmVaTITLE, xs[1],
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, xs[2], 'C', "Ctrl<Key>c", xs[3],
      NULL);

   XtVaSetValues (clrTxPopup,         /* userdata is text wid to clear */
      XmNuserData, txText,
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   /*      
    * Add Callbacks
    *
    * Controls menu buttons callbacks
    */
   XtAddCallback (rxBtn, XmNactivateCallback, controlsBtnCB, (XtPointer) rxTB);
   XtAddCallback (txBtn, XmNactivateCallback, controlsBtnCB, (XtPointer) txTB);
   XtAddCallback (tuneBtn, XmNactivateCallback, controlsBtnCB,
      (XtPointer) tuneTB);

   XtAddCallback (broadBtn, XmNactivateCallback, controlsBtnCB,
      (XtPointer) broadTB);
   XtAddCallback (mediumBtn, XmNactivateCallback, controlsBtnCB,
      (XtPointer) mediumTB);
   XtAddCallback (narrowBtn, XmNactivateCallback, controlsBtnCB,
      (XtPointer) narrowTB);

   XtAddCallback (saBtn, XmNactivateCallback, controlsBtnCB, (XtPointer) saTB);
   XtAddCallback (wfBtn, XmNactivateCallback, controlsBtnCB, (XtPointer) wfTB);

   /*
    * Setup menu button callbacks -  pop up/pop down the setup dialog
    */
//TJW need to change the callback names on the next four
// so they have their own cb's

   XtAddCallback (audioBtn, XmNactivateCallback, popupDiagCB,
      (XtPointer)audioDiag);
   XtAddCallback (videoBtn, XmNactivateCallback, popupDiagCB,
      (XtPointer)displayDiag);
   XtAddCallback (audioCloseBtn, XmNactivateCallback, closeAudioDiagCB,
      (XtPointer) audioDiag);
   XtAddCallback (displayCloseBtn, XmNactivateCallback, closeVideoDiagCB,
      (XtPointer) displayDiag);

   /*
    *  SA/WF radio box buttons
    */
   XtAddCallback (saTB, XmNvalueChangedCallback, changeDisplayCB,
      (XtPointer) 0);
   XtAddCallback (wfTB, XmNvalueChangedCallback, changeDisplayCB,
      (XtPointer) 1);

   /* HACK HERE - A radio box does not allow for accelerator keys, so
    * I added them to buttons in the menu bar.  The menu bar CB calls
    * a function that sets the radiobox button, and the valuechanged
    * CB does the rest.  However, the radiobox can get confused when
    * mouse and acc key are intermixed.  These disarm CBs seem to fix it
    */ 
   XtAddCallback (saTB, XmNdisarmCallback, controlsBtnCB,
      (XtPointer) saTB);
   XtAddCallback (wfTB, XmNdisarmCallback, controlsBtnCB,
      (XtPointer) wfTB);

   /*
    * Bandwidth radio box buttons
    */
   XtAddCallback (broadTB,  XmNvalueChangedCallback, bwCB, (XtPointer) 2);
   XtAddCallback (mediumTB, XmNvalueChangedCallback, bwCB, (XtPointer) 4);
   XtAddCallback (narrowTB, XmNvalueChangedCallback, bwCB, (XtPointer) 8);

   /* see hack above */
   XtAddCallback (broadTB, XmNdisarmCallback, controlsBtnCB,
      (XtPointer) broadTB);
   XtAddCallback (mediumTB, XmNdisarmCallback, controlsBtnCB,
      (XtPointer) mediumTB);
   XtAddCallback (narrowTB, XmNdisarmCallback, controlsBtnCB,
      (XtPointer) narrowTB);

   /*
    * T/R Menu buttons and Radio box buttons
    */
   XtAddCallback (rxTB, XmNvalueChangedCallback, rxCB, (XtPointer) 0);
   XtAddCallback (txTB, XmNvalueChangedCallback, txCB, (XtPointer) 0);
   XtAddCallback (tuneTB, XmNvalueChangedCallback, tuneCB, (XtPointer) 0);

   /* see hack above */
   XtAddCallback (rxTB, XmNdisarmCallback, controlsBtnCB,
      (XtPointer) rxTB);
   XtAddCallback (txTB, XmNdisarmCallback, controlsBtnCB,
      (XtPointer) txTB);
   XtAddCallback (tuneTB, XmNdisarmCallback, controlsBtnCB,
      (XtPointer) tuneTB);

   /*
    * Open Secondary Decoder CB
    */
   XtAddCallback (openBtn, XmNactivateCallback, openBtnCB, NULL);

   /*
    * Rx and Tx freq arrows
    */
   XtAddCallback (rxUpArrow, XmNactivateCallback, arrowCB,
      (XtPointer) rxFreqTF);
   XtAddCallback (rxDnArrow, XmNactivateCallback, arrowCB,
      (XtPointer) rxFreqTF);
   XtAddCallback (txUpArrow, XmNactivateCallback, arrowCB,
      (XtPointer) txFreqTF);
   XtAddCallback (txDnArrow, XmNactivateCallback, arrowCB,
      (XtPointer) txFreqTF);
  
   /*
    * Rx and Tx freqTF
    */
   XtAddCallback (rxFreqTF, XmNfocusCallback, rxFreqFocusCB,
      (XtPointer)&pskwids);
   XtAddCallback (rxFreqTF, XmNlosingFocusCallback, rxFreqFocusCB,
      (XtPointer)&pskwids);
   XtAddCallback (rxFreqTF, XmNmodifyVerifyCallback, freqTextCB,
      (XtPointer) NULL);
   XtAddCallback (rxFreqTF, XmNactivateCallback, freqTextCB,
      (XtPointer) NULL);
   XtAddCallback (txFreqTF, XmNmodifyVerifyCallback, freqTextCB,
      (XtPointer) NULL);
   XtAddCallback (txFreqTF, XmNactivateCallback, freqTextCB,
      (XtPointer) NULL);
   
   /*
    * mode toggle buttons
    */
   XtAddCallback (afcTB, XmNvalueChangedCallback, afcCB, (XtPointer) NULL);
   XtAddCallback (netTB, XmNvalueChangedCallback, netCB, (XtPointer) NULL);
   XtAddCallback (qpskTB, XmNvalueChangedCallback, qpskCB, (XtPointer) NULL);
   XtAddCallback (lsbTB, XmNvalueChangedCallback, lsbCB, (XtPointer) NULL);
   XtAddCallback (dcdTB, XmNvalueChangedCallback, dcdCB, (XtPointer) NULL);

   /*
    * mixer controls
    */
   XtAddCallback (mainScale, XmNvalueChangedCallback, audioCB, (XtPointer)'m');
   XtAddCallback (mainScale, XmNdragCallback, audioCB, (XtPointer)'m');
   XtAddCallback (pcmScale, XmNvalueChangedCallback, audioCB, (XtPointer)'p');
   XtAddCallback (pcmScale, XmNdragCallback, audioCB, (XtPointer)'p');
   XtAddCallback (inScale, XmNvalueChangedCallback, audioCB, (XtPointer)'i');
   XtAddCallback (inScale, XmNdragCallback, audioCB, (XtPointer)'i');

   /*
    * brightness control
    */
   XtAddCallback (brightScale, XmNvalueChangedCallback, brightCB,
      (XtPointer)NULL);
   XtAddCallback (brightScale, XmNdragCallback, brightCB, (XtPointer)NULL);

   /*
    * FFT speed scale
    */
   XtAddCallback (fftScale, XmNvalueChangedCallback, fftScaleCB,
      (XtPointer)NULL);
   XtAddCallback (fftScale, XmNdragCallback, fftScaleCB, (XtPointer)NULL );

   /*
    * wfDA Input callback - for click to tune
    */
   XtAddCallback (wfDA, XmNinputCallback, wfCB, (XtPointer) NULL);

   /*
    * txText Modify/Verify callback - to send text
    */
   XtAddCallback (txText, XmNmodifyVerifyCallback, txTextCB, (XtPointer) 0);
   XtAddCallback (txText, XmNmotionVerifyCallback, txTextCB, (XtPointer) 0);

   /*
    * rxText Scrollbar callbacks
    */
   XtAddCallback (rxScrollBar, XmNdragCallback, rxScrollBarCB,
      (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNincrementCallback, rxScrollBarCB,
      (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNdecrementCallback, rxScrollBarCB,
      (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNpageIncrementCallback, rxScrollBarCB,
      (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNpageDecrementCallback, rxScrollBarCB,
      (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNtoTopCallback, rxScrollBarCB,
      (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNtoBottomCallback, rxScrollBarCB,
      (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNvalueChangedCallback, rxScrollBarCB,
      (XtPointer) this);

   /*
    * expose callback for scope
    */
   XtAddCallback (scopeDA, XmNexposeCallback, scopeCB, (XtPointer) NULL);

   /*
    * seek callback 
    */
   XtAddCallback (upBtn, XmNactivateCallback, seekCB, (XtPointer) 'U');
   XtAddCallback (downBtn, XmNactivateCallback, seekCB, (XtPointer) 'D');
   XtAddCallback (haltBtn, XmNactivateCallback, haltCB, (XtPointer) NULL);

   /*
    * Event handler for clearing rx and tx windows
    */
   XtAddEventHandler (rxText, ButtonPressMask, False, popupHandler,
      (XtPointer) clrRxPopup);
   XtAddEventHandler (txText, ButtonPressMask, False, popupHandler,
      (XtPointer) clrTxPopup);
   XtAddEventHandler (rxTextSW, ButtonPressMask, False, popupHandler,
      (XtPointer) clrRxPopup);
   XtAddEventHandler (txTextSW, ButtonPressMask, False, popupHandler,
      (XtPointer) clrTxPopup);


   /*
    * Add actions for txText widget - sendOver, SendCall, and
    * user defined Macros 
    */
   XtActionsRec actions[] =
   {
      {"sendOver", sendOver},
      {"sendHisCall", sendHisCall},
      {"sendMacro", sendMacro}
   };

   XtAppAddActions (ac, actions, XtNumber(actions));
 
 /*
  * Manage the widgets
  */
   XtManageChild (bitsOM);
   XtManageChild (chansOM);
   XtManageChild (scForm);
   XtManageChild (scRC);
   XtManageChild (imdForm);
   XtManageChild (imdFrame);
   XtManageChild (controlsRC);
   XtManageChild (modesRC);
   XtManageChild (rxComboForm);
   XtManageChild (txComboForm);
   XtManageChild (trRB);
   XtManageChild (controlsForm);
   
   XtManageChild (wfDA);
   XtManageChild (displayRB);
   XtManageChild (bwRB);
   XtManageChild (displayRC);
   XtManageChild (displayForm);

   XtManageChild (menuBar);
   XtManageChild (txTextSW);
   XtManageChild (rxTextSW);
   XtManageChild (paneWin);

   XtManageChild (mainform);

   XtRealizeWidget(shell);
   
   /* Misc. widget stuff */
   XtVaGetValues (rxScrollBar,
      XmNtroughColor, &darkBG,
      XmNbackground, &lightBG,
      NULL);

   XtVaSetValues (rxTB,
      XmNbackground, darkBG,
      NULL);
      
   rxtTB[0] = rxTB;
   rxtTB[1] = txTB;
   rxtTB[2] = tuneTB;
}


/*
 * createButtons - creates buttons and their callbacks
 * for file cascade from the buttonNames resource. Then
 * creates a seperator, the QRT button, and all the callbacks.
 */

void Wids::createButtons (Widget shell, char *buttonNames)
{
   int cnt = 0;
   char *buttonPtrs[MAX_BUTTONS];
   char file_acc_text[12] = "Ctrl-";
   char file_acc_num[2];
   char file_acc_key[12];
   Widget fileBtns, sep, QRT;

   /*
    * break buttonNames into strings
    */
   if ((buttonPtrs[cnt] = strtok (buttonNames,",")) == NULL)
   {
      return;
   }
   cnt++;

   while ((buttonPtrs[cnt] = strtok (NULL,",")) != NULL)
   {
      if (cnt >= MAX_BUTTONS)
      {
         fprintf (stderr,"Too many file names defined in Twpsk\n");
         exit (0);
      }
      cnt++;
   }

   /*
    * create the buttons
    */   
   for (i=0; i<cnt; i++)
   {
      /* for accelerator text */
      strcpy (file_acc_text, "Ctrl-");
      sprintf (file_acc_num, "%d", i+1);
      strcat (file_acc_text, file_acc_num);
      xs[0] = XmStringCreateLocalized (file_acc_text);

      /* for accelerator key */
      strcpy (file_acc_key, "Ctrl<Key>");
      strcat (file_acc_key, file_acc_num);

      fileBtns = XtVaCreateManagedWidget(buttonPtrs[i],
         xmPushButtonWidgetClass, fileMenu,
         XmNaccelerator, file_acc_key,
         XmNacceleratorText, xs[0],
         XmNuserData, (XtPointer) buttonPtrs[i], /*buton name */
         NULL);

      XmStringFree (xs[0]);

      XtAddCallback (fileBtns, XmNactivateCallback, fileCB, (XtPointer) shell);
   }

   /*
    * Now create a seperator and the QRT button, and its callback
    */
   sep = XtVaCreateManagedWidget ("sep", xmSeparatorWidgetClass,
      fileMenu,
      NULL);

   xs[0] = XmStringCreateLocalized ("Ctrl-Q");
   QRT = XtVaCreateManagedWidget("QRT",xmPushButtonWidgetClass,fileMenu,
      XmNaccelerator, "Ctrl<Key>Q",
      XmNacceleratorText, xs[0],
      XmNmnemonic, 'Q',
      XmNmnemonicCharSet, XmFONTLIST_DEFAULT_TAG,
      NULL);

   XmStringFree (xs[0]);
   XtAddCallback (QRT, XmNactivateCallback, quitCB, (XtPointer) 0);
}
